/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.Problem;
import de.dal33t.powerfolder.disk.problem.ProblemListener;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.information.InformationCard;
import de.dal33t.powerfolder.ui.information.InformationCardType;
import de.dal33t.powerfolder.ui.information.folder.files.FilesTab;
import de.dal33t.powerfolder.ui.information.folder.members.MembersExpertTab;
import de.dal33t.powerfolder.ui.information.folder.members.MembersSimpleTab;
import de.dal33t.powerfolder.ui.information.folder.members.MembersTab;
import de.dal33t.powerfolder.ui.information.folder.problems.ProblemsTab;
import de.dal33t.powerfolder.ui.information.folder.settings.SettingsTab;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Image;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class FolderInformationCard
extends InformationCard {
    private FolderInfo folderInfo;
    private JTabbedPane tabbedPane;
    private FilesTab filesTab = ConfigurationEntry.FILES_ENABLED.getValueBoolean(this.getController()) != false ? new FilesTab(this.getController()) : null;
    private MembersTab membersTab = ConfigurationEntry.MEMBERS_ENABLED.getValueBoolean(this.getController()).booleanValue() ? (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue() && PreferencesEntry.SHOW_DEVICES.getValueBoolean(this.getController()).booleanValue() ? new MembersExpertTab(this.getController()) : new MembersSimpleTab(this.getController())) : null;
    private SettingsTab settingsTab = ConfigurationEntry.SETTINGS_ENABLED.getValueBoolean(this.getController()) != false ? new SettingsTab(this.getController()) : null;
    private ProblemsTab problemsTab = new ProblemsTab(this.getController());
    private final ProblemListener problemListener = new MyProblemListener();

    public FolderInformationCard(Controller controller) {
        super(controller);
        this.initialize();
        this.buildUIComponent();
        this.updateProblems();
    }

    @Override
    public InformationCardType getInformationCardType() {
        return InformationCardType.FOLDER;
    }

    private void setFolderInfo0(FolderInfo folderInfo) {
        this.folderInfo = folderInfo;
        if (this.membersTab != null) {
            this.membersTab.setFolderInfo(folderInfo);
        }
        if (this.settingsTab != null) {
            this.settingsTab.setFolderInfo(folderInfo);
        }
        this.problemsTab.setFolderInfo(folderInfo);
    }

    public void setFileInfo(FileInfo fileInfo) {
        if (fileInfo.isDeleted()) {
            this.setFolderInfoDeleted(fileInfo.getFolderInfo());
        } else {
            this.setFolderInfo(fileInfo.getFolderInfo());
        }
        String string = fileInfo.getFilenameOnly();
        String string2 = fileInfo.getRelativeName().replace(string, "");
        if (StringUtils.isNotBlank(string2) && this.filesTab != null) {
            this.filesTab.selectionChanged(string2);
        }
    }

    public void setFolderInfo(FolderInfo folderInfo) {
        this.detachProblemListener();
        this.setFolderInfo0(folderInfo);
        if (this.filesTab != null) {
            this.filesTab.setFolderInfo(folderInfo);
        }
        this.atachProblemListener();
        this.updateProblems();
    }

    public void setFolderInfoLatest(FolderInfo folderInfo) {
        this.detachProblemListener();
        this.setFolderInfo0(folderInfo);
        if (this.filesTab != null) {
            this.filesTab.setFolderInfoLatest(folderInfo);
        }
        this.atachProblemListener();
        this.updateProblems();
    }

    public void setFolderInfoDeleted(FolderInfo folderInfo) {
        this.detachProblemListener();
        this.setFolderInfo0(folderInfo);
        if (this.filesTab != null) {
            this.filesTab.setFolderInfoDeleted(folderInfo);
        }
        this.atachProblemListener();
        this.updateProblems();
    }

    public void setFolderInfoUnsynced(FolderInfo folderInfo) {
        this.detachProblemListener();
        this.setFolderInfo0(folderInfo);
        if (this.filesTab != null) {
            this.filesTab.setFolderInfoUnsynced(folderInfo);
        }
        this.atachProblemListener();
        this.updateProblems();
    }

    private void detachProblemListener() {
        Folder folder;
        if (this.folderInfo != null && (folder = this.getController().getFolderRepository().getFolder(this.folderInfo)) != null) {
            folder.removeProblemListener(this.problemListener);
        }
    }

    private void atachProblemListener() {
        this.getController().getFolderRepository().getFolder(this.folderInfo).addProblemListener(this.problemListener);
    }

    private void updateProblems() {
        if (this.folderInfo == null) {
            this.removeProblemsTab();
        } else {
            List<Problem> list = this.getController().getFolderRepository().getFolder(this.folderInfo).getProblems();
            if (list.isEmpty()) {
                this.removeProblemsTab();
            } else if (this.tabbedPane.getComponentCount() <= this.getProblemsTabIndex()) {
                this.addProblemsTab();
            }
            this.problemsTab.updateProblems(list);
        }
    }

    private void addProblemsTab() {
        this.tabbedPane.addTab(Translation.get("folder_information_card.problems.title"), this.problemsTab.getUIComponent());
        this.tabbedPane.setToolTipTextAt(this.getProblemsTabIndex(), Translation.get("folder_information_card.problems.tips"));
    }

    private void removeProblemsTab() {
        if (this.tabbedPane.getComponentCount() >= 1 + this.getProblemsTabIndex()) {
            this.tabbedPane.remove(this.getProblemsTabIndex());
        }
    }

    @Override
    public Image getCardImage() {
        return Icons.getImageById("folder.icon");
    }

    @Override
    public String getCardTitle() {
        return this.folderInfo.getLocalizedName();
    }

    @Override
    public JComponent getUIComponent() {
        return this.tabbedPane;
    }

    private void initialize() {
        this.tabbedPane = new JTabbedPane();
    }

    private void buildUIComponent() {
        if (this.filesTab != null) {
            this.tabbedPane.addTab(Translation.get("folder_information_card.files.title"), this.filesTab.getUIComponent());
            this.tabbedPane.setToolTipTextAt(FolderInformationCard.getFilesTabIndex(), Translation.get("folder_information_card.files.tips"));
        }
        if (this.membersTab != null) {
            this.tabbedPane.addTab(Translation.get("folder_information_card.members.title"), this.membersTab.getUIComponent());
            this.tabbedPane.setToolTipTextAt(FolderInformationCard.getMembersTabIndex(), Translation.get("folder_information_card.members.tips"));
        }
        if (this.settingsTab != null) {
            JScrollPane jScrollPane = new JScrollPane(this.settingsTab.getUIComponent(), 20, 31);
            UIUtil.removeBorder(jScrollPane);
            this.tabbedPane.addTab(Translation.get("folder_information_card.settings.title"), jScrollPane);
            this.tabbedPane.setToolTipTextAt(this.getSettingsTabIndex(), Translation.get("folder_information_card.settings.tips"));
        }
    }

    public void showFiles() {
        ((JTabbedPane)this.getUIComponent()).setSelectedIndex(FolderInformationCard.getFilesTabIndex());
    }

    public void showMembers() {
        if (this.getController().isBackupOnly()) {
            this.logSevere("Called showMembers() for a backup only client ?!");
        } else {
            ((JTabbedPane)this.getUIComponent()).setSelectedIndex(FolderInformationCard.getMembersTabIndex());
        }
    }

    public void showSettings() {
        ((JTabbedPane)this.getUIComponent()).setSelectedIndex(this.getSettingsTabIndex());
    }

    public void moveLocalFolder() {
        Folder folder = this.getController().getFolderRepository().getFolder(this.folderInfo);
        if (folder != null) {
            this.getApplicationModel().moveLocalFolder(folder);
        }
    }

    public void showProblems() {
        ((JTabbedPane)this.getUIComponent()).setSelectedIndex(this.getProblemsTabIndex());
    }

    private static int getFilesTabIndex() {
        return 0;
    }

    private static int getMembersTabIndex() {
        return 1;
    }

    private int getSettingsTabIndex() {
        int n = 2;
        if (!ConfigurationEntry.MEMBERS_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            --n;
        }
        if (!ConfigurationEntry.SETTINGS_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            --n;
        }
        return this.getController().isBackupOnly() ? 1 : n;
    }

    private int getProblemsTabIndex() {
        int n = 3;
        if (!ConfigurationEntry.FILES_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            --n;
        }
        if (!ConfigurationEntry.MEMBERS_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            --n;
        }
        if (!ConfigurationEntry.SETTINGS_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
            --n;
        }
        return n;
    }

    private class MyProblemListener
    implements ProblemListener {
        private MyProblemListener() {
        }

        @Override
        public void problemAdded(Problem problem) {
            FolderInformationCard.this.updateProblems();
        }

        @Override
        public void problemRemoved(Problem problem) {
            FolderInformationCard.this.updateProblems();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

