/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.UIController;
import de.dal33t.powerfolder.ui.dialog.GenericDialog;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.dialog.directory.DirectoryChooser;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.LinkedTextBuilder;
import de.dal33t.powerfolder.ui.util.NeverAskAgainResponse;
import de.dal33t.powerfolder.ui.widget.LinkJButton;
import de.dal33t.powerfolder.util.Translation;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DialogFactory {
    public static List<Path> chooseDirectory(UIController uIController, String string, boolean bl) {
        Path path = string != null ? Paths.get(string, new String[0]) : null;
        return DialogFactory.chooseDirectory(uIController, path, bl);
    }

    public static List<Path> chooseDirectory(UIController uIController, Path path, boolean bl) {
        return DialogFactory.chooseDirectory(uIController, path, null, bl);
    }

    public static List<Path> chooseDirectory(UIController uIController, Path path, List<String> list, boolean bl) {
        DirectoryChooser directoryChooser = new DirectoryChooser(uIController.getController(), path, list, bl);
        directoryChooser.open();
        if (directoryChooser.getSelectedDirs() != null) {
            return directoryChooser.getSelectedDirs();
        }
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(bl);
        if (path != null) {
            jFileChooser.setCurrentDirectory(path.toFile());
        }
        int n = jFileChooser.showDialog(uIController.getActiveFrame(), Translation.get("general.select"));
        ArrayList<Path> arrayList = new ArrayList<Path>();
        if (n == 0) {
            File[] fileArray;
            for (File file : fileArray = jFileChooser.getSelectedFiles()) {
                arrayList.add(file.toPath());
            }
        }
        return arrayList;
    }

    public static JFileChooser createFileChooser() {
        return new JFileChooser();
    }

    public static void genericDialog(Controller controller, String string, String string2, GenericDialogType genericDialogType) {
        DialogFactory.genericDialog(controller, string, string2, new String[]{Translation.get("general.ok")}, 0, genericDialogType);
    }

    public static void genericDialog(Controller controller, String string, String string2, boolean bl, Throwable throwable) {
        Object object = bl && throwable != null ? string2 + "\nReason: " + throwable.toString() : string2;
        DialogFactory.genericDialog(controller, string, (String)object, new String[]{Translation.get("general.ok")}, 0, GenericDialogType.ERROR);
    }

    public static int genericDialog(Controller controller, String string, String string2, String[] stringArray, int n, GenericDialogType genericDialogType) {
        return DialogFactory.genericDialog(controller, string, string2, stringArray, n, null, genericDialogType);
    }

    public static int genericDialog(Controller controller, String string, String string2, String[] stringArray, int n, String string3, GenericDialogType genericDialogType) {
        PanelBuilder panelBuilder = LinkedTextBuilder.build(controller, string2);
        return DialogFactory.genericDialog(controller, string, panelBuilder.getPanel(), stringArray, n, string3, genericDialogType);
    }

    public static int genericDialog(Controller controller, String string, JPanel jPanel, String[] stringArray, int n, GenericDialogType genericDialogType) {
        return DialogFactory.genericDialog(controller, string, jPanel, stringArray, n, null, genericDialogType);
    }

    public static int genericDialog(Controller controller, String string, JPanel jPanel, String[] stringArray, int n, String string2, GenericDialogType genericDialogType) {
        LinkJButton linkJButton = null;
        if (string2 != null) {
            linkJButton = Help.createWikiLinkButton(controller, string2);
        }
        GenericDialog genericDialog = new GenericDialog(controller.getUIController().getActiveFrame(), string, jPanel, genericDialogType, stringArray, n, null, linkJButton);
        return genericDialog.display();
    }

    public static NeverAskAgainResponse genericDialog(Controller controller, String string, String string2, String[] stringArray, int n, GenericDialogType genericDialogType, String string3) {
        PanelBuilder panelBuilder = LinkedTextBuilder.build(controller, string2);
        return DialogFactory.genericDialog(controller, string, panelBuilder.getPanel(), stringArray, n, genericDialogType, string3);
    }

    public static NeverAskAgainResponse genericDialog(Controller controller, String string, JPanel jPanel, String[] stringArray, int n, GenericDialogType genericDialogType, String string2) {
        GenericDialog genericDialog = new GenericDialog(controller.getUIController().getActiveFrame(), string, jPanel, genericDialogType, stringArray, n, string2, null);
        return new NeverAskAgainResponse(genericDialog.display(), genericDialog.isNeverAskAgain());
    }

    public static String inputDialog(Controller controller, String string, String string2, String string3) {
        return (String)JOptionPane.showInputDialog(controller.getUIController().getActiveFrame(), string2, string, -1, null, null, string3);
    }
}

