/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.dialog;

import com.jgoodies.binding.value.Trigger;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.preferences.HTTPProxySettingsDialog;
import de.dal33t.powerfolder.ui.util.Help;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.SimpleComponentFactory;
import de.dal33t.powerfolder.ui.util.SwingWorker;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Vector;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;

public class ConfigurationLoaderDialog
extends PFUIComponent {
    private final Vector<String> serviceProviderUrls = new Vector();
    private String initialText;
    private JFrame frame;
    private JComboBox<String> addressBox;
    private JComponent proxySettingsLabel;
    private JProgressBar progressBar;
    private JLabel infoLabel;
    private JButton okButton;
    private JCheckBox neverAskAgainBox;
    private Object haltLock = new Object();
    private Trigger finishedTrigger;

    public ConfigurationLoaderDialog(Controller controller, String string) {
        super(controller);
        this.initialText = string;
    }

    public ConfigurationLoaderDialog(Controller controller) {
        super(controller);
    }

    public ConfigurationLoaderDialog(Controller controller, Trigger trigger) {
        super(controller);
        this.finishedTrigger = trigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openAndWait() {
        block5: {
            try {
                UIUtil.invokeAndWaitInEDT(new Runnable(){

                    @Override
                    public void run() {
                        ConfigurationLoaderDialog.this.getFrame().setAlwaysOnTop(true);
                        ConfigurationLoaderDialog.this.getFrame().setVisible(true);
                        ConfigurationLoaderDialog.this.getFrame().setAlwaysOnTop(false);
                    }
                });
                if (EventQueue.isDispatchThread()) break block5;
                Object object = this.haltLock;
                synchronized (object) {
                    this.haltLock.wait();
                }
            }
            catch (Exception exception) {
                this.logSevere(exception);
            }
        }
    }

    private JFrame getFrame() {
        if (this.frame == null) {
            this.initComponents();
            FormLayout formLayout = new FormLayout("max(p;150dlu), 3dlu, p", "p, 7dlu, p, 3dlu, p, 7dlu, p, 7dlu, 12dlu, 14dlu, p");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            panelBuilder.setDefaultDialogBorder();
            CellConstraints cellConstraints = new CellConstraints();
            int n = 1;
            panelBuilder.addLabel(Translation.get("config.loader.dialog.info"), cellConstraints.xyw(1, n, 3));
            panelBuilder.add(this.addressBox, cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)Help.createWikiLinkButton(this.getController(), "Server_client_deployment"), cellConstraints.xy(3, n));
            panelBuilder.add((Component)this.proxySettingsLabel, cellConstraints.xywh(1, n += 2, 1, 1, "right, center"));
            panelBuilder.add((Component)this.neverAskAgainBox, cellConstraints.xy(1, n += 2));
            panelBuilder.add((Component)this.progressBar, cellConstraints.xyw(1, n += 2, 3));
            panelBuilder.add((Component)this.infoLabel, cellConstraints.xyw(1, n, 3));
            Component component = this.buildButtonBar();
            panelBuilder.add(component, cellConstraints.xyw(1, n += 2, 3));
            panelBuilder.getPanel().setBackground(Color.WHITE);
            this.frame = new JFrame(this.getTitle());
            this.frame.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
            this.frame.setIconImage(Icons.getImageById("powerfolder_32.icon"));
            this.frame.setResizable(false);
            this.frame.setDefaultCloseOperation(0);
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    ConfigurationLoaderDialog.this.exit();
                }
            });
            this.frame.getContentPane().add(panelBuilder.getPanel());
            this.frame.getRootPane().setDefaultButton(this.okButton);
            this.frame.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.setLocation((dimension.width - this.frame.getWidth()) / 2, (dimension.height - this.frame.getHeight() - 200) / 2);
            this.progressBar.setVisible(false);
            this.infoLabel.setVisible(false);
        }
        return this.frame;
    }

    private void addServerURL(String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        if (!string.contains("utm_source") && !this.serviceProviderUrls.contains(string)) {
            this.serviceProviderUrls.add(string);
        }
    }

    private void initComponents() {
        if (StringUtils.isNotBlank(ConfigurationEntry.CONFIG_URL.getValue(this.getController()))) {
            this.addServerURL(ConfigurationEntry.CONFIG_URL.getValue(this.getController()));
        }
        if (this.getController().getOSClient() != null && this.getController().getOSClient().hasWebURL()) {
            this.addServerURL(this.getController().getOSClient().getWebURL());
        }
        if (ConfigurationEntry.PROVIDER_URL.hasValue(this.getController())) {
            this.addServerURL(ConfigurationEntry.PROVIDER_URL.getValue(this.getController()));
        }
        this.addressBox = new JComboBox<String>(this.serviceProviderUrls);
        this.addressBox.setEditable(true);
        try {
            JTextField jTextField = (JTextField)this.addressBox.getEditor().getEditorComponent();
            if (StringUtils.isNotBlank(this.initialText)) {
                jTextField.setText(this.initialText);
            } else {
                jTextField.setText("https://");
            }
            jTextField.setCaretPosition(jTextField.getText().length());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.proxySettingsLabel = new ActionLabel(this.getController(), new AbstractAction(Translation.get("general.proxy_settings")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HTTPProxySettingsDialog(ConfigurationLoaderDialog.this.getController(), ConfigurationLoaderDialog.this.frame).open();
            }
        }).getUIComponent();
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.infoLabel = SimpleComponentFactory.createLabel("X");
        this.neverAskAgainBox = SimpleComponentFactory.createCheckBox(Translation.get("general.neverAskAgain"));
        this.neverAskAgainBox.setVisible(false);
        try {
            boolean bl = ConfigurationEntry.CONFIG_PROMPT_SERVER_IF_PF_COM.getValueBoolean(this.getController());
            boolean bl2 = ServerClient.isPowerFolderCloud(this.getController());
            boolean bl3 = this.getController().getDistribution().isBrandedClient();
            this.neverAskAgainBox.setVisible(bl && bl2 && !bl3);
        }
        catch (Exception exception) {
            this.logWarning(exception.toString());
        }
    }

    private String getTitle() {
        return Translation.get("config.loader.dialog.title");
    }

    private Component buildButtonBar() {
        JPanel jPanel;
        this.okButton = ConfigurationLoaderDialog.createOKButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationLoaderDialog.this.showProgressBar();
                new LoadingWorking().start();
            }
        });
        JButton jButton = new JButton(Translation.get("config.loader.dialog.skip"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationLoaderDialog.this.frame.setVisible(false);
                ConfigurationLoaderDialog.this.frame.dispose();
                ConfigurationLoaderDialog.this.mainProgrammContinue();
            }
        });
        JButton jButton2 = new JButton(Translation.get("config.loader.dialog.exit"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationLoaderDialog.this.exit();
            }
        });
        if (this.getController().isStarted()) {
            jButton.setText(Translation.get("general.cancel"));
            jPanel = ButtonBarFactory.buildCenteredBar(this.okButton, jButton);
        } else {
            jPanel = ButtonBarFactory.buildCenteredBar(this.okButton, jButton2);
        }
        jPanel.setOpaque(false);
        return jPanel;
    }

    private void showProgressBar() {
        this.infoLabel.setVisible(false);
        this.progressBar.setVisible(true);
    }

    private void showInfo(String string) {
        this.infoLabel.setText(string);
        this.progressBar.setVisible(false);
        this.infoLabel.setVisible(true);
    }

    private static JButton createOKButton(ActionListener actionListener) {
        JButton jButton = new JButton(Translation.get("general.ok"));
        jButton.setMnemonic(Translation.get("general.ok.key").trim().charAt(0));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private void exit() {
        this.frame.setVisible(false);
        this.frame.dispose();
        this.mainProgrammContinue();
        this.getController().exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainProgrammContinue() {
        Object object = this.haltLock;
        synchronized (object) {
            this.haltLock.notifyAll();
        }
    }

    private void saveConfig() {
        if (this.getController().isStarted()) {
            this.getController().saveConfig();
        } else {
            this.getController().schedule(() -> this.getController().saveConfig(), 5000L);
        }
    }

    private class LoadingWorking
    extends SwingWorker {
        private Throwable t;

        private LoadingWorking() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object construct() throws IOException {
            Properties properties;
            block18: {
                properties = null;
                String string = (String)ConfigurationLoaderDialog.this.addressBox.getSelectedItem();
                try {
                    properties = this.loadFromInput(string);
                }
                catch (IOException iOException) {
                    ConfigurationLoaderDialog.this.logWarning("Unable to load config from " + string + ": " + iOException);
                    this.t = iOException;
                    if (!StringUtils.isNotBlank(string) || string.indexOf(":", 7) >= 0) break block18;
                    try {
                        properties = this.loadFromInput(string + ":8080");
                    }
                    catch (IOException iOException2) {
                        if (string.toLowerCase().startsWith("http")) break block18;
                        Socket socket = null;
                        try {
                            InetSocketAddress inetSocketAddress = Util.parseConnectionString(string);
                            socket = new Socket();
                            socket.connect(inetSocketAddress, 30000);
                            if (socket.isConnected()) {
                                ConfigurationLoaderDialog.this.logInfo("Got direct TCP connect to server " + string);
                                ConfigurationEntry.SERVER_HOST.setValue(ConfigurationLoaderDialog.this.getController(), string);
                                ConfigurationEntry.SERVER_NODEID.removeValue(ConfigurationLoaderDialog.this.getController());
                                ConfigurationEntry.SERVER_WEB_URL.removeValue(ConfigurationLoaderDialog.this.getController());
                                properties = new Properties();
                                properties.put(ConfigurationEntry.SERVER_HOST.getConfigKey(), string);
                                properties.put(ConfigurationEntry.SERVER_WEB_URL.getConfigKey(), "http://" + string + ":8080");
                            }
                        }
                        catch (Exception exception) {
                            ConfigurationLoaderDialog.this.logInfo("Not direct TCP connect possible to " + string + ". " + exception);
                        }
                        finally {
                            try {
                                if (socket != null) {
                                    socket.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            if (properties != null && !properties.isEmpty() && this.containsServerHost(properties)) {
                ConfigurationLoader.merge(properties, ConfigurationLoaderDialog.this.getController().getConfig(), ConfigurationLoaderDialog.this.getController().getPreferences(), true);
                ConfigurationLoaderDialog.this.saveConfig();
            }
            return properties;
        }

        private Properties loadFromInput(String string) throws IOException {
            ConfigurationEntry.CONFIG_URL.setValue(ConfigurationLoaderDialog.this.getController(), string);
            ConfigurationLoaderDialog.this.saveConfig();
            Properties properties = ConfigurationLoader.loadPreConfiguration(string);
            if (properties != null && !this.containsServerWeb(properties)) {
                Object object = Util.removeLastSlashFromURI(string);
                if (!((String)object).startsWith("http")) {
                    object = "https://" + (String)object;
                }
                ConfigurationLoaderDialog.this.logWarning("Server web URL not found in client config. Using fallback: " + (String)object);
                properties.put(ConfigurationEntry.SERVER_WEB_URL.getConfigKey(), object);
            }
            return properties;
        }

        @Override
        public void finished() {
            Properties properties = (Properties)this.get();
            Throwable throwable = this.getThrowable();
            if (throwable == null) {
                throwable = this.t;
            }
            String string = null;
            if (properties == null) {
                string = Translation.get("config.loader.dialog.error.generic");
                if (throwable != null) {
                    string = throwable instanceof FileNotFoundException ? Translation.get("config.loader.dialog.error.config.notfound") : (throwable instanceof MalformedURLException ? Translation.get("config.loader.dialog.error.address.invalid") : (throwable instanceof IllegalArgumentException ? Translation.get("config.loader.dialog.error.address.invalid") : (throwable instanceof UnknownHostException ? Translation.get("config.loader.dialog.error.host.notfound") : (throwable instanceof SSLHandshakeException ? Translation.get("config.loader.dialog.error.ssl") : throwable.getMessage()))));
                }
            } else if (properties.size() == 0) {
                string = Translation.get("config.loader.dialog.error.config.empty");
            } else if (!this.containsServerHost(properties)) {
                string = Translation.get("config.loader.dialog.error.server.missing");
            }
            if (string != null) {
                ConfigurationLoaderDialog.this.showInfo(Translation.get("config.loader.dialog.error", string));
                return;
            }
            ConfigurationLoaderDialog.this.showInfo(Translation.get("config.loader.dialog.loaded", String.valueOf(properties.size())));
            ConfigurationLoaderDialog.this.frame.setVisible(false);
            ConfigurationLoaderDialog.this.frame.dispose();
            ConfigurationLoaderDialog.this.mainProgrammContinue();
            if (ConfigurationLoaderDialog.this.neverAskAgainBox.isSelected() && ConfigurationEntry.CONFIG_PROMPT_SERVER_IF_PF_COM.getValueBoolean(ConfigurationLoaderDialog.this.getController()).booleanValue()) {
                ConfigurationEntry.CONFIG_PROMPT_SERVER_IF_PF_COM.setValue(ConfigurationLoaderDialog.this.getController(), false);
                ConfigurationLoaderDialog.this.saveConfig();
            }
            if (ConfigurationLoaderDialog.this.finishedTrigger != null) {
                ConfigurationLoaderDialog.this.finishedTrigger.triggerCommit();
            }
            if (ConfigurationLoaderDialog.this.getController().isStarted()) {
                this.handleRestartRequest();
            }
        }

        private boolean containsServerHost(Properties properties) {
            return properties.containsKey(ConfigurationEntry.SERVER_HOST.getConfigKey());
        }

        private boolean containsServerWeb(Properties properties) {
            return properties.containsKey(ConfigurationEntry.SERVER_WEB_URL.getConfigKey());
        }

        private void handleRestartRequest() {
            int n = DialogFactory.genericDialog(ConfigurationLoaderDialog.this.getController(), Translation.get("preferences.dialog.restart.title"), Translation.get("preferences.dialog.restart.text"), new String[]{Translation.get("preferences.dialog.restart.restart"), Translation.get("general.cancel")}, 0, GenericDialogType.QUESTION);
            if (n == 0) {
                ConfigurationLoaderDialog.this.getUIController().closePreferencesDialog();
                ConfigurationLoaderDialog.this.getController().shutdownAndRequestRestart();
            }
        }
    }
}

