/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.action;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.ui.wizard.FolderCreateItem;
import de.dal33t.powerfolder.ui.wizard.FolderCreatePanel;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class NewFolderAction
extends BaseAction {
    public NewFolderAction(Controller controller) {
        super("action_new_folder", controller);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                NewFolderAction.this.getUIController().getApplicationModel().getServerClientModel().checkAndSetupAccount();
                FolderRepository folderRepository = NewFolderAction.this.getController().getFolderRepository();
                folderRepository.setSuspendNewFolderSearch(true);
                try {
                    String string = DialogFactory.inputDialog(NewFolderAction.this.getController(), Translation.get("dialog.new_folder_name.title"), Translation.get("dialog.new_folder_name.prompt"), "");
                    if (StringUtils.isBlank(string)) {
                        return;
                    }
                    string = string.trim();
                    Path path = folderRepository.getFoldersBasedir();
                    Path path2 = path.resolve(PathUtils.removeInvalidFilenameChars(string));
                    if (NewFolderAction.this.syncFolderWithSamePath(path2) || NewFolderAction.this.ownsFolderWithSameName(string)) {
                        DialogFactory.genericDialog(NewFolderAction.this.getController(), Translation.get("general.directory"), Translation.get("general.folder_already_exists", string), GenericDialogType.ERROR);
                        return;
                    }
                    FolderCreatePanel folderCreatePanel = new FolderCreatePanel(NewFolderAction.this.getController());
                    TextPanelPanel textPanelPanel = new TextPanelPanel(NewFolderAction.this.getController(), Translation.get("wizard.setup_success"), Translation.get("wizard.what_to_do.folder_backup_success") + Translation.get("wizard.what_to_do.pcs_join"));
                    PFWizard pFWizard = new PFWizard(NewFolderAction.this.getController(), Translation.get("wizard.pfwizard.folder_title"));
                    pFWizard.getWizardContext().setAttribute("successpanel", textPanelPanel);
                    pFWizard.getWizardContext().setAttribute("folder_create.backup_by_os", NewFolderAction.this.getController().getOSClient().isBackupByDefault());
                    FolderInfo folderInfo = FolderInfoFactory.newTopFolder(string);
                    FolderCreateItem folderCreateItem = new FolderCreateItem(path2);
                    folderCreateItem.setSyncProfile(SyncProfile.AUTOMATIC_SYNCHRONIZATION);
                    folderCreateItem.setFolderInfo(folderInfo);
                    folderCreateItem.setArchiveHistory(ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(NewFolderAction.this.getController()));
                    ArrayList<FolderCreateItem> arrayList = new ArrayList<FolderCreateItem>();
                    arrayList.add(folderCreateItem);
                    pFWizard.getWizardContext().setAttribute("disklocation.folder_create_items", arrayList);
                    pFWizard.open(folderCreatePanel);
                    return;
                }
                finally {
                    try {
                        folderRepository.setSuspendNewFolderSearch(false);
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    private boolean ownsFolderWithSameName(String string) {
        Account account = this.getController().getOSClient().getAccount();
        if (!account.isValid()) {
            return false;
        }
        for (FolderInfo folderInfo : this.getController().getOSClient().getAccount().getFoldersCharged()) {
            if (!string.equalsIgnoreCase(folderInfo.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean syncFolderWithSamePath(Path path) {
        FolderRepository folderRepository = this.getController().getFolderRepository();
        return folderRepository.findExistingFolder(path) != null;
    }
}

