/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.transfer.TransferProblem;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.TransferCounter;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;

public abstract class Transfer
extends Loggable
implements Serializable {
    private static final long serialVersionUID = 100L;
    private transient TransferManager transferManager;
    private transient Member partner;
    private MemberInfo partnerInfo;
    private FileInfo file;
    private Date startTime;
    private Date initTime;
    private long startOffset;
    private TransferCounter counter;
    private TransferProblem transferProblem;
    private String problemInformation;
    protected final State state = new State();

    public Transfer() {
    }

    protected Transfer(TransferManager transferManager, FileInfo fileInfo, Member member) {
        Reject.ifNull(transferManager, "TransferManager is null");
        Reject.ifNull(fileInfo, "FileInfo is null");
        this.transferManager = transferManager;
        this.file = fileInfo;
        this.setPartner(member);
        this.initTime = new Date();
    }

    void init(TransferManager transferManager) {
        if (this.transferManager != null) {
            this.logSevere("Unable to set TransferManager. Having already one. " + this);
            return;
        }
        this.transferManager = transferManager;
        this.partner = this.partnerInfo != null ? this.partnerInfo.getNode(this.getController(), true) : null;
        this.startTime = null;
        if (this.isCompleted()) {
            this.state.setProgress(1.0);
        }
    }

    public FileInfo getFile() {
        return this.file;
    }

    public final Member getPartner() {
        if (this.partner == null && this.partnerInfo != null) {
            return this.partnerInfo.getNode(this.getController(), true);
        }
        return this.partner;
    }

    protected final void setPartner(Member member) {
        this.partner = member;
        this.partnerInfo = this.partner != null ? member.getInfo() : null;
    }

    void shutdown() {
    }

    void setCompleted() {
        this.state.setState(TransferState.DONE);
        this.state.setProgress(1.0);
    }

    public final Date getStartTime() {
        return this.startTime;
    }

    public boolean isStarted() {
        return this.startTime != null;
    }

    protected synchronized void setStarted() {
        boolean bl = this.isStarted();
        if (!bl) {
            this.startTime = new Date();
            this.getTransferManager().setStarted(this);
        } else {
            this.logWarning("Got already started transfer", new RuntimeException("from here"));
        }
    }

    protected TransferManager getTransferManager() {
        return this.transferManager;
    }

    protected Controller getController() {
        return this.transferManager.getController();
    }

    protected Date getInitTime() {
        return this.initTime;
    }

    protected void setStartOffset(long l) {
        this.startOffset = l;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public boolean isCompleted() {
        return this.state != null && this.state.getState() != null && this.state.getState().equals((Object)TransferState.DONE);
    }

    public Date getCompletedDate() {
        return this.state != null && this.state.getCompletedDate() != null ? this.state.getCompletedDate() : null;
    }

    public TransferCounter getCounter() {
        if (this.counter == null) {
            this.counter = new TransferCounter(this.getStartOffset(), this.getFile().getSize());
        }
        return this.counter;
    }

    public boolean isBroken() {
        if (this.isCompleted()) {
            return false;
        }
        if (this.getPartner() == null) {
            if (this.isFine()) {
                this.logFine("Break cause: partner is null.");
            }
            return true;
        }
        if (!this.getPartner().isCompletelyConnected()) {
            if (this.isFine()) {
                this.logFine("Break cause: " + this.getPartner().getNick() + " not connected.");
            }
            return true;
        }
        boolean bl = this.stillPartnerOnFolder();
        if (!bl) {
            if (this.isFine()) {
                this.logFine("Break cause: " + this.getPartner().getNick() + " not on folder.");
            }
            return true;
        }
        return false;
    }

    protected boolean stillQueuedAtPartner() {
        if (this.getPartner() == null) {
            return false;
        }
        return this.getPartner().isConnected();
    }

    protected boolean stillPartnerOnFolder() {
        Folder folder = this.getFile().getFolder(this.getController().getFolderRepository());
        if (folder == null) {
            return false;
        }
        return folder.hasMember(this.getPartner());
    }

    public TransferProblem getTransferProblem() {
        return this.transferProblem;
    }

    public void setTransferProblem(TransferProblem transferProblem) {
        this.transferProblem = transferProblem;
    }

    public String getProblemInformation() {
        return this.problemInformation;
    }

    public void setProblemInformation(String string) {
        this.problemInformation = string;
    }

    public State getState() {
        return this.state;
    }

    public TransferState getTransferState() {
        return this.state == null ? null : this.state.getState();
    }

    public double getStateProgress() {
        return this.state == null ? 0.0 : this.state.getProgress();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.partnerInfo = this.partnerInfo != null ? this.partnerInfo.intern() : null;
    }

    public static class State
    implements Serializable,
    Comparable<State> {
        private static final long serialVersionUID = 100L;
        private volatile TransferState state = TransferState.NONE;
        private volatile double progress = -1.0;
        private volatile Date completedDate;

        public synchronized TransferState getState() {
            return this.state;
        }

        public synchronized void setState(TransferState transferState) {
            if (!this.state.equals((Object)transferState)) {
                this.progress = -1.0;
                this.state = transferState;
                if (transferState.equals((Object)TransferState.DONE)) {
                    this.completedDate = new Date();
                }
            }
        }

        public synchronized void setProgress(double d) {
            this.progress = d > 1.0 ? 1.0 : d;
        }

        public synchronized double getProgress() {
            return this.progress;
        }

        public Date getCompletedDate() {
            return this.completedDate;
        }

        @Override
        public int compareTo(State state) {
            int n = Integer.valueOf(this.state.orderIndex).compareTo(state.state.orderIndex);
            if (n == 0) {
                n = Double.valueOf(this.progress).compareTo(state.progress);
            }
            return n;
        }
    }

    public static enum TransferState {
        NONE("None", 10),
        FILERECORD_REQUEST("transfers.requested", 20),
        FILEHASHING("transfers.hashing", 30),
        REMOTEMATCHING("transfers.remote_hashing", 40),
        DOWNLOADING("Downloading", 50),
        UPLOADING("Uploading", 60),
        MATCHING("transfers.hashing", 70),
        COPYING("transfers.copying", 80),
        VERIFYING("transfers.verifying", 90),
        DONE("transfers.completed", 100);

        private int orderIndex;
        private String translationId;

        public int getOrderIndex() {
            return this.orderIndex;
        }

        private TransferState(String string2, int n2) {
            this.translationId = string2;
            this.orderIndex = n2;
        }

        public String getTranslationId() {
            return this.translationId;
        }
    }
}

