/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.test;

import de.dal33t.powerfolder.disk.DiskItemFilter;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.FileChunk;
import de.dal33t.powerfolder.message.FileList;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.IdGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Logger;

public class TestSerialize {
    private static final Logger log = Logger.getLogger(TestSerialize.class.getName());

    public static void main(String[] stringArray) throws IOException {
        Message[] messageArray = TestSerialize.generateTestMessages();
        for (int i = 0; i < messageArray.length; ++i) {
            long l = System.currentTimeMillis();
            byte[] byArray = ByteSerializer.serializeStatic(messageArray[i], true);
            long l2 = System.currentTimeMillis() - l;
            log.info("Serialize took " + l2 + "ms (" + byArray.length + " bytes) of " + messageArray[i]);
        }
    }

    private static Message[] generateTestMessages() {
        return new Message[]{TestSerialize.generateFileChunk(), TestSerialize.generateFileChunk(), TestSerialize.generateFileChunk(), TestSerialize.generateFileList(), TestSerialize.generateFileList(), TestSerialize.generateFileList()};
    }

    private static FileChunk generateFileChunk() {
        byte[] byArray = new byte[10240];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(Math.random() * 255.0);
        }
        return new FileChunk(TestSerialize.generateFileInfo(), 10L, byArray);
    }

    private static FileList generateFileList() {
        FileInfo[] fileInfoArray = new FileInfo[499];
        for (int i = 0; i < fileInfoArray.length; ++i) {
            fileInfoArray[i] = TestSerialize.generateFileInfo();
        }
        FileList fileList = (FileList)FileList.create4Test(TestSerialize.generateFolderInfo(), Arrays.asList(fileInfoArray), new DiskItemFilter())[0];
        return fileList;
    }

    private static FileInfo generateFileInfo() {
        String string = "subdir/" + Math.random() + "/and another/test filename.gif";
        return FileInfoFactory.unmarshallExistingFile(TestSerialize.generateFolderInfo(), string, IdGenerator.makeFileId(), (long)(Math.random() * 100000.0), TestSerialize.generateMemberInfo(), TestSerialize.generateAccountInfo(), new Date(), 0, null, false, null);
    }

    private static MemberInfo generateMemberInfo() {
        return new MemberInfo("noob", IdGenerator.makeId(), null);
    }

    private static AccountInfo generateAccountInfo() {
        return new AccountInfo("noob", IdGenerator.makeId(), null);
    }

    private static FolderInfo generateFolderInfo() {
        return FolderInfoFactory.newRandomTopFolderForTest();
    }
}

