/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.event.ListenerSupportFactory;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.security.SecurityManager;
import de.dal33t.powerfolder.security.SecurityManagerEvent;
import de.dal33t.powerfolder.security.SecurityManagerListener;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SecurityManagerClient
extends PFComponent
implements SecurityManager {
    private static final boolean CACHE_ENABLED = true;
    private static final int MAX_REQUEST_ACCOUNT_INFOS = 21;
    private static final AccountInfo NULL_ACCOUNT = new AccountInfo(null, null){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            return "Default";
        }
    };
    private SecurityManagerListener listners;
    private ServerClient client;
    private Map<Member, Session> sessions;
    private Map<AccountInfo, PermissionsCacheSegment> permissionsCacheAccounts;
    private final Object requestPermissionLock = new Object();
    private final Object requestAccountInfoLock = new Object();
    private final Map<String, Member> refreshing = Util.createConcurrentHashMap();

    public SecurityManagerClient(Controller controller, ServerClient serverClient) {
        super(controller);
        Reject.ifNull(serverClient, "Client is null");
        this.client = serverClient;
        this.sessions = new ConcurrentHashMap<Member, Session>();
        this.permissionsCacheAccounts = new ConcurrentHashMap<AccountInfo, PermissionsCacheSegment>();
        this.listners = ListenerSupportFactory.createListenerSupport(SecurityManagerListener.class);
        this.client.addListener(new MyServerClientListener());
    }

    @Override
    public Account authenticate(String string, Object object) {
        Account account = this.client.login(string, (char[])object);
        if (!account.isValid()) {
            return null;
        }
        return account;
    }

    @Override
    public Account authenticate(String string) {
        Account account = this.client.login(string);
        if (!account.isValid()) {
            return null;
        }
        return account;
    }

    @Override
    public void processAfterShibbolethLogin(Account account) {
        throw new UnsupportedOperationException("Cannot process shibboleth account on the client side.");
    }

    @Override
    public void logout() {
        this.client.logout();
    }

    @Override
    public boolean hasPermission(MemberInfo memberInfo, Permission permission) {
        Member member = memberInfo.getNode(this.getController(), true);
        if (member.isServer()) {
            return true;
        }
        if (!this.client.isConnected()) {
            return this.hasPermissionDisconnected(permission);
        }
        if (this.client.isLoggingIn()) {
            this.client.waitForLoginComplete();
        }
        if (!this.client.isLoggedIn()) {
            return this.hasPermissionDisconnected(permission);
        }
        AccountInfo accountInfo = this.getAccountInfo(member);
        if (accountInfo == null) {
            return false;
        }
        return this.hasPermission(this.getAccountInfo(member), permission);
    }

    @Override
    public boolean hasPermission(Account account, Permission permission) {
        return this.hasPermission(account != null ? account.createInfo() : null, permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPermission(AccountInfo accountInfo, Permission permission) {
        if (accountInfo != null && this.client.isLoggedIn() && this.client.getAccount().createInfo().equals(accountInfo) && this.client.getAccount().hasPermission(permission)) {
            return true;
        }
        try {
            Boolean bl;
            PermissionsCacheSegment permissionsCacheSegment = this.permissionsCacheAccounts.get(this.nullSafeGet(accountInfo));
            if (permissionsCacheSegment != null) {
                bl = permissionsCacheSegment.hasPermission(permission);
            } else {
                bl = null;
                permissionsCacheSegment = new PermissionsCacheSegment();
                this.permissionsCacheAccounts.put(this.nullSafeGet(accountInfo), permissionsCacheSegment);
            }
            if (bl == null) {
                if (this.client.isConnected() && this.client.isLoggedIn()) {
                    Object object = this.requestPermissionLock;
                    synchronized (object) {
                        PermissionsCacheSegment permissionsCacheSegment2 = this.permissionsCacheAccounts.get(this.nullSafeGet(accountInfo));
                        Boolean bl2 = bl = permissionsCacheSegment2 != null ? permissionsCacheSegment2.hasPermission(permission) : null;
                        if (bl == null) {
                            bl = this.retrievePermission(accountInfo, permission, permissionsCacheSegment);
                            String string = "recvd";
                            if (this.isFine()) {
                                this.logFine("(" + string + ") " + this.nullSafeGet(accountInfo) + " has " + (bl != false ? "" : "NOT ") + permission);
                            }
                        } else {
                            String string = "cache";
                        }
                    }
                } else {
                    bl = this.hasPermissionDisconnected(permission);
                    String string = "nocon";
                }
            } else {
                String string = "cache";
            }
            return bl;
        }
        catch (RemoteCallException remoteCallException) {
            if (this.isWarning()) {
                this.logWarning("Unable to check " + permission + " for " + this.nullSafeGet(accountInfo) + ". " + remoteCallException);
            }
            if (this.isFiner()) {
                this.logFiner(remoteCallException);
            }
            return this.hasPermissionDisconnected(permission);
        }
    }

    private Boolean retrievePermission(AccountInfo accountInfo, Permission permission, PermissionsCacheSegment permissionsCacheSegment) {
        if (accountInfo == null || accountInfo.getOID() == null) {
            return Boolean.FALSE;
        }
        if (permission instanceof FolderPermission) {
            FolderPermission folderPermission = (FolderPermission)permission;
            FolderInfo folderInfo = folderPermission.folder;
            if (this.isFine()) {
                this.logFine("Using bulk permission request for " + accountInfo + " on " + folderInfo);
            }
            ArrayList<Permission> arrayList = new ArrayList<Permission>(5);
            arrayList.add(permission);
            arrayList.add(FolderPermission.read(folderInfo));
            arrayList.add(FolderPermission.readWrite(folderInfo));
            arrayList.add(FolderPermission.admin(folderInfo));
            arrayList.add(FolderPermission.owner(folderInfo));
            try {
                List<Boolean> list = this.client.getSecurityService().hasPermissions(accountInfo, arrayList);
                permissionsCacheSegment.set(FolderPermission.read(folderInfo), list.get(1));
                permissionsCacheSegment.set(FolderPermission.readWrite(folderInfo), list.get(2));
                permissionsCacheSegment.set(FolderPermission.admin(folderInfo), list.get(3));
                permissionsCacheSegment.set(FolderPermission.owner(folderInfo), list.get(4));
                return list.get(0);
            }
            catch (RemoteCallException remoteCallException) {
                if (remoteCallException.getCause() instanceof NoSuchMethodException) {
                    this.logWarning("Unable to retrieve permissions in bulk. Falling back to legacy call. " + accountInfo + " has? " + permission);
                }
                throw remoteCallException;
            }
        }
        boolean bl = this.client.getSecurityService().hasPermission(accountInfo, permission);
        permissionsCacheSegment.set(permission, bl);
        return bl;
    }

    private Boolean hasPermissionDisconnected(Permission permission) {
        boolean bl;
        boolean bl2 = bl = this.getController().isLanOnly() && !this.client.getServer().isOnLAN() && ConfigurationEntry.SERVER_CONNECT_FROM_LAN_TO_INTERNET.getValueBoolean(this.getController()) == false;
        if (bl) {
            this.logWarning("Unable to connect to server at all. Server " + this.client.getServerString() + " on LAN? " + this.client.getServer().isOnLAN() + ". Client LAN only mode? " + this.getController().isLanOnly() + ". Client allows connect from LAN 2 Internet? " + ConfigurationEntry.SERVER_CONNECT_FROM_LAN_TO_INTERNET.getValueBoolean(this.getController()));
            return Boolean.FALSE;
        }
        if (permission instanceof FolderPermission) {
            return Feature.P2P_REQUIRES_LOGIN_AT_SERVER.isDisabled();
        }
        return ConfigurationEntry.SECURITY_PERMISSIONS_STRICT.getValueBoolean(this.getController()) == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountInfo getAccountInfo(Member member) {
        AccountInfo accountInfo;
        if (this.client.isPrimaryServer(member)) {
            return NULL_ACCOUNT;
        }
        if (member.isServer()) {
            return NULL_ACCOUNT;
        }
        if (member.isMySelf() && this.client.isLoggedIn()) {
            return this.client.getAccountInfo();
        }
        Session session = this.sessions.get(member);
        if (session != null) {
            if (this.isFiner()) {
                this.logFiner("Retured cached account for " + member + " : " + session.getAccountInfo());
            }
            return session.getAccountInfo();
        }
        if (Util.isAwtAvailable() && EventQueue.isDispatchThread()) {
            if (this.isFiner()) {
                this.logFiner("Not trying to refresh account of " + member + ". Running in EDT thread");
            }
            return null;
        }
        if (ServerClient.SERVER_HANDLE_MESSAGE_THREAD.get().booleanValue()) {
            if (this.isWarning()) {
                this.logWarning("Not trying to refresh account of " + member + ". Running handleMessage thread of Server");
            }
            return null;
        }
        if (!this.client.isConnected()) {
            return null;
        }
        try {
            Object object = this.requestAccountInfoLock;
            synchronized (object) {
                session = this.sessions.get(member);
                if (session != null) {
                    if (this.isFiner()) {
                        this.logFiner("Retured cached account for " + member + " : " + session.getAccountInfo());
                    }
                    return session.getAccountInfo();
                }
                Map<MemberInfo, AccountInfo> map = this.client.getSecurityService().getAccountInfos(Collections.singleton(member.getInfo()));
                accountInfo = map.get(member.getInfo());
                if (accountInfo == null) {
                    for (ServerClient serverClient : this.client.getChildClients().values()) {
                        if (!serverClient.isConnected() || (accountInfo = (map = serverClient.getSecurityService().getAccountInfos(Collections.singleton(member.getInfo()))).get(member.getInfo())) == null) continue;
                        if (!this.isFine()) break;
                        this.logFine("getAccountInfo for " + member + " is " + accountInfo + " from " + serverClient.getServer());
                        break;
                    }
                }
                if (accountInfo != null) {
                    accountInfo.intern(true);
                }
                if (this.isFiner()) {
                    this.logFiner("Retrieved account " + accountInfo + " for " + member);
                }
                this.sessions.put(member, new Session(accountInfo));
            }
        }
        catch (RemoteCallException remoteCallException) {
            this.logWarning("Unable to retrieve account info for " + member + ". " + remoteCallException);
            this.logFiner(remoteCallException);
            accountInfo = null;
        }
        return accountInfo;
    }

    @Override
    public void nodeAccountStateChanged(Member member, boolean bl) {
        if (!this.getController().isStarted()) {
            return;
        }
        String string = member.getId() + bl;
        if (this.refreshing.containsKey(string)) {
            return;
        }
        Refresher refresher = new Refresher(member, bl);
        if (this.getController().isStarted()) {
            this.refreshing.put(string, member);
            this.getController().getIOProvider().startIO(refresher);
        }
    }

    public void fetchAccountInfos(Collection<Member> collection, boolean bl) {
        Reject.ifNull(collection, "Nodes is null");
        try {
            if (!this.client.isConnected()) {
                return;
            }
            ArrayList<MemberInfo> arrayList = new ArrayList<MemberInfo>(collection.size());
            HashMap<MemberInfo, AccountInfo> hashMap = new HashMap<MemberInfo, AccountInfo>();
            for (Member object : collection) {
                if (!bl && this.sessions.containsKey(object)) continue;
                arrayList.add(object.getInfo());
                if (arrayList.size() < 21) continue;
                hashMap.putAll(this.client.getSecurityService().getAccountInfos(arrayList));
                arrayList.clear();
                for (ServerClient serverClient : this.client.getChildClients().values()) {
                    if (!serverClient.isConnected()) continue;
                    for (Map.Entry entry : hashMap.entrySet()) {
                        if (entry.getValue() != null) continue;
                        arrayList.add((MemberInfo)entry.getKey());
                    }
                    hashMap.putAll(serverClient.getSecurityService().getAccountInfos(arrayList));
                    arrayList.clear();
                }
            }
            if (arrayList.isEmpty()) {
                return;
            }
            if (this.isFine()) {
                this.logFine("Pre-fetching account infos for " + collection.size() + " nodes");
            }
            if (arrayList.size() > 21) {
                this.logWarning("Pre-fetching account infos for many nodes (" + collection.size() + ")");
            }
            hashMap.putAll(this.client.getSecurityService().getAccountInfos(arrayList));
            for (ServerClient serverClient : this.client.getChildClients().values()) {
                if (!serverClient.isConnected()) continue;
                arrayList.clear();
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (entry.getValue() != null) continue;
                    arrayList.add((MemberInfo)entry.getKey());
                }
                hashMap.putAll(serverClient.getSecurityService().getAccountInfos(arrayList));
            }
            if (this.isFine()) {
                this.logFine("Retrieved " + hashMap.size() + " AccountInfos for " + collection.size() + " nodes: " + hashMap);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                Member member = ((MemberInfo)entry.getKey()).getNode(this.getController(), false);
                if (member == null) continue;
                AccountInfo accountInfo = (AccountInfo)hashMap.get(member.getInfo());
                if (accountInfo != null) {
                    accountInfo.intern(true);
                }
                this.sessions.put(member, new Session(accountInfo));
                this.fireNodeAccountStateChanged(member);
            }
        }
        catch (RemoteCallException remoteCallException) {
            this.logWarning("Unable to retrieve account info for " + collection.size() + " nodes. " + remoteCallException);
            this.logFiner(remoteCallException);
        }
    }

    private AccountInfo nullSafeGet(AccountInfo accountInfo) {
        if (accountInfo == null) {
            return NULL_ACCOUNT;
        }
        return accountInfo;
    }

    private void clearNodeCache(Member member) {
        Session session = this.sessions.remove(member);
        if (this.isFiner()) {
            this.logFiner("Clearing cache on " + member + ": " + session);
        }
        this.permissionsCacheAccounts.remove(this.nullSafeGet(session != null ? session.getAccountInfo() : null));
        for (Folder folder : this.getController().getFolderRepository().getFolders(true)) {
            folder.clearNodeCache(member);
        }
    }

    private void prefetchAccountInfos() {
        LinkedList<Member> linkedList = new LinkedList<Member>();
        for (Member member : this.getController().getNodeManager().getNodesAsCollection()) {
            if (!this.shouldAutoRefresh(member)) continue;
            linkedList.add(member);
        }
        this.fetchAccountInfos(linkedList, true);
    }

    private void refresh(Member member) {
        if (this.shouldAutoRefresh(member)) {
            this.getAccountInfo(member);
        }
        this.fireNodeAccountStateChanged(member);
    }

    private boolean shouldAutoRefresh(Member member) {
        if (member.isServer()) {
            if (this.isFine()) {
                this.logFine("Not refreshing account info for server: " + member);
            }
            return false;
        }
        return member.isMySelf() || member.isFriend() || member.hasJoinedAnyFolder() || member.isOnLAN() && member.isCompletelyConnected();
    }

    protected void fireNodeAccountStateChanged(Member member) {
        this.listners.nodeAccountStateChanged(new SecurityManagerEvent(member));
    }

    @Override
    public void addListener(SecurityManagerListener securityManagerListener) {
        ListenerSupportFactory.addListener(this.listners, securityManagerListener);
    }

    @Override
    public void removeListener(SecurityManagerListener securityManagerListener) {
        ListenerSupportFactory.removeListener(this.listners, securityManagerListener);
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private MyServerClientListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            if (serverClientEvent.isLoginSuccess()) {
                SecurityManagerClient.this.permissionsCacheAccounts.clear();
            }
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            if (serverClientEvent.isLoginSuccess()) {
                SecurityManagerClient.this.permissionsCacheAccounts.clear();
            }
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
            serverClientEvent.getClient().addListener(this);
            SecurityManagerClient.this.permissionsCacheAccounts.clear();
            SecurityManagerClient.this.sessions.clear();
        }
    }

    final class PermissionsCacheSegment {
        Map<Permission, Boolean> permissions = new ConcurrentHashMap<Permission, Boolean>();

        PermissionsCacheSegment() {
        }

        void set(Permission permission, Boolean bl) {
            Reject.ifNull(permission, "Permission is null");
            this.permissions.put(permission, bl);
        }

        Boolean hasPermission(Permission permission) {
            Reject.ifNull(permission, "Permission is null");
            return this.permissions.get(permission);
        }
    }

    class Session {
        private AccountInfo info;

        public Session(AccountInfo accountInfo) {
            this.info = accountInfo;
        }

        public AccountInfo getAccountInfo() {
            return this.info;
        }
    }

    private final class Refresher
    implements Runnable {
        private final Member node;
        private final boolean syncFolderMemberships;

        private Refresher(Member member, boolean bl) {
            this.node = member;
            this.syncFolderMemberships = bl;
        }

        @Override
        public void run() {
            try {
                boolean bl = false;
                if (SecurityManagerClient.this.client.isPrimaryServer(this.node) && this.node.isConnected()) {
                    SecurityManagerClient.this.prefetchAccountInfos();
                    bl = true;
                }
                if (this.node.isMySelf() && SecurityManagerClient.this.client.isConnected()) {
                    try {
                        SecurityManagerClient.this.client.refreshAccountDetails(true);
                    }
                    catch (Exception exception) {
                        SecurityManagerClient.this.logWarning("Unable to refresh account details. " + exception);
                        SecurityManagerClient.this.logFiner(exception);
                    }
                }
                SecurityManagerClient.this.clearNodeCache(this.node);
                SecurityManagerClient.this.refresh(this.node);
                if (this.syncFolderMemberships) {
                    if (this.node.isMySelf() || bl) {
                        SecurityManagerClient.this.getController().getFolderRepository().triggerSynchronizeAllFolderMemberships();
                    } else if (this.node.isCompletelyConnected()) {
                        this.node.synchronizeFolderMemberships();
                    }
                }
            }
            finally {
                SecurityManagerClient.this.refreshing.remove(this.node.getId() + this.syncFolderMemberships);
            }
        }
    }
}

