/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.protocol.PermissionInfoProto;
import de.dal33t.powerfolder.protocol.PermissionTypeProto;
import de.dal33t.powerfolder.protocol.StringMessageProto;
import de.dal33t.powerfolder.security.Organization;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import java.util.logging.Logger;

public class OrganizationAdminPermission
implements Permission,
D2DObject {
    private static final Logger LOG = Logger.getLogger(OrganizationAdminPermission.class.getName());
    public static final String ID_SEPARATOR = "_OP_";
    public static OrganizationPermissionHelper ORGANIZATION_PERMISSION_HELPER;
    private static final long serialVersionUID = 100L;
    private String organizationOID;

    public OrganizationAdminPermission(Organization organization) {
        this.organizationOID = organization.getOID();
    }

    public OrganizationAdminPermission(String string) {
        Reject.ifNull(string, "organizationOID");
        this.organizationOID = string;
    }

    public static OrganizationAdminPermission of(String string) {
        return new OrganizationAdminPermission(string);
    }

    public OrganizationAdminPermission(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    @Override
    public boolean implies(Permission permission) {
        if (ORGANIZATION_PERMISSION_HELPER != null) {
            return ORGANIZATION_PERMISSION_HELPER.implies(this, permission);
        }
        return false;
    }

    @Override
    public String getId() {
        return this.organizationOID + ID_SEPARATOR + this.getClass().getSimpleName();
    }

    public String getOrganizationOID() {
        return this.organizationOID;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.organizationOID == null ? 0 : this.organizationOID.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Permission)) {
            return false;
        }
        Permission permission = (Permission)object;
        return Util.equals(this.getId(), permission.getId());
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        PermissionInfoProto.PermissionInfo permissionInfo;
        if (abstractMessage instanceof PermissionInfoProto.PermissionInfo && (permissionInfo = (PermissionInfoProto.PermissionInfo)abstractMessage).getObjectsList().size() == 1) {
            try {
                Any any = permissionInfo.getObjects(0);
                String string = any.getTypeUrl().split("/")[1];
                if (string.equals("StringMessage")) {
                    StringMessageProto.StringMessage stringMessage = any.unpack(StringMessageProto.StringMessage.class);
                    this.organizationOID = stringMessage.getValue();
                }
            }
            catch (InvalidProtocolBufferException | NullPointerException exception) {
                LOG.severe("Cannot unpack message: " + exception);
            }
        }
    }

    @Override
    public AbstractMessage toD2D() {
        PermissionInfoProto.PermissionInfo.Builder builder = PermissionInfoProto.PermissionInfo.newBuilder();
        builder.setClazzName("PermissionInfo");
        StringMessageProto.StringMessage.Builder builder2 = StringMessageProto.StringMessage.newBuilder();
        builder2.setClazzName("StringMessage");
        builder2.setValue(this.organizationOID);
        builder.addObjects(Any.pack(builder2.build()));
        builder.setPermissionType(PermissionTypeProto.PermissionType.ORGANIZATION_ADMIN);
        return builder.build();
    }

    public static interface OrganizationPermissionHelper {
        public boolean implies(OrganizationAdminPermission var1, Permission var2);
    }
}

