/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import de.dal33t.powerfolder.util.Format;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Embeddable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Embeddable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class OnlineStorageSubscription
implements Serializable {
    private static final long serialVersionUID = 8695479753037728184L;
    public static final int UNLIMITED_GB = 9999;
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_STORAGE_SIZE = "storageSize";
    public static final String PROPERTY_STORAGE_SIZE_GB = "storageSizeGB";
    public static final String PROPERTY_VALID_FROM = "validFrom";
    public static final String PROPERTY_VALID_TILL = "validTill";
    public static final String PROPERTY_WARNED_USAGE_DATE = "warnedUsageDate";
    public static final String PROPERTY_DISABLED_USAGE_DATE = "disabledUsageDate";
    public static final String PROPERTY_WARNED_EXPIRATION_DATE = "warnedExpirationDate";
    public static final String PROPERTY_DISABLED_EXPIRATION_DATE = "disabledExpirationDate";
    private long storageSize;
    private Date validFrom;
    private Date validTill;
    private Date warnedUsageDate;
    private Date disabledUsageDate;
    private Date warnedExpirationDate;
    private Date disabledExpirationDate;

    public int getDaysLeft() {
        if (this.getValidTill() == null) {
            return -1;
        }
        long l = this.getValidTill().getTime() - System.currentTimeMillis();
        if (l > 0L) {
            int n = (int)((double)l / 8.64E7);
            return n;
        }
        return 0;
    }

    public boolean isExpired() {
        if (this.validTill == null) {
            return false;
        }
        long l = this.validTill.getTime() - System.currentTimeMillis();
        return l <= 0L;
    }

    public boolean isValid() {
        if (this.isExpired()) {
            return false;
        }
        if (this.validFrom == null) {
            return true;
        }
        return System.currentTimeMillis() > this.validFrom.getTime();
    }

    public boolean isServicedInMonth(int n, int n2) {
        Calendar calendar;
        if (this.validFrom != null) {
            calendar = Calendar.getInstance();
            calendar.set(1, n2);
            calendar.set(2, n - 1);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(2, 1);
            calendar.add(13, -1);
            if (this.validFrom.after(calendar.getTime())) {
                return false;
            }
        }
        if (this.validTill != null) {
            calendar = Calendar.getInstance();
            calendar.set(1, n2);
            calendar.set(2, n - 1);
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            if (this.validTill.before(calendar.getTime())) {
                return false;
            }
        }
        return true;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date date) {
        this.validFrom = date;
    }

    public Date getValidTill() {
        return this.validTill;
    }

    public void setValidTill(Date date) {
        this.validTill = date;
    }

    public Date getWarnedUsageDate() {
        return this.warnedUsageDate;
    }

    public void setWarnedUsageDate(Date date) {
        Date date2 = this.getWarnedUsageDate();
        this.warnedUsageDate = date;
    }

    public boolean isWarnedUsage() {
        return this.warnedUsageDate != null;
    }

    public Date getDisabledUsageDate() {
        return this.disabledUsageDate;
    }

    public void setDisabledUsageDate(Date date) {
        Date date2 = this.getDisabledUsageDate();
        this.disabledUsageDate = date;
    }

    public boolean isDisabledUsage() {
        return this.disabledUsageDate != null;
    }

    public Date getWarnedExpirationDate() {
        return this.warnedExpirationDate;
    }

    public void setWarnedExpirationDate(Date date) {
        Date date2 = this.getWarnedExpirationDate();
        this.warnedExpirationDate = date;
    }

    public boolean isWarnedExpiration() {
        return this.warnedExpirationDate != null;
    }

    public Date getDisabledExpirationDate() {
        return this.disabledExpirationDate;
    }

    public void setDisabledExpirationDate(Date date) {
        Date date2 = this.getDisabledExpirationDate();
        this.disabledExpirationDate = date;
    }

    public boolean isDisabledExpiration() {
        return this.disabledExpirationDate != null;
    }

    public boolean isDisabled() {
        return this.isDisabledExpiration() || this.isDisabledUsage();
    }

    public boolean isUnlimited() {
        return this.getStorageSizeGB() == 9999;
    }

    public long getStorageSize() {
        return this.storageSize;
    }

    public void setStorageSize(long l) {
        Long l2 = this.getStorageSize();
        Integer n = this.getStorageSizeGB();
        this.storageSize = l;
    }

    public void setStorageSizeGB(int n) {
        this.setStorageSize(0x40000000L * (long)n);
    }

    public void setStorageSizeUnlimited() {
        this.setStorageSizeGB(9999);
    }

    public int getStorageSizeGB() {
        return (int)(this.getStorageSize() / 1024L / 1024L / 1024L);
    }

    public String getDescription() {
        if (this.isUnlimited()) {
            return "Unlimited";
        }
        return Format.formatBytesShort(this.getStorageSize());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("OS Subscription ");
        stringBuilder.append(this.getDescription());
        if (this.validTill != null) {
            stringBuilder.append(" valid till " + this.validTill);
        } else {
            stringBuilder.append(" valid forever");
        }
        return stringBuilder.toString();
    }
}

