/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.protocol.FolderInfoProto;
import de.dal33t.powerfolder.protocol.PermissionInfoProto;
import de.dal33t.powerfolder.protocol.PermissionTypeProto;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.FolderAdminPermission;
import de.dal33t.powerfolder.security.FolderDeletePermission;
import de.dal33t.powerfolder.security.FolderOwnerPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.security.FolderReadWritePermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.util.Reject;
import java.util.logging.Logger;

public abstract class FolderPermission
implements Permission,
D2DObject {
    private static final Logger LOG = Logger.getLogger(FolderPermission.class.getName());
    private static final long serialVersionUID = 100L;
    public static final String ID_SEPARATOR = "_FP_";
    public static final String PROPERTYNAME_FOLDER = "folder";
    protected FolderInfo folder;

    public FolderPermission() {
    }

    protected FolderPermission(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folderinfo is null");
        this.folder = folderInfo;
    }

    public abstract String getName();

    public abstract AccessMode getMode();

    public final FolderInfo getFolder() {
        return this.folder;
    }

    @Override
    public String getId() {
        return this.folder.id + ID_SEPARATOR + this.getClass().getSimpleName();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.folder == null ? 0 : this.folder.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FolderPermission)) {
            return false;
        }
        FolderPermission folderPermission = (FolderPermission)object;
        return !(this.folder == null ? folderPermission.folder != null : !this.folder.equals(folderPermission.folder));
    }

    public static FolderPermission get(FolderInfo folderInfo, AccessMode accessMode) {
        if (AccessMode.READ.equals((Object)accessMode)) {
            return FolderPermission.read(folderInfo);
        }
        if (AccessMode.READ_WRITE.equals((Object)accessMode)) {
            return FolderPermission.readWrite(folderInfo);
        }
        if (AccessMode.ADMIN.equals((Object)accessMode)) {
            return FolderPermission.admin(folderInfo);
        }
        if (AccessMode.OWNER.equals((Object)accessMode)) {
            return FolderPermission.owner(folderInfo);
        }
        return null;
    }

    public static FolderDeletePermission delete(FolderInfo folderInfo) {
        return new FolderDeletePermission(folderInfo);
    }

    public static FolderReadPermission read(FolderInfo folderInfo) {
        return new FolderReadPermission(folderInfo);
    }

    public static FolderReadWritePermission readWrite(FolderInfo folderInfo) {
        return new FolderReadWritePermission(folderInfo);
    }

    public static FolderAdminPermission admin(FolderInfo folderInfo) {
        return new FolderAdminPermission(folderInfo);
    }

    public static FolderOwnerPermission owner(FolderInfo folderInfo) {
        return new FolderOwnerPermission(folderInfo);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " on " + this.folder;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        PermissionInfoProto.PermissionInfo permissionInfo;
        if (abstractMessage instanceof PermissionInfoProto.PermissionInfo && (permissionInfo = (PermissionInfoProto.PermissionInfo)abstractMessage).getObjectsList().size() == 1) {
            try {
                Any any = permissionInfo.getObjects(0);
                String string = any.getTypeUrl().split("/")[1];
                if (string.equals("FolderInfo")) {
                    FolderInfoProto.FolderInfo folderInfo = any.unpack(FolderInfoProto.FolderInfo.class);
                    this.folder = new FolderInfo(folderInfo);
                }
            }
            catch (InvalidProtocolBufferException | NullPointerException exception) {
                LOG.severe("Cannot unpack message: " + exception);
            }
        }
    }

    @Override
    public AbstractMessage toD2D() {
        PermissionInfoProto.PermissionInfo.Builder builder = PermissionInfoProto.PermissionInfo.newBuilder();
        builder.setClazzName("PermissionInfo");
        builder.addObjects(Any.pack(this.folder.toD2D()));
        if (this instanceof FolderAdminPermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_ADMIN);
        } else if (this instanceof FolderOwnerPermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_OWNER);
        } else if (this instanceof FolderReadPermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_READ);
        } else if (this instanceof FolderReadWritePermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_READ_WRITE);
        }
        return builder.build();
    }
}

