/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.UDTMessage;
import de.dal33t.powerfolder.net.AbstractUDTSocketConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.util.Partitions;
import de.dal33t.powerfolder.util.Range;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import de.dal33t.powerfolder.util.net.UDTSocket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;

public class UDTSocketConnectionManager
extends PFComponent {
    private Partitions<PortSlot> ports;
    private ConcurrentMap<MemberInfo, ReplyMonitor> replies = new ConcurrentHashMap<MemberInfo, ReplyMonitor>();

    public UDTSocketConnectionManager(Controller controller, Range range) {
        super(controller);
        this.ports = new Partitions<Object>(range, null);
    }

    public ConnectionHandler initRendezvousUDTConnectionHandler(MemberInfo memberInfo) throws ConnectionException {
        if (!UDTSocket.isSupported()) {
            throw new ConnectionException("Missing UDT support!");
        }
        if (this.getController().getMySelf().getInfo().equals(memberInfo)) {
            throw new ConnectionException("Illegal relayed loopback connection detection to myself");
        }
        Member member = this.getController().getIOProvider().getRelayedConnectionManager().getRelay();
        if (member == null) {
            throw new ConnectionException("Unable to open relayed connection to " + memberInfo + ". No relay found!");
        }
        if (member.getInfo().equals(memberInfo)) {
            throw new ConnectionException("Unable to open relayed connection to relay " + memberInfo);
        }
        if (!member.isCompletelyConnected()) {
            throw new ConnectionException("Unable to open relayed connection to " + memberInfo + ". Relay " + member.getNick() + " not connected.");
        }
        PortSlot portSlot = this.selectPortFor(memberInfo);
        if (portSlot == null) {
            throw new ConnectionException("UDT port selection failed!");
        }
        UDTMessage uDTMessage = new UDTMessage(UDTMessage.Type.SYN, this.getController().getMySelf().getInfo(), memberInfo, portSlot.port);
        try {
            try {
                ReplyMonitor replyMonitor = new ReplyMonitor();
                if (this.replies.putIfAbsent(memberInfo, replyMonitor) != null) {
                    throw new ConnectionException("Already trying to establish connection to " + memberInfo);
                }
                member.sendMessage(uDTMessage);
                UDTMessage uDTMessage2 = this.waitForReply(replyMonitor, memberInfo);
                switch (uDTMessage2.getType()) {
                    case ACK: {
                        this.logFine("UDT SYN: Trying to connect to " + memberInfo);
                        AbstractUDTSocketConnectionHandler abstractUDTSocketConnectionHandler = this.createAndInitRendezvousUDTSocketConnectionHandler(this.getController(), portSlot.socket, uDTMessage2.getSource(), uDTMessage2.getPort());
                        this.logFine("UDT SYN: Successfully connected to " + memberInfo);
                        return abstractUDTSocketConnectionHandler;
                    }
                    case NACK: {
                        throw new ConnectionException("Connection not possible: " + uDTMessage2);
                    }
                }
                this.logFine("UDT SYN: Received invalid reply:" + uDTMessage2);
                throw new ConnectionException("Invalid reply: " + uDTMessage2);
            }
            catch (TimeoutException timeoutException) {
                this.logFiner(timeoutException);
                throw new ConnectionException("Timeout while connecting to " + memberInfo, timeoutException);
            }
            catch (InterruptedException interruptedException) {
                this.logFiner(interruptedException);
                throw new ConnectionException("Interrupted while connecting to " + memberInfo, interruptedException);
            }
        }
        catch (ConnectionException connectionException) {
            this.replies.remove(memberInfo);
            this.releaseSlot(portSlot.port);
            if (portSlot.socket != null && !portSlot.socket.isClosed()) {
                try {
                    portSlot.socket.close();
                }
                catch (IOException iOException) {
                    this.logSevere(iOException);
                }
            }
            throw connectionException;
        }
    }

    public void handleUDTMessage(Member member, UDTMessage uDTMessage) {
        if (uDTMessage.getDestination().matches(this.getController().getMySelf())) {
            this.handleMessageForMyself(member, uDTMessage);
        } else {
            this.relayMessage(member, uDTMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortSlot selectPortFor(MemberInfo memberInfo) {
        Object object;
        Range range = null;
        PortSlot portSlot = new PortSlot(memberInfo);
        portSlot.socket = new UDTSocket();
        try {
            NetworkUtil.setupSocket(portSlot.socket, memberInfo.getConnectAddress(), this.getController());
        }
        catch (IOException iOException) {
            this.logSevere(iOException);
        }
        while (true) {
            object = this;
            synchronized (object) {
                range = this.ports.search(this.ports.getPartionedRange(), null);
                if (range != null) {
                    this.ports.insert(Range.getRangeByNumbers(range.getStart(), range.getStart()), PortSlot.LOCKED);
                }
            }
            if (range == null) {
                this.logSevere("No further usable ports for UDT connections!");
                try {
                    portSlot.socket.close();
                }
                catch (IOException iOException) {
                    this.logSevere(iOException);
                }
                return null;
            }
            portSlot.port = (int)range.getStart();
            try {
                object = ConfigurationEntry.NET_BIND_ADDRESS.getValueArray(this.getController())[0];
                InetSocketAddress inetSocketAddress = !StringUtils.isEmpty((String)object) ? new InetSocketAddress((String)object, portSlot.port) : new InetSocketAddress(portSlot.port);
                portSlot.socket.bind(inetSocketAddress);
            }
            catch (IOException iOException) {
                this.logFiner(iOException);
                continue;
            }
            break;
        }
        object = this;
        synchronized (object) {
            this.ports.insert(Range.getRangeByNumbers(range.getStart(), range.getStart()), portSlot);
        }
        return portSlot;
    }

    public synchronized void releaseSlot(int n) {
        this.ports.insert(Range.getRangeByLength(n, 1L), null);
    }

    private AbstractUDTSocketConnectionHandler createAndInitRendezvousUDTSocketConnectionHandler(Controller controller, UDTSocket uDTSocket, MemberInfo memberInfo, int n) throws ConnectionException {
        MemberInfo memberInfo2 = memberInfo.getNode(this.getController(), true).getInfo();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(memberInfo2.getConnectAddress().getAddress(), n);
        AbstractUDTSocketConnectionHandler abstractUDTSocketConnectionHandler = null;
        try {
            uDTSocket.setSoRendezvous(true);
            if (this.isFiner()) {
                this.logFiner("UDT connect to " + inetSocketAddress);
            }
            uDTSocket.connect(inetSocketAddress);
            if (this.isFiner()) {
                this.logFiner("UDT socket is connected to " + inetSocketAddress);
            }
            abstractUDTSocketConnectionHandler = this.getController().getIOProvider().getConnectionHandlerFactory().createAndInitUDTSocketConnectionHandler(uDTSocket);
            if (this.isFiner()) {
                this.logFiner("Is connected? " + abstractUDTSocketConnectionHandler.isConnected() + " : " + uDTSocket.getRemoteAddress());
            }
        }
        catch (ConnectionException connectionException) {
            try {
                uDTSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw connectionException;
        }
        catch (RuntimeException runtimeException) {
            try {
                uDTSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (abstractUDTSocketConnectionHandler != null) {
                abstractUDTSocketConnectionHandler.shutdown();
            }
            throw runtimeException;
        }
        catch (IOException iOException) {
            try {
                uDTSocket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw new ConnectionException("IOException while opening UDT connection: " + iOException, iOException);
        }
        return abstractUDTSocketConnectionHandler;
    }

    private void relayMessage(Member member, UDTMessage uDTMessage) {
        Member member2;
        if (this.isFiner()) {
            this.logFiner("Relaying UDT message: " + uDTMessage);
        }
        if ((member2 = uDTMessage.getDestination().getNode(this.getController(), false)) == null || !member2.isCompletelyConnected()) {
            UDTMessage uDTMessage2 = new UDTMessage(UDTMessage.Type.NACK, uDTMessage.getDestination(), uDTMessage.getSource(), -1);
            member.sendMessagesAsynchron(uDTMessage2);
            return;
        }
        member2.sendMessagesAsynchron(uDTMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessageForMyself(Member member, UDTMessage uDTMessage) {
        if (this.isFiner()) {
            this.logFiner("Received UDT message for me: " + uDTMessage);
            this.logFiner("Replies: " + this.replies.size());
        }
        if (!UDTSocket.isSupported()) {
            this.logFiner("UDT sockets not supported on this platform.");
            return;
        }
        switch (uDTMessage.getType()) {
            case SYN: {
                if (this.getController().getIOProvider().getConnectionHandlerFactory().useUDTConnections()) {
                    this.getController().getIOProvider().startIO(new ConnectionInitializer(member, uDTMessage));
                    break;
                }
                UDTMessage uDTMessage2 = new UDTMessage(UDTMessage.Type.NACK, this.getController().getMySelf().getInfo(), member.getInfo(), -1);
                member.sendMessagesAsynchron(uDTMessage2);
                break;
            }
            case ACK: 
            case NACK: {
                ReplyMonitor replyMonitor = (ReplyMonitor)this.replies.get(uDTMessage.getSource());
                if (replyMonitor == null) {
                    this.logWarning("Received a reply for " + uDTMessage.getSource() + ", although no connection was requested!");
                    break;
                }
                ReplyMonitor replyMonitor2 = replyMonitor;
                synchronized (replyMonitor2) {
                    if (replyMonitor.msg != null) {
                        this.logSevere("Relay message error: Received more than one SYN reply!");
                    }
                    replyMonitor.msg = uDTMessage;
                    replyMonitor.notify();
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UDTMessage waitForReply(ReplyMonitor replyMonitor, MemberInfo memberInfo) throws TimeoutException, InterruptedException {
        ReplyMonitor replyMonitor2 = replyMonitor;
        synchronized (replyMonitor2) {
            try {
                if (replyMonitor.msg != null) {
                    UDTMessage uDTMessage = replyMonitor.msg;
                    return uDTMessage;
                }
                replyMonitor.wait(30000L);
                if (replyMonitor.msg != null) {
                    UDTMessage uDTMessage = replyMonitor.msg;
                    return uDTMessage;
                }
                throw new TimeoutException();
            }
            finally {
                if (this.isFiner()) {
                    this.logFiner("waitForReply remaining entries: " + this.replies.size());
                }
                this.replies.remove(memberInfo);
            }
        }
    }

    private static class PortSlot {
        public static final PortSlot LOCKED = new PortSlot();
        private MemberInfo member;
        private UDTSocket socket;
        private int port;

        public PortSlot(MemberInfo memberInfo) {
            this.member = memberInfo;
        }

        private PortSlot() {
        }

        public MemberInfo getMember() {
            return this.member;
        }

        public UDTSocket getSocket() {
            return this.socket;
        }

        public int getPort() {
            return this.port;
        }
    }

    private static class ReplyMonitor {
        public UDTMessage msg;

        private ReplyMonitor() {
        }
    }

    private final class ConnectionInitializer
    implements Runnable {
        private final Member sender;
        private final UDTMessage msg;

        private ConnectionInitializer(Member member, UDTMessage uDTMessage) {
            Reject.ifNull(member, "Sender/Relay");
            this.sender = member;
            this.msg = uDTMessage;
        }

        @Override
        public void run() {
            PortSlot portSlot = UDTSocketConnectionManager.this.selectPortFor(this.sender.getInfo());
            if (portSlot == null) {
                UDTSocketConnectionManager.this.logSevere("UDT port selection failed.");
                try {
                    this.sender.sendMessage(new UDTMessage(UDTMessage.Type.NACK, UDTSocketConnectionManager.this.getController().getMySelf().getInfo(), this.msg.getSource(), -1));
                }
                catch (ConnectionException connectionException) {
                    UDTSocketConnectionManager.this.logSevere(connectionException);
                }
                return;
            }
            try {
                this.sender.sendMessage(new UDTMessage(UDTMessage.Type.ACK, UDTSocketConnectionManager.this.getController().getMySelf().getInfo(), this.msg.getSource(), portSlot.port));
                ConnectionHandler connectionHandler = null;
                try {
                    UDTSocketConnectionManager.this.logFine("UDT ACK: Trying to connect...");
                    connectionHandler = UDTSocketConnectionManager.this.createAndInitRendezvousUDTSocketConnectionHandler(UDTSocketConnectionManager.this.getController(), portSlot.socket, this.msg.getSource(), this.msg.getPort());
                    UDTSocketConnectionManager.this.getController().getNodeManager().acceptConnection(connectionHandler);
                    UDTSocketConnectionManager.this.logFine("UDT ACK: Successfully connected!");
                }
                catch (ConnectionException connectionException) {
                    if (connectionHandler != null) {
                        connectionHandler.shutdown();
                    }
                    throw connectionException;
                }
            }
            catch (ConnectionException connectionException) {
                UDTSocketConnectionManager.this.releaseSlot(portSlot.port);
                if (portSlot.socket != null && !portSlot.socket.isClosed()) {
                    try {
                        portSlot.socket.close();
                    }
                    catch (IOException iOException) {
                        UDTSocketConnectionManager.this.logSevere(iOException);
                    }
                }
                UDTSocketConnectionManager.this.logFiner("Unable to connect (UDT) to " + this.msg.getSource() + ": " + connectionException, connectionException);
            }
        }
    }
}

