/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.ConnectResult;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.NetworkingMode;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.InvalidIdentityException;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.compare.MemberComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;

public class ReconnectManager
extends PFComponent {
    private List<Member> reconnectionQueue;
    private List<Reconnector> reconnectors;
    private AtomicInteger reconnectorCounter = new AtomicInteger(0);
    private boolean started;

    public ReconnectManager(Controller controller) {
        super(controller);
        this.reconnectionQueue = new LinkedList<Member>();
        this.reconnectors = Collections.synchronizedList(new ArrayList());
    }

    public void start() {
        this.started = true;
        this.logFine("Starting Reconnection Manager. Going to connect to other nodes now...");
        this.buildReconnectionQueue();
        this.getController().getController().scheduleAndRepeat(new ReconnectorPoolResizer(), 0L, 120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.started = false;
        List<Object> list = this.reconnectors;
        synchronized (list) {
            this.logFine("Shutting down " + this.reconnectors.size() + " reconnectors");
            Iterator<Reconnector> iterator = this.reconnectors.iterator();
            while (iterator.hasNext()) {
                Reconnector reconnector = iterator.next();
                reconnector.shutdown();
                iterator.remove();
            }
        }
        list = this.reconnectionQueue;
        synchronized (list) {
            this.reconnectionQueue.clear();
            this.reconnectionQueue.notifyAll();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public int countReconnectionQueue() {
        return this.reconnectionQueue.size();
    }

    public Collection<Member> getReconnectionQueue() {
        return Collections.unmodifiableCollection(this.reconnectionQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markNodeForImmediateReconnection(Member member) {
        if (!this.started) {
            this.logFine("ReconnectManager not started. Unable to spawn new reconnector to " + member + ". Queue: " + this.reconnectionQueue);
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Marking node for immediate reconnect: " + member);
        }
        if (member.isConnected() || member.isConnecting() || member.isMySelf()) {
            return;
        }
        if (this.getMySelf().isServer() && !member.isServer()) {
            return;
        }
        List<Object> list = this.reconnectionQueue;
        synchronized (list) {
            this.reconnectionQueue.remove(member);
            this.reconnectionQueue.add(0, member);
            this.reconnectionQueue.notify();
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            this.logFiner("InterruptedException", interruptedException);
            return;
        }
        if (this.reconnectionQueue.contains(member)) {
            if (this.isFine()) {
                this.logFine("Spawning new Reconnector (" + (this.reconnectors.size() + 1) + " total) to get faster reconnect to " + member);
            }
            if (!this.started) {
                this.logSevere("ReconnectManager not started. Unable to spawn new reconnector to " + member + ". Queue: " + this.reconnectionQueue);
                return;
            }
            list = this.reconnectors;
            synchronized (list) {
                Reconnector reconnector = new Reconnector();
                this.reconnectors.add(reconnector);
                reconnector.start();
            }
        } else if (this.isFiner()) {
            this.logFiner("Not required to spawn new reconnector to " + member + ". Queue: " + this.reconnectionQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean considerReconnectionTo(Member member) {
        if (this.shouldBeAddedToReconQueue(member)) {
            List<Member> list = this.reconnectionQueue;
            synchronized (list) {
                if (!this.reconnectionQueue.contains(member)) {
                    this.reconnectionQueue.add(member);
                    Collections.sort(this.reconnectionQueue, MemberComparator.BY_RECONNECTION_PRIORITY);
                    this.reconnectionQueue.notify();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildReconnectionQueue() {
        int n = this.reconnectionQueue.size();
        List<Member> list = this.reconnectionQueue;
        synchronized (list) {
            this.reconnectionQueue.clear();
            for (Member member : this.getController().getNodeManager().getNodesAsCollection()) {
                if (!this.shouldBeAddedToReconQueue(member)) continue;
                this.reconnectionQueue.add(member);
            }
            Collections.sort(this.reconnectionQueue, MemberComparator.BY_RECONNECTION_PRIORITY);
            if (this.isFiner()) {
                this.logFiner("Freshly filled reconnection queue with " + this.reconnectionQueue.size() + " nodes, " + n + " were in queue before");
            }
            if (this.reconnectionQueue.size() > 200 && !this.getMySelf().isServer()) {
                this.logWarning("Reconnection queue contains more than 200 nodes");
            }
            if (!this.reconnectionQueue.isEmpty()) {
                this.reconnectionQueue.notify();
            }
        }
    }

    private boolean shouldBeAddedToReconQueue(Member member) {
        Reject.ifNull(member, "Node is null");
        if (!this.started) {
            return false;
        }
        if (this.getMySelf().isServer()) {
            return false;
        }
        if (member.getInfo().isInvalid(this.getController())) {
            return false;
        }
        if (member.isConnected() || member.isMySelf()) {
            return false;
        }
        if (member.isConnecting()) {
            return false;
        }
        if (member.receivedWrongIdentity()) {
            return false;
        }
        if (!member.isInteresting()) {
            return false;
        }
        if (member.isServer() || ServerClient.isTempServerNode(member.getInfo())) {
            return false;
        }
        if (this.getController().getIOProvider().getRelayedConnectionManager().isRelay(member)) {
            return false;
        }
        if (this.getController().getNetworkingMode().equals((Object)NetworkingMode.SERVERONLYMODE)) {
            return false;
        }
        if (!member.isOnSameNetwork()) {
            return false;
        }
        if (member.isFriend()) {
            return true;
        }
        Date date = new Date(System.currentTimeMillis() - 36000000L);
        Date date2 = member.getLastNetworkConnectTime();
        boolean bl = true;
        boolean bl2 = bl = date2 != null ? date2.before(date) : true;
        if (bl) {
            return false;
        }
        if (member.isDontConnect()) {
            return false;
        }
        int n = this.getController().getNodeManager().countConnectedSupernodes();
        return member.isSupernode() && n < 3;
    }

    private class ReconnectorPoolResizer
    extends TimerTask {
        private ReconnectorPoolResizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!ReconnectManager.this.started) {
                return;
            }
            List list = ReconnectManager.this.reconnectors;
            synchronized (list) {
                Iterator iterator = ReconnectManager.this.reconnectors.iterator();
                while (iterator.hasNext()) {
                    Reconnector reconnector = (Reconnector)iterator.next();
                    if (reconnector.isAlive() && !reconnector.isInterrupted()) continue;
                    iterator.remove();
                }
                int n = ReconnectManager.this.reconnectors.size();
                int n2 = Math.max(2, Math.min(5, ReconnectManager.this.reconnectionQueue.size() / 3));
                int n3 = n2 - n;
                if (ReconnectManager.this.isFiner()) {
                    ReconnectManager.this.logFiner("Got " + ReconnectManager.this.reconnectionQueue.size() + " nodes queued for reconnection");
                }
                if (n3 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        final Reconnector reconnector = new Reconnector();
                        ReconnectManager.this.reconnectors.add(reconnector);
                        ReconnectManager.this.getController().schedule(new Runnable(){

                            @Override
                            public void run() {
                                reconnector.start();
                            }
                        }, (long)i * 500L);
                    }
                    ReconnectManager.this.logFine("Spawned " + n3 + " reconnectors. " + ReconnectManager.this.reconnectors.size() + "/" + n2 + ", nodes in reconnection queue: " + ReconnectManager.this.reconnectionQueue.size());
                } else if (n3 < 0) {
                    ReconnectManager.this.logFine("Killing " + -n3 + " Reconnectors. Currently have: " + n + " Reconnectors");
                    for (int i = 0; i < -n3; ++i) {
                        if (ReconnectManager.this.reconnectors.size() <= 1) {
                            ReconnectManager.this.logWarning("Not killing last reconnector");
                            break;
                        }
                        Reconnector reconnector = (Reconnector)ReconnectManager.this.reconnectors.remove(0);
                        if (reconnector == null) continue;
                        ReconnectManager.this.logFiner("Killing reconnector " + reconnector);
                        reconnector.softShutdown();
                    }
                }
            }
        }
    }

    private class Reconnector
    extends Thread {
        private boolean reconStarted;
        private Member currentNode;

        private Reconnector() {
            super("Reconnector " + ReconnectManager.this.reconnectorCounter.addAndGet(1));
        }

        @Override
        public void start() {
            if (!ReconnectManager.this.started) {
                throw new IllegalStateException("Unable to start reconnector. ReconnectManager not started");
            }
            super.start();
            this.reconStarted = true;
        }

        public void softShutdown() {
            this.reconStarted = false;
            ReconnectManager.this.reconnectorCounter.decrementAndGet();
        }

        public void shutdown() {
            this.softShutdown();
            this.interrupt();
            if (this.currentNode != null) {
                this.currentNode.shutdown();
            }
        }

        private int getIdleWaitSeconds() {
            return ConfigurationEntry.CONNECT_WAIT.getValueInt(ReconnectManager.this.getController());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ReconnectManager.this.isFiner()) {
                ReconnectManager.this.logFiner("Starting reconnector: " + this.getName());
            }
            while (this.reconStarted) {
                if (!ReconnectManager.this.started) {
                    ReconnectManager.this.logFine("Stopping " + this + ". ReconnectManager is down");
                    break;
                }
                if (!ReconnectManager.this.getController().getNodeManager().isStarted()) {
                    ReconnectManager.this.logFine("Stopping " + this + ". NodeManager is down");
                    break;
                }
                List list = ReconnectManager.this.reconnectionQueue;
                synchronized (list) {
                    if (ReconnectManager.this.reconnectionQueue.isEmpty()) {
                        int n = this.getIdleWaitSeconds();
                        ReconnectManager.this.logFine("Reconnection queue empty. " + this + " going on idle for " + n + " seconds");
                        try {
                            ReconnectManager.this.reconnectionQueue.wait(1000L * (long)n);
                        }
                        catch (InterruptedException interruptedException) {
                            ReconnectManager.this.logFiner(interruptedException);
                            break;
                        }
                        if (ReconnectManager.this.reconnectionQueue.isEmpty()) {
                            ReconnectManager.this.buildReconnectionQueue();
                        }
                    }
                }
                list = ReconnectManager.this.reconnectionQueue;
                synchronized (list) {
                    if (!ReconnectManager.this.reconnectionQueue.isEmpty()) {
                        this.currentNode = (Member)ReconnectManager.this.reconnectionQueue.remove(0);
                        if (this.currentNode.isConnected() || this.currentNode.isConnecting() || this.currentNode.isMySelf()) {
                            if (ReconnectManager.this.isFiner()) {
                                ReconnectManager.this.logFiner("Not reconnecting to " + this.currentNode.getNick() + ", already reconnecting/connected");
                            }
                            this.currentNode = null;
                        }
                    }
                    if (this.currentNode == null) {
                        continue;
                    }
                    if (this.currentNode.markConnecting() >= 2) {
                        this.currentNode.unmarkConnecting();
                        if (ReconnectManager.this.isFine()) {
                            ReconnectManager.this.logFine("Skipping: " + this.currentNode);
                        }
                        continue;
                    }
                    if (ReconnectManager.this.isFiner()) {
                        ReconnectManager.this.logFiner("Picked node for reconnect: " + this.currentNode);
                    }
                }
                long l = System.currentTimeMillis();
                try {
                    Object object;
                    if (!ServerClient.isTempServerNode(this.currentNode.getInfo())) {
                        try {
                            object = this.currentNode.reconnect(false);
                            if (!ReconnectManager.this.isFiner()) continue;
                            ReconnectManager.this.logFiner("Reconnect to " + this.currentNode + ": " + (ConnectResult)object);
                        }
                        catch (InvalidIdentityException invalidIdentityException) {
                            Identity identity = invalidIdentityException.getFrom().getIdentity();
                            MemberInfo memberInfo = identity != null && identity.getMemberInfo() != null ? identity.getMemberInfo() : null;
                            if (memberInfo == null || !memberInfo.isOnSameNetwork(ReconnectManager.this.getController())) continue;
                            Member member = memberInfo.getNode(ReconnectManager.this.getController(), true);
                            boolean bl = ReconnectManager.this.considerReconnectionTo(member);
                            ReconnectManager.this.logFine("Invalid identity from " + this.currentNode + ". Found: " + member + ". Going to reconned it ? " + bl);
                        }
                        continue;
                    }
                    if (ReconnectManager.this.isFine()) {
                        ReconnectManager.this.logFine("Tring to connect to temporary server node at " + this.currentNode.getHostName() + ":" + this.currentNode.getPort() + ". ID: " + this.currentNode.getId());
                    }
                    try {
                        object = ReconnectManager.this.getController().getIOProvider().getConnectionHandlerFactory().tryToConnect(this.currentNode.getInfo());
                        ReconnectManager.this.getController().getNodeManager().acceptConnection((ConnectionHandler)object);
                    }
                    catch (ConnectionException connectionException) {
                        ReconnectManager.this.logFiner("ConnectionException", connectionException);
                    }
                }
                finally {
                    this.currentNode.unmarkConnecting();
                }
            }
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

