/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.NetworkingMode;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BroadcastMananger
extends PFComponent
implements Runnable {
    private static final Logger log = Logger.getLogger(BroadcastMananger.class.getName());
    public static final int DEFAULT_BROADCAST_PORT = 1337;
    private static final int IN_BUFFER_SIZE = 128;
    private InetAddress subnetIP;
    private InetAddress group;
    private MulticastSocket socket;
    private DatagramSocket[] senderSockets;
    private String broadCastString;
    private Thread myThread;
    private long waitTime;
    private ArrayList<InetAddress> localAddresses;
    private ArrayList<InetAddress> oldLocalAddresses;
    private ArrayList<NetworkInterface> localNICList;
    private Collection<InetAddress> receivedBroadcastsFrom;

    public BroadcastMananger(Controller controller) throws ConnectionException {
        this(controller, false);
    }

    public BroadcastMananger(Controller controller, boolean bl) throws ConnectionException {
        super(controller);
        try {
            this.subnetIP = InetAddress.getLocalHost();
            this.localNICList = new ArrayList();
            this.localAddresses = new ArrayList();
            this.receivedBroadcastsFrom = new ArrayList<InetAddress>();
            this.waitTime = 15000L;
            this.group = InetAddress.getByName("224.0.0.1");
            if (controller.hasConnectionListener()) {
                String string = controller.getMySelf().getId();
                if (string.indexOf(91) >= 0 || string.indexOf(93) >= 0) {
                    throw new IllegalArgumentException("Node id contains illegal characters: " + string);
                }
                this.broadCastString = String.format("PowerFolder %s: [%d]-[%s]", "node", controller.getConnectionListener().getAddress().getPort(), string);
                if (bl) {
                    this.logFiner("D2D is enabled");
                }
            }
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to open broadcast socket", iOException);
        }
    }

    public void start() throws ConnectionException {
        String string = ConfigurationEntry.NET_BIND_ADDRESS.getValueArray(this.getController())[0];
        try {
            this.socket = new MulticastSocket(1337);
            InetAddress inetAddress = null;
            if (!StringUtils.isEmpty(string)) {
                inetAddress = InetAddress.getByName(string);
            } else if (OSUtil.isWindowsSystem()) {
                inetAddress = InetAddress.getLocalHost();
            }
            if (inetAddress == null && OSUtil.isMacOS()) {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                while (enumeration.hasMoreElements()) {
                    NetworkInterface networkInterface = enumeration.nextElement();
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress2 = enumeration2.nextElement();
                        if (!(inetAddress2 instanceof Inet4Address) || inetAddress2.isLoopbackAddress()) continue;
                        this.logFine("Selected interface: " + networkInterface + " (" + inetAddress2 + ")");
                        inetAddress = inetAddress2;
                    }
                }
            }
            if (inetAddress != null) {
                this.logFiner("Binding multicast on address: " + inetAddress);
                this.socket.setInterface(inetAddress);
            }
            this.socket.setSoTimeout((int)this.waitTime);
            this.socket.joinGroup(this.group);
            this.socket.setTimeToLive(65);
            this.socket.setBroadcast(true);
        }
        catch (IOException iOException) {
            this.logWarning("Unable to open broadcast socket " + string + ". " + iOException);
            throw new ConnectionException("Unable to open broadcast socket " + string + ". " + iOException.getMessage(), iOException);
        }
        this.myThread = new Thread((Runnable)this, "Subnet broadcast manager, port " + this.socket.getLocalPort());
        this.myThread.setPriority(1);
        this.myThread.start();
        this.logFine("Started");
        if (this.getController().getConnectionListener() != null) {
            this.getController().scheduleAndRepeat(new BroadcastSender(), 1000L * (long)ConfigurationEntry.NET_BROADCAST_INTERVAL_SECONDS.getValueInt(this.getController()).intValue());
        }
    }

    public void sendBroadcast() {
        new BroadcastSender().run();
    }

    public void shutdown() {
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        if (this.socket != null) {
            this.socket.close();
        }
        this.logFine("Stopped");
    }

    @Override
    public void run() {
        if (this.subnetIP == null) {
            return;
        }
        byte[] byArray = new byte[128];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.socket.receive(datagramPacket);
                if (!this.isPowerFolderBroadcast(datagramPacket) || !this.getController().getNodeManager().isStarted()) continue;
                this.processBroadcast(datagramPacket);
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (IOException iOException) {
                this.logFiner("Closing broadcastmanager", iOException);
                break;
            }
        }
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.senderSockets != null) {
            for (int i = 0; i < this.senderSockets.length; ++i) {
                if (this.senderSockets[i] == null) continue;
                this.senderSockets[i].close();
            }
        }
    }

    public boolean receivedBroadcast(InetAddress inetAddress) {
        Reject.ifNull(inetAddress, "Address is null");
        return this.receivedBroadcastsFrom.contains(inetAddress);
    }

    private void sendBroadcast(DatagramPacket datagramPacket) {
        if (this.isFiner()) {
            this.logFiner("Sending broadcast: " + this.broadCastString);
        }
        for (int i = 0; i < this.senderSockets.length; ++i) {
            if (this.senderSockets[i] == null) continue;
            try {
                this.senderSockets[i].send(datagramPacket);
                continue;
            }
            catch (IOException iOException) {
                log.log(Level.FINER, "Removing socket from future sendings. " + this.senderSockets[i], iOException);
                this.senderSockets[i].close();
                this.senderSockets[i] = null;
            }
        }
    }

    private boolean isPowerFolderBroadcast(DatagramPacket datagramPacket) {
        if (datagramPacket == null) {
            throw new NullPointerException("Packet is null");
        }
        if (datagramPacket.getData() == null) {
            throw new NullPointerException("Packet data is null");
        }
        String string = new String(datagramPacket.getData());
        return string.startsWith("PowerFolder node");
    }

    private boolean isPowerFolderD2DBroadcast(DatagramPacket datagramPacket) {
        if (datagramPacket == null) {
            throw new NullPointerException("Packet is null");
        }
        if (datagramPacket.getData() == null) {
            throw new NullPointerException("Packet data is null");
        }
        String string = new String(datagramPacket.getData());
        return string.startsWith("PowerFolder D2D-node");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processBroadcast(DatagramPacket datagramPacket) {
        int n;
        Object object;
        if (datagramPacket == null) {
            throw new NullPointerException("Packet is null");
        }
        if (datagramPacket.getData() == null) {
            throw new NullPointerException("Packet data is null");
        }
        byte[] byArray = new byte[datagramPacket.getLength()];
        System.arraycopy(datagramPacket.getData(), 0, byArray, 0, byArray.length);
        String string = new String(byArray);
        if (this.isFiner()) {
            this.logFiner("Received broadcast: " + string + ", " + datagramPacket.getAddress());
        }
        int n2 = string.indexOf(91);
        int n3 = string.indexOf(93);
        if (n2 > 0 && n3 > 0) {
            object = string.substring(n2 + 1, n3);
            try {
                n = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                this.logFiner("Unable to parse port from broadcast message");
                return false;
            }
        } else {
            return false;
        }
        n2 = string.indexOf(91, n3 + 1);
        n3 = string.indexOf(93, n3 + 1);
        if (n2 <= 0 || n3 <= 0) {
            return false;
        }
        String string2 = string.substring(n2 + 1, n3);
        object = new InetSocketAddress(datagramPacket.getAddress(), n);
        this.receivedBroadcastsFrom.add(datagramPacket.getAddress());
        Member member = this.getController().getNodeManager().getNode(string2);
        try {
            if (!this.getController().isStarted()) {
                boolean bl = false;
                return bl;
            }
            if (!this.getMySelf().isServer() && !this.getController().getOSClient().isLoggedIn() && Feature.P2P_REQUIRES_LOGIN_AT_SERVER.isEnabled()) {
                boolean bl = false;
                return bl;
            }
            if (member != null) {
                if (member.isMySelf()) {
                    boolean bl = false;
                    return bl;
                }
                if (member.isConnected() || member.isConnecting()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.getController().getNetworkingMode().equals((Object)NetworkingMode.SERVERONLYMODE) && !member.isServer()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.getMySelf().isServer() && !member.isServer()) {
                    boolean bl = false;
                    return bl;
                }
            }
            this.logFine("Connecting to node on LAN: " + (InetSocketAddress)object + (String)(member != null ? ", " + member : ""));
            member = this.getController().connect((InetSocketAddress)object, this.isPowerFolderD2DBroadcast(datagramPacket));
            boolean bl = true;
            return bl;
        }
        catch (ConnectionException connectionException) {
            this.logFine("Unable to connect to node on LAN: " + (InetSocketAddress)object + (String)(member != null ? ", " + member : "") + ". " + connectionException);
            this.logFiner(connectionException);
            boolean bl = false;
            return bl;
        }
        finally {
            if (member != null) {
                member.setOnLAN(true);
            }
        }
    }

    private boolean compareLocalAddresses(ArrayList<InetAddress> arrayList, ArrayList<InetAddress> arrayList2) {
        if (arrayList2 == null) {
            return true;
        }
        int n = arrayList.size();
        if (n != arrayList2.size()) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            InetAddress inetAddress = arrayList.get(i);
            InetAddress inetAddress2 = arrayList2.get(i);
            if (!Util.compareIpAddresses(inetAddress.getAddress(), inetAddress2.getAddress())) continue;
            return true;
        }
        return false;
    }

    private void updateSenderSockets() {
        this.updateLocalAddresses();
        if (this.compareLocalAddresses(this.localAddresses, this.oldLocalAddresses)) {
            int n;
            this.logFine("NetworkInterfaces initialiazing or change detected");
            InetAddress[] inetAddressArray = new InetAddress[this.localAddresses.size()];
            this.localAddresses.toArray(inetAddressArray);
            if (this.senderSockets != null) {
                for (n = 0; n < this.senderSockets.length; ++n) {
                    DatagramSocket datagramSocket = this.senderSockets[n];
                    if (datagramSocket == null) continue;
                    try {
                        this.logFine("closing socket");
                        datagramSocket.close();
                        continue;
                    }
                    catch (Exception exception) {
                        this.logSevere("closing socket", exception);
                    }
                }
            }
            this.senderSockets = new DatagramSocket[inetAddressArray.length];
            for (n = 0; n < inetAddressArray.length; ++n) {
                try {
                    this.senderSockets[n] = new DatagramSocket(0, inetAddressArray[n]);
                    if (!this.isFiner()) continue;
                    this.logFiner("Successfully opened broadcast sender for " + inetAddressArray[n]);
                    continue;
                }
                catch (IOException iOException) {
                    if (this.isFiner()) {
                        this.logFiner("Unable to open broadcast sender for " + inetAddressArray[n] + ": " + iOException.getMessage());
                    }
                    this.senderSockets[n] = null;
                }
            }
            this.oldLocalAddresses = (ArrayList)this.localAddresses.clone();
        }
    }

    private void updateLocalAddresses() {
        this.updateNetworkInterfaces();
        this.localAddresses.clear();
        String string = ConfigurationEntry.NET_BIND_ADDRESS.getValueArray(this.getController())[0];
        if (string != null && string.length() > 0) {
            try {
                this.localAddresses.add(InetAddress.getByName(string));
            }
            catch (UnknownHostException unknownHostException) {
                log.log(Level.SEVERE, "Warning, \"net.bindaddress\" is NOT an IP address!", unknownHostException);
            }
        } else {
            for (int i = 0; i < this.localNICList.size(); ++i) {
                NetworkInterface networkInterface = this.localNICList.get(i);
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    this.localAddresses.add(enumeration.nextElement());
                }
            }
        }
    }

    private void updateNetworkInterfaces() {
        Enumeration<NetworkInterface> enumeration;
        this.localNICList.clear();
        try {
            enumeration = NetworkInterface.getNetworkInterfaces();
        }
        catch (Error error) {
            this.logWarning("Unable to get local network interfaces. " + error);
            this.logFiner("Error", error);
            return;
        }
        catch (SocketException socketException) {
            this.logSevere("Unable to get local network interfaces. " + socketException);
            return;
        }
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            this.localNICList.add(networkInterface);
        }
    }

    private class BroadcastSender
    implements Runnable {
        private BroadcastSender() {
        }

        @Override
        public void run() {
            if (BroadcastMananger.this.socket == null || BroadcastMananger.this.socket.isClosed()) {
                return;
            }
            if (BroadcastMananger.this.broadCastString == null) {
                BroadcastMananger.this.logWarning("Not sending network broadcast");
                return;
            }
            DatagramPacket datagramPacket = null;
            byte[] byArray = BroadcastMananger.this.broadCastString.getBytes();
            datagramPacket = new DatagramPacket(byArray, byArray.length, BroadcastMananger.this.group, 1337);
            if (BroadcastMananger.this.isFiner()) {
                BroadcastMananger.this.logFiner("Sending network broadcast");
            }
            BroadcastMananger.this.updateSenderSockets();
            BroadcastMananger.this.sendBroadcast(datagramPacket);
        }
    }
}

