/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.protocol.DownloadRequestProto;
import de.dal33t.powerfolder.protocol.FileInfoProto;

public class RequestDownload
extends Message
implements D2DObject,
D2DEvent {
    private static final long serialVersionUID = 100L;
    public FileInfo file;
    public long startOffset;

    public RequestDownload() {
    }

    public RequestDownload(FileInfo fileInfo) {
        this(fileInfo, 0L);
    }

    public RequestDownload(FileInfo fileInfo, long l) {
        this.file = fileInfo;
        this.startOffset = l;
    }

    public String toString() {
        return "Request to download: " + this.file.toDetailString() + ", starting at " + this.startOffset;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof DownloadRequestProto.DownloadRequest) {
            DownloadRequestProto.DownloadRequest downloadRequest = (DownloadRequestProto.DownloadRequest)abstractMessage;
            this.file = new FileInfo(downloadRequest.getFileInfo());
            this.startOffset = downloadRequest.getStartOffset();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        DownloadRequestProto.DownloadRequest.Builder builder = DownloadRequestProto.DownloadRequest.newBuilder();
        builder.setClazzName("DownloadRequest");
        builder.setFileInfo((FileInfoProto.FileInfo)this.file.toD2D());
        return builder.build();
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.DOWNLOAD_REQUEST;
    }
}

