/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.KnownNodesExt;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.util.Reject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KnownNodes
extends Message {
    private static final Logger log = Logger.getLogger(KnownNodes.class.getName());
    private static final long serialVersionUID = 101L;
    public MemberInfo[] nodes;

    public KnownNodes() {
    }

    public KnownNodes(MemberInfo memberInfo) {
        if (memberInfo == null) {
            throw new NullPointerException("Node is null");
        }
        this.nodes = new MemberInfo[]{memberInfo};
    }

    public KnownNodes(MemberInfo[] memberInfoArray) {
        Reject.ifNull(memberInfoArray, "Nodes is null");
        this.nodes = memberInfoArray;
        if (memberInfoArray.length > 500) {
            log.warning("Nodelist longer than max size: " + this);
        }
    }

    public static Message[] createKnownNodesList(List<MemberInfo> list, boolean bl) {
        if (list.size() < 500) {
            MemberInfo[] memberInfoArray = KnownNodes.getArray(list, 0, list.size());
            KnownNodes knownNodes = bl ? new KnownNodesExt(memberInfoArray) : new KnownNodes(memberInfoArray);
            return new KnownNodes[]{knownNodes};
        }
        int n = list.size() / 500;
        int n2 = list.size() - 500 * n;
        int n3 = n;
        if (n2 > 0) {
            ++n3;
        }
        Message[] messageArray = new KnownNodes[n3];
        for (int i = 0; i < n; ++i) {
            MemberInfo[] memberInfoArray = KnownNodes.getArray(list, i * 500, 500);
            messageArray[i] = bl ? new KnownNodesExt(memberInfoArray) : new KnownNodes(memberInfoArray);
        }
        if (n2 > 0) {
            MemberInfo[] memberInfoArray = KnownNodes.getArray(list, n * 500, n2);
            Message message = messageArray[n3 - 1] = bl ? new KnownNodesExt(memberInfoArray) : new KnownNodes(memberInfoArray);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("Built " + messageArray.length + " nodelists");
        }
        return messageArray;
    }

    private static MemberInfo[] getArray(List<MemberInfo> list, int n, int n2) {
        Reject.ifNull(list, "Nodelist is null");
        Reject.ifTrue(n > list.size(), "Offset (" + n + ") greater than nodelist size (" + list.size() + ")");
        Reject.ifTrue(n + n2 > list.size(), "Lenght (" + n2 + ") exceeds nodelist size (" + list.size() + "), offset (" + n + ")");
        Reject.ifTrue(n < 0, "Offset is below zero");
        int n3 = n + n2;
        MemberInfo[] memberInfoArray = new MemberInfo[n2];
        int n4 = 0;
        for (int i = n; i < n3; ++i) {
            memberInfoArray[n4] = list.get(i);
            ++n4;
        }
        return memberInfoArray;
    }

    public String toString() {
        return "NodeList, " + (this.nodes != null ? this.nodes.length : 0) + " nodes(s)";
    }
}

