/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.light.ServerInfo;
import de.dal33t.powerfolder.message.FolderRelatedMessage;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.security.AuditFields;
import de.dal33t.powerfolder.security.Auditable;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
public class Invitation
extends FolderRelatedMessage
implements Auditable {
    private static final long serialVersionUID = 101L;
    public static final String PROPERTY_OID = "oid";
    public static final String PROPERTY_SENDER_DEVICE = "senderDevice";
    public static final String PROPERTY_INVITATION_TEXT = "invitationText";
    public static final String PROPERTY_SUGGESTED_SYNC_PROFILE_CONFIG = "suggestedSyncProfileConfig";
    public static final String PROPERTY_SUGGESTED_LOCAL_BASE_PATH = "suggestedLocalBasePath";
    public static final String PROPERTY_RELATIVE = "relative";
    public static final String PROPERTY_PERMISSION = "permission";
    public static final String PROPERTY_SERVER = "server";
    public static final String PROPERTY_SENDER = "sender";
    public static final String PROPERTY_RECIPIENT = "recipient";
    @Id
    private String oid;
    @ManyToOne
    @JoinColumn(name="nodeInfo_id")
    private MemberInfo senderDevice;
    @Column(length=2048)
    private String invitationText;
    private String suggestedSyncProfileConfig;
    @Column(length=2048)
    private String suggestedLocalBasePath;
    @Transient
    private int relative;
    @Enumerated(value=EnumType.STRING)
    private PathType pathtype;
    @Type(type="permissionType")
    private FolderPermission permission;
    @ManyToOne
    @JoinColumn(name="serviceInfo_id")
    private ServerInfo server;
    @Index(name="IDX_INV_SENDER")
    private String sender;
    @Index(name="IDX_INV_RECIPIENT")
    private String recipient;
    @Deprecated
    @Transient
    private String username;
    @Deprecated
    @Transient
    private String inviteeUsername;
    @Embedded
    @Fetch(value=FetchMode.JOIN)
    public AuditFields auditFields = new AuditFields();

    public Invitation(FolderPermission folderPermission) {
        this.oid = IdGenerator.makeId();
        this.permission = folderPermission;
        this.folder = folderPermission.getFolder();
    }

    public Invitation(FolderPermission folderPermission, String string) {
        this.oid = string;
        this.permission = folderPermission;
        this.folder = folderPermission.getFolder();
    }

    public Invitation(Invitation invitation) {
        this.oid = IdGenerator.makeId();
        this.folder = invitation.folder;
        this.invitationText = invitation.invitationText;
        this.pathtype = invitation.pathtype;
        this.permission = invitation.permission;
        this.recipient = invitation.recipient;
        this.relative = invitation.relative;
        this.sender = invitation.sender;
        this.senderDevice = invitation.senderDevice;
        this.server = invitation.server;
        this.suggestedLocalBasePath = invitation.suggestedLocalBasePath;
        this.suggestedSyncProfileConfig = invitation.suggestedSyncProfileConfig;
    }

    private Invitation() {
    }

    public String getOID() {
        return this.oid;
    }

    public void setSuggestedSyncProfile(SyncProfile syncProfile) {
        this.suggestedSyncProfileConfig = syncProfile.getFieldList();
    }

    public void setPermission(FolderPermission folderPermission) {
        this.permission = folderPermission;
    }

    public void setSuggestedLocalBase(Controller controller, Path path) {
        Reject.ifNull(path, "File is null");
        String string = controller.getFolderRepository().getFoldersBasedirString();
        String string2 = Invitation.getAppsDir();
        String string3 = Invitation.getUserHomeDir();
        if (OSUtil.isWindowsSystem() && string2 != null && path.toAbsolutePath().startsWith(string2)) {
            String string4 = path.toAbsolutePath().toString();
            this.suggestedLocalBasePath = string4.substring(string2.length());
            while (this.suggestedLocalBasePath.startsWith(path.getFileSystem().getSeparator())) {
                this.suggestedLocalBasePath = this.suggestedLocalBasePath.substring(1);
            }
            this.pathtype = PathType.RELATIVE_APP_DATA;
        } else if (string != null && path.toAbsolutePath().startsWith(string)) {
            String string5 = path.toAbsolutePath().toString();
            String string6 = controller.getFolderRepository().getFoldersBasedirString();
            this.suggestedLocalBasePath = string5.substring(string6.length());
            while (this.suggestedLocalBasePath.startsWith(path.getFileSystem().getSeparator())) {
                this.suggestedLocalBasePath = this.suggestedLocalBasePath.substring(1);
            }
            this.pathtype = PathType.RELATIVE_PF_BASE;
        } else if (string3 != null && path.toAbsolutePath().startsWith(string3)) {
            String string7 = path.toAbsolutePath().toString();
            this.suggestedLocalBasePath = string7.substring(string3.length());
            while (this.suggestedLocalBasePath.startsWith(path.getFileSystem().getSeparator())) {
                this.suggestedLocalBasePath = this.suggestedLocalBasePath.substring(1);
            }
            this.pathtype = PathType.RELATIVE_USER_HOME;
        } else {
            this.suggestedLocalBasePath = path.toAbsolutePath().toString();
            this.pathtype = PathType.ABSOLUTE;
        }
    }

    public Path getSuggestedLocalBase(Controller controller) {
        if (this.suggestedLocalBasePath == null) {
            return controller.getFolderRepository().getFoldersBasedir().resolve(PathUtils.removeInvalidFilenameChars(this.folder.getName()));
        }
        this.suggestedLocalBasePath = OSUtil.isLinux() || OSUtil.isMacOS() ? Util.replace(this.suggestedLocalBasePath, "\\", FileSystems.getDefault().getSeparator()) : Util.replace(this.suggestedLocalBasePath, "/", FileSystems.getDefault().getSeparator());
        if (this.pathtype == PathType.RELATIVE_APP_DATA) {
            return Paths.get(Invitation.getAppsDir(), this.suggestedLocalBasePath);
        }
        if (this.pathtype == PathType.RELATIVE_PF_BASE) {
            Path path = controller.getFolderRepository().getFoldersBasedir();
            return path.resolve(this.suggestedLocalBasePath);
        }
        if (this.pathtype == PathType.RELATIVE_USER_HOME) {
            return Paths.get(Invitation.getUserHomeDir(), this.suggestedLocalBasePath);
        }
        return Paths.get(this.suggestedLocalBasePath, new String[0]);
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String string) {
        this.sender = string;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String string) {
        this.recipient = string;
    }

    public ServerInfo getServer() {
        return this.server;
    }

    public void setServer(ServerInfo serverInfo) {
        this.server = serverInfo;
    }

    public MemberInfo getSenderDevice() {
        return this.senderDevice;
    }

    public void setSenderDevice(MemberInfo memberInfo) {
        this.senderDevice = memberInfo;
    }

    public String getInvitationText() {
        return this.invitationText;
    }

    public void setInvitationText(String string) {
        this.invitationText = string;
    }

    public FolderPermission getPermission() {
        return this.permission;
    }

    public void populateFolderInfoFromPermission() {
        this.folder = this.permission.getFolder();
    }

    public SyncProfile getSuggestedSyncProfile() {
        if (this.suggestedSyncProfileConfig == null) {
            return SyncProfile.AUTOMATIC_SYNCHRONIZATION;
        }
        return SyncProfile.getSyncProfileByFieldList(this.suggestedSyncProfileConfig);
    }

    private static String getAppsDir() {
        if (OSUtil.isWindowsSystem()) {
            return WinUtils.getAppDataCurrentUser();
        }
        return Invitation.getUserHomeDir();
    }

    private static String getUserHomeDir() {
        return System.getProperty("user.home");
    }

    @Override
    public void setCreatedNowBy(Account account) {
        this.auditFields().setCreatedNowBy(account);
    }

    @Override
    public void setModifiedNowBy(Account account) {
        this.auditFields().setModifiedNowBy(account);
    }

    private AuditFields auditFields() {
        if (this.auditFields == null) {
            this.auditFields = new AuditFields();
        }
        return this.auditFields;
    }

    public String toString() {
        Object object = "";
        if (this.senderDevice != null) {
            object = " (" + this.senderDevice + ")";
        }
        return "Invitation to " + this.folder + " from " + this.sender + (String)object + " to " + this.recipient;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = n * n2 + (this.oid == null ? 0 : this.oid.hashCode());
        n2 = n * n2 + (this.invitationText == null ? 0 : this.invitationText.hashCode());
        n2 = n * n2 + (this.senderDevice == null ? 0 : this.senderDevice.hashCode());
        n2 = n * n2 + (this.permission == null ? 0 : this.permission.hashCode());
        n2 = n * n2 + (this.username == null ? 0 : this.username.hashCode());
        n2 = n * n2 + (this.inviteeUsername == null ? 0 : this.inviteeUsername.hashCode());
        n2 = n * n2 + (this.suggestedLocalBasePath == null ? 0 : this.suggestedLocalBasePath.hashCode());
        n2 = n * n2 + (this.suggestedSyncProfileConfig == null ? 0 : this.suggestedSyncProfileConfig.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Invitation invitation = (Invitation)object;
        if (this.oid == null ? invitation.oid != null : !this.oid.equals(invitation.oid)) {
            return false;
        }
        if (this.invitationText == null ? invitation.invitationText != null : !this.invitationText.equals(invitation.invitationText)) {
            return false;
        }
        if (this.senderDevice == null ? invitation.senderDevice != null : !this.senderDevice.equals(invitation.senderDevice)) {
            return false;
        }
        if (this.username == null ? invitation.username != null : !this.username.equals(invitation.username)) {
            return false;
        }
        if (this.inviteeUsername == null ? invitation.inviteeUsername != null : !this.inviteeUsername.equals(invitation.inviteeUsername)) {
            return false;
        }
        if (this.permission == null ? invitation.permission != null : !this.permission.equals(invitation.permission)) {
            return false;
        }
        if (this.relative != invitation.relative) {
            return false;
        }
        if (this.suggestedLocalBasePath == null ? invitation.suggestedLocalBasePath != null : !this.suggestedLocalBasePath.equals(invitation.suggestedLocalBasePath)) {
            return false;
        }
        if (this.suggestedSyncProfileConfig == null) {
            return invitation.suggestedSyncProfileConfig == null;
        }
        return this.suggestedSyncProfileConfig.equals(invitation.suggestedSyncProfileConfig);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (StringUtils.isBlank(this.sender) && StringUtils.isNotBlank(this.username)) {
            this.sender = this.username;
        }
        if (StringUtils.isBlank(this.recipient) && StringUtils.isNotBlank(this.inviteeUsername)) {
            this.recipient = this.inviteeUsername;
        }
        this.pathtype = PathType.ABSOLUTE.getPathTypeForIndex(this.relative);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (StringUtils.isBlank(this.inviteeUsername) && StringUtils.isNotBlank(this.recipient)) {
            this.inviteeUsername = this.recipient;
        }
        if (StringUtils.isBlank(this.username) && StringUtils.isNotBlank(this.sender)) {
            this.username = this.sender;
        }
        if (this.pathtype != null) {
            this.relative = this.pathtype.getIndex();
        }
        objectOutputStream.defaultWriteObject();
    }

    @Deprecated
    public String getInvitorUsername() {
        if (StringUtils.isBlank(this.sender)) {
            if (this.senderDevice == null) {
                return "";
            }
            return this.senderDevice.getNick();
        }
        return this.sender;
    }

    @Deprecated
    public void setInvitorUsername(String string) {
        this.username = string;
    }

    @Deprecated
    public String getInviteeUsername() {
        return this.inviteeUsername;
    }

    @Deprecated
    public void setInviteeUsername(String string) {
        this.inviteeUsername = string;
    }

    public boolean isFolderInvitation() {
        return StringUtils.isNotBlank(this.folder.getId()) && !this.folder.getId().startsWith("AI_");
    }

    public boolean isAccountInvitation() {
        return StringUtils.isBlank(this.folder.getId()) || this.folder.getId().startsWith("AI_");
    }

    private static enum PathType {
        ABSOLUTE(0),
        RELATIVE_APP_DATA(1),
        RELATIVE_PF_BASE(2),
        RELATIVE_USER_HOME(3);

        int index;

        private PathType(int n2) {
            this.index = n2;
        }

        PathType getPathTypeForIndex(int n) {
            switch (n) {
                case 0: {
                    return ABSOLUTE;
                }
                case 1: {
                    return RELATIVE_APP_DATA;
                }
                case 2: {
                    return RELATIVE_PF_BASE;
                }
                case 3: {
                    return RELATIVE_USER_HOME;
                }
            }
            return ABSOLUTE;
        }

        int getIndex() {
            return this.index;
        }
    }
}

