/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.light;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.ImmutableList;
import de.dal33t.powerfolder.util.Reject;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;

public class FileHistory
implements Serializable {
    private int hashCode;
    private static final Logger log = Logger.getLogger(FileHistory.class.getName());
    private static final long serialVersionUID = 100L;
    private final ImmutableList<Record> history;

    private FileHistory(Record record) {
        Reject.ifNull(record, "file is null!");
        this.history = new ImmutableList<Record>(record);
    }

    private FileHistory(ImmutableList<Record> immutableList) {
        this.history = immutableList;
    }

    public Record getRecord() {
        return this.history.getHead();
    }

    public Conflict getConflictWith(FileHistory fileHistory) {
        Reject.notNull(fileHistory, "other");
        if (this.getRecord().getFileInfo().isVersionDateAndSizeIdentical(fileHistory.getRecord().getFileInfo()) || !this.getRecord().getFileInfo().equals(fileHistory.getRecord().getFileInfo())) {
            return null;
        }
        FileInfo fileInfo = this.getCommonVersion(fileHistory);
        if (fileInfo == null || !fileInfo.isVersionDateAndSizeIdentical(this.getRecord().getFileInfo()) && !fileInfo.isVersionDateAndSizeIdentical(fileHistory.getRecord().getFileInfo())) {
            return new Conflict(this.getRecord().getFileInfo(), fileHistory.getRecord().getFileInfo(), fileInfo);
        }
        return null;
    }

    public FileHistory addVersion(Record record) {
        Reject.ifNull(record, "newRecord is null");
        if (this.history.getTail() != null) {
            FileInfo fileInfo = record.fileInfo;
            FileInfo fileInfo2 = this.history.getTail().getHead().fileInfo;
            if (fileInfo2.getVersion() >= fileInfo.getVersion()) {
                throw new IllegalStateException("Strange history add. Last file: " + fileInfo2.toDetailString() + ", added: " + fileInfo.toDetailString());
            }
        }
        return new FileHistory(this.history.add(record));
    }

    public FileInfo getCommonVersion(FileHistory fileHistory) {
        HashSet<FileInfo> hashSet = new HashSet<FileInfo>();
        for (Record record : this.history) {
            hashSet.add(record.fileInfo);
        }
        for (Record record : fileHistory.history) {
            if (!hashSet.contains(record.fileInfo)) continue;
            return record.fileInfo;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() != this.getClass()) {
            return false;
        }
        return this.structuralEquals((FileHistory)object);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 19;
            for (Record record : this.history) {
                this.hashCode = this.hashCode * 37 + record.hashCode();
            }
            if (this.hashCode == 0) {
                this.hashCode = -1;
            }
        }
        return this.hashCode;
    }

    private boolean structuralEquals(FileHistory fileHistory) {
        if (this == fileHistory) {
            return true;
        }
        if (fileHistory == null) {
            return false;
        }
        Iterator<Record> iterator = this.history.iterator();
        Iterator<Record> iterator2 = fileHistory.history.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (iterator.next().equals(iterator2.next())) continue;
            return false;
        }
        return iterator.hasNext() == iterator2.hasNext();
    }

    public static class Record {
        private final FileInfo mergedFirst;
        private final FileInfo mergedSecond;
        private final FileInfo fileInfo;

        public Record(FileInfo fileInfo, FileInfo fileInfo2, FileInfo fileInfo3) {
            this.mergedFirst = fileInfo;
            this.mergedSecond = fileInfo2;
            this.fileInfo = fileInfo3;
        }

        public FileInfo getMergedFirst() {
            return this.mergedFirst;
        }

        public FileInfo getMergedSecond() {
            return this.mergedSecond;
        }

        public boolean wasMerged() {
            return this.mergedFirst != null;
        }

        public FileInfo getFileInfo() {
            return this.fileInfo;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.fileInfo == null ? 0 : this.fileInfo.hashCode());
            n = 31 * n + (this.mergedFirst == null ? 0 : this.mergedFirst.hashCode());
            n = 31 * n + (this.mergedSecond == null ? 0 : this.mergedSecond.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Record record = (Record)object;
            if (!this.fileInfo.equals(record.fileInfo)) {
                return false;
            }
            if (this.mergedFirst == null ? record.mergedFirst != null : !this.mergedFirst.equals(record.mergedFirst)) {
                return false;
            }
            return !(this.mergedSecond == null ? record.mergedSecond != null : !this.mergedSecond.equals(record.mergedSecond));
        }
    }

    public static class Conflict {
        private final FileInfo localFileInfo;
        private final FileInfo otherFileInfo;
        private final FileInfo ancestorFileInfo;

        public Conflict(FileInfo fileInfo, FileInfo fileInfo2, FileInfo fileInfo3) {
            this.localFileInfo = fileInfo;
            this.otherFileInfo = fileInfo2;
            this.ancestorFileInfo = fileInfo3;
        }

        public FileInfo getLocalFileInfo() {
            return this.localFileInfo;
        }

        public FileInfo getOtherFileInfo() {
            return this.otherFileInfo;
        }

        public FileInfo getAncestorFileInfo() {
            return this.ancestorFileInfo;
        }
    }
}

