/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.event.api;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;

public abstract class WebHook
extends PFComponent {
    private final String url;
    private HttpClient client;
    private List<NameValuePair> parameters;

    public WebHook(Controller controller, ConfigurationEntry configurationEntry) {
        this(controller, configurationEntry.getValue(controller));
    }

    public WebHook(Controller controller, String string) {
        super(controller);
        this.url = string;
        if (StringUtils.isNotBlank(string)) {
            this.parameters = new ArrayList<NameValuePair>();
            this.client = Util.createHttpClientBuilder(controller).build();
        }
    }

    protected void addParameter(String string, String string2) {
        if (this.parameters != null) {
            this.parameters.add(new BasicNameValuePair(string, string2));
        }
    }

    protected void addParameter(String string, Object object) {
        if (this.parameters != null) {
            this.parameters.add(new BasicNameValuePair(string, object.toString()));
        }
    }

    public final void happened(boolean bl) {
        if (this.client == null) {
            return;
        }
        if (bl) {
            this.getController().getIOProvider().startIO(() -> this.execute());
        } else {
            this.execute();
        }
    }

    private void execute() {
        try {
            HttpPost httpPost = new HttpPost(this.url);
            if (this.parameters != null) {
                this.parameters.add(new BasicNameValuePair("event", this.getClass().getSimpleName()));
                httpPost.setEntity(new UrlEncodedFormEntity(this.parameters, Convert.UTF8));
            }
            this.logInfo("Executing " + this.getClass().getSimpleName() + " to " + this.url);
            this.client.execute(httpPost);
        }
        catch (IOException iOException) {
            this.logWarning("Exception while executing POST to " + this.url + " : " + iOException);
        }
        catch (RuntimeException runtimeException) {
            this.logWarning("RuntimeException while executing POST to " + this.url + " : " + runtimeException, runtimeException);
        }
    }
}

