/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;

public class NoConflictDetectionPossible
extends ResolvableProblem {
    private final String desc;
    private final FileInfo fileInfo;

    public NoConflictDetectionPossible(FileInfo fileInfo, MemberInfo memberInfo) {
        Reject.notNull(fileInfo, "fileInfo");
        Reject.notNull(memberInfo, "oldSource");
        this.fileInfo = fileInfo;
        this.desc = Translation.get("folder_problem.noconflictdetection", fileInfo.getRelativeName(), memberInfo.nick);
    }

    @Override
    public Folder getFolder(Controller controller) {
        return null;
    }

    @Override
    public String getResolutionDescription() {
        return null;
    }

    @Override
    public Runnable resolution(Controller controller) {
        return null;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getWikiLinkKey() {
        return "Version_Conflict_With_Old_Client";
    }

    public boolean equals(Object object) {
        if (object.getClass() != this.getClass()) {
            return false;
        }
        NoConflictDetectionPossible noConflictDetectionPossible = (NoConflictDetectionPossible)object;
        return noConflictDetectionPossible.fileInfo.equals(this.fileInfo);
    }

    public int hashCode() {
        return 37 + this.fileInfo.hashCode();
    }
}

