/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.FileProblemHelper;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.util.Translation;

public class IllegalCharsFilenameProblem
extends ResolvableProblem {
    private final String description;
    private final FileInfo fileInfo;
    private final String[] illegalChars;

    IllegalCharsFilenameProblem(FileInfo fileInfo, String[] stringArray) {
        this.fileInfo = fileInfo;
        this.description = Translation.get("filename_problem.not_recommended_chars", fileInfo.getFilenameOnly());
        this.illegalChars = stringArray;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getWikiLinkKey() {
        return "Illegal-Chars";
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.fileInfo.getFolder(controller.getFolderRepository());
    }

    @Override
    public Runnable resolution(final Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                String string = FileProblemHelper.removeChars(IllegalCharsFilenameProblem.this.fileInfo.getFilenameOnly(), IllegalCharsFilenameProblem.this.illegalChars);
                FileProblemHelper.resolve(controller, IllegalCharsFilenameProblem.this.fileInfo, string, IllegalCharsFilenameProblem.this);
            }
        };
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("filename_problem.not_recommended_chars.soln_desc");
    }
}

