/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;

public class AccessDeniedProblem
extends ResolvableProblem {
    private final FolderInfo folderInfo;

    public AccessDeniedProblem(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folder");
        this.folderInfo = folderInfo;
    }

    @Override
    public String getDescription() {
        return Translation.get("folder_problem.access_denied");
    }

    @Override
    public String getWikiLinkKey() {
        return "Security_Permissions";
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.folderInfo.getFolder(controller);
    }

    @Override
    public Runnable resolution(final Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                final Folder folder = controller.getFolderRepository().getFolder(AccessDeniedProblem.this.folderInfo);
                if (folder != null) {
                    controller.getIOProvider().startIO(new Runnable(){

                        @Override
                        public void run() {
                            controller.getFolderRepository().addToIgnoredFolders(folder);
                            controller.getFolderRepository().removeFolder(folder, false);
                        }
                    });
                }
            }
        };
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("folder_problem.access_denied.remove_folder");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.folderInfo == null ? 0 : this.folderInfo.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof AccessDeniedProblem)) {
            return false;
        }
        AccessDeniedProblem accessDeniedProblem = (AccessDeniedProblem)object;
        return !(this.folderInfo == null ? accessDeniedProblem.folderInfo != null : !this.folderInfo.equals(accessDeniedProblem.folderInfo));
    }
}

