/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.SyncProfileConfiguration;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Translation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class SyncProfile
implements Serializable {
    private static final long serialVersionUID = 100L;
    public static final String FIELD_LIST_DELIMITER = ",";
    public static final SyncProfile HOST_FILES = new SyncProfile("host_files", false, new SyncProfileConfiguration(false, false, false, false, 30, false, 12, 1, "m", true));
    public static final SyncProfile AUTOMATIC_DOWNLOAD = new SyncProfile("automatic_download", false, new SyncProfileConfiguration(true, true, false, false, 30, false, 12, 1, "m", true));
    public static final SyncProfile AUTOMATIC_SYNCHRONIZATION = new SyncProfile("auto_sync", false, new SyncProfileConfiguration(true, true, true, true, 1, false, 12, 1, "m", true));
    public static final SyncProfile BACKUP_SOURCE = new SyncProfile("backup_source", false, new SyncProfileConfiguration(false, false, false, false, 1, false, 12, 1, "m", true));
    public static final SyncProfile BACKUP_TARGET = new SyncProfile("backup_target", false, new SyncProfileConfiguration(true, true, true, true, 60));
    public static final SyncProfile MANUAL_SYNCHRONIZATION = new SyncProfile("manual_synchronization", false, new SyncProfileConfiguration(false, false, false, false, 0));
    public static final SyncProfile SCAN_EVERY_24_HOURS = new SyncProfile("sync_every_24_hours", false, new SyncProfileConfiguration(true, true, true, true, 24, false, 12, 1, "h", false));
    private static final SyncProfile[] PRESET_SYNC_PROFILES = new SyncProfile[]{AUTOMATIC_SYNCHRONIZATION, MANUAL_SYNCHRONIZATION, BACKUP_SOURCE, BACKUP_TARGET, AUTOMATIC_DOWNLOAD, HOST_FILES, SCAN_EVERY_24_HOURS};
    public static final SyncProfile NO_SYNC = new SyncProfile("no_sync", false, new SyncProfileConfiguration(false, false, false, false, 0));
    public static final SyncProfile DISABLED = new SyncProfile("disabled", false, new SyncProfileConfiguration(false, false, true, true, 0));
    public static final SyncProfile BACKUP_TARGET_NO_CHANGE_DETECT = new SyncProfile("backup_target_no_change", false, new SyncProfileConfiguration(true, true, true, true, 0));
    public static SyncProfile META_FOLDER_SYNC = new SyncProfile("backup_target_no_change", false, new SyncProfileConfiguration(true, true, true, true, 1));
    private static final List<SyncProfile> customProfiles = new ArrayList<SyncProfile>();
    private String profileName;
    private String profileId;
    private final boolean custom;
    private SyncProfileConfiguration configuration;

    private SyncProfile(String string, boolean bl, SyncProfileConfiguration syncProfileConfiguration) {
        if (bl) {
            this.profileName = string;
        } else {
            this.profileId = string;
        }
        this.custom = bl;
        this.configuration = syncProfileConfiguration;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public String getName() {
        if (this.custom) {
            return this.profileName;
        }
        return SyncProfile.translateId(this.profileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        Reject.ifFalse(this.custom, "Cannot set the profileName of preset profile " + this.getName() + " to " + string);
        Reject.ifBlank(string, "ProfileName not supplied");
        for (SyncProfile syncProfile : PRESET_SYNC_PROFILES) {
            if (this.equals(syncProfile) || !syncProfile.getName().equals(string)) continue;
            throw new RuntimeException("Preset profile name already exists.");
        }
        List<SyncProfile> list = customProfiles;
        synchronized (list) {
            for (SyncProfile syncProfile : customProfiles) {
                if (this.equals(syncProfile) || !syncProfile.getName().equals(string)) continue;
                throw new RuntimeException("Custom profile name already exists.");
            }
        }
        this.profileName = string;
    }

    public SyncProfileConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(SyncProfileConfiguration syncProfileConfiguration) {
        Reject.ifFalse(this.custom, "Cannot set the configuration of preset profile " + this.getName());
        Reject.ifNull(syncProfileConfiguration, "configuration not supplied");
        for (SyncProfile syncProfile : PRESET_SYNC_PROFILES) {
            if (this.equals(syncProfile) || !syncProfile.configuration.equals(syncProfileConfiguration)) continue;
            throw new RuntimeException("Preset profile config already exists.");
        }
        List<SyncProfile> list = customProfiles;
        synchronized (list) {
            for (SyncProfile syncProfile : customProfiles) {
                if (this.equals(syncProfile) || !syncProfile.configuration.equals(syncProfileConfiguration)) continue;
                throw new RuntimeException("Custom profile config already exists.");
            }
        }
        this.configuration = syncProfileConfiguration;
    }

    public String getFieldList() {
        return this.configuration.isAutoDownload() + FIELD_LIST_DELIMITER + this.configuration.isAutoDownload() + FIELD_LIST_DELIMITER + this.configuration.isSyncDeletion() + FIELD_LIST_DELIMITER + this.configuration.isSyncDeletion() + FIELD_LIST_DELIMITER + this.configuration.getTimeBetweenRegularScans() + FIELD_LIST_DELIMITER + this.configuration.isDailySync() + FIELD_LIST_DELIMITER + this.configuration.getDailyHour() + FIELD_LIST_DELIMITER + this.configuration.getDailyDay() + FIELD_LIST_DELIMITER + this.configuration.getRegularTimeType() + FIELD_LIST_DELIMITER + this.getName() + FIELD_LIST_DELIMITER + this.configuration.isInstantSync();
    }

    private static String translateId(String string) {
        return Translation.get("transfer_mode." + string + ".name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyncProfile retrieveSyncProfile(String string, SyncProfileConfiguration syncProfileConfiguration) {
        SyncProfile syncProfile;
        Object object;
        Reject.ifNull(syncProfileConfiguration, "Null sync profile configuration");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SyncProfile n : PRESET_SYNC_PROFILES) {
            if (n.configuration.equals(syncProfileConfiguration)) {
                return n;
            }
            arrayList.add(n.getName());
        }
        List<SyncProfile> bl = customProfiles;
        synchronized (bl) {
            object = customProfiles.iterator();
            while (object.hasNext()) {
                SyncProfile syncProfile2 = object.next();
                if (syncProfile2.configuration.equals(syncProfileConfiguration)) {
                    return syncProfile2;
                }
                arrayList.add(syncProfile2.getName());
            }
        }
        boolean bl2 = string.trim().length() == 0;
        Object object2 = object = bl2 ? SyncProfile.translateId("custom") : string;
        if (arrayList.contains(object) || bl2) {
            int list = 1;
            while (arrayList.contains((String)object + " " + list)) {
                ++list;
            }
            syncProfile = new SyncProfile((String)object + " " + list, true, syncProfileConfiguration);
        } else {
            syncProfile = new SyncProfile((String)object, true, syncProfileConfiguration);
        }
        List<SyncProfile> list = customProfiles;
        synchronized (list) {
            customProfiles.add(syncProfile);
        }
        return syncProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SyncProfile> getSyncProfilesCopy() {
        ArrayList<SyncProfile> arrayList = new ArrayList<SyncProfile>(Arrays.asList(PRESET_SYNC_PROFILES));
        List<SyncProfile> list = customProfiles;
        synchronized (list) {
            for (SyncProfile syncProfile : customProfiles) {
                if (arrayList.contains(syncProfile)) continue;
                arrayList.add(syncProfile);
            }
        }
        return arrayList;
    }

    public static SyncProfile getSyncProfileByFieldList(String string) {
        Reject.ifNull(string, "Null sync profile fieldList");
        if (!string.contains(FIELD_LIST_DELIMITER)) {
            for (SyncProfile syncProfile : PRESET_SYNC_PROFILES) {
                if (!string.equals(syncProfile.profileId)) continue;
                return syncProfile;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, FIELD_LIST_DELIMITER);
        int n = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n = Boolean.parseBoolean(stringTokenizer.nextToken()) ? 1 : 0;
        }
        int n2 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n2 = Boolean.parseBoolean(stringTokenizer.nextToken()) ? 1 : 0;
        }
        boolean bl = false;
        if (stringTokenizer.hasMoreTokens()) {
            bl = Boolean.parseBoolean(stringTokenizer.nextToken());
        }
        boolean bl2 = false;
        if (stringTokenizer.hasMoreTokens()) {
            bl2 = Boolean.parseBoolean(stringTokenizer.nextToken());
        }
        int n3 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n3 = Integer.parseInt(stringTokenizer.nextToken());
        }
        boolean bl3 = false;
        if (stringTokenizer.hasMoreTokens()) {
            bl3 = Boolean.parseBoolean(stringTokenizer.nextToken());
        }
        int n4 = 12;
        if (stringTokenizer.hasMoreTokens()) {
            n4 = Integer.parseInt(stringTokenizer.nextToken());
        }
        int n5 = 0;
        if (stringTokenizer.hasMoreTokens()) {
            n5 = Integer.parseInt(stringTokenizer.nextToken());
        }
        String string2 = "m";
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        String string3 = "";
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        boolean bl4 = false;
        if (stringTokenizer.hasMoreTokens()) {
            bl4 = Boolean.parseBoolean(stringTokenizer.nextToken());
        }
        return SyncProfile.retrieveSyncProfile(string3, new SyncProfileConfiguration(n != 0, n2 != 0, bl, bl2, n3, bl3, n4, n5, string2, bl4));
    }

    public static SyncProfile getDefault(Controller controller) {
        String string = ConfigurationEntry.DEFAULT_TRANSFER_MODE.getValue(controller);
        try {
            if (ConfigurationEntry.UNC_TRANSFER_MODE.hasNonBlankValue(controller) && PathUtils.isNetworkPath(controller.getFolderRepository().getFoldersBasedir())) {
                string = ConfigurationEntry.UNC_TRANSFER_MODE.getValue(controller);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(SyncProfile.class.getName()).severe("Unable to get default transfer mode for network drive " + ConfigurationEntry.UNC_TRANSFER_MODE.getValue(controller) + ". " + iOException);
        }
        try {
            return SyncProfile.getSyncProfileByFieldList(string);
        }
        catch (Exception exception) {
            Logger.getLogger(SyncProfile.class.getName()).severe("Unable to get default transfer mode for " + string + ". Please check your config: " + exception);
            return SyncProfile.getSyncProfileByFieldList(ConfigurationEntry.DEFAULT_TRANSFER_MODE.getDefaultValue());
        }
    }

    public boolean isInstantSync() {
        return this.configuration.isInstantSync();
    }

    public boolean isPeriodicSync() {
        return this.configuration.isPeriodicSync();
    }

    public boolean isManualSync() {
        return this.configuration.isManualSync();
    }

    public boolean isDailySync() {
        return this.configuration.isDailySync();
    }

    public int getSecondsBetweenScans() {
        String string = this.configuration.getRegularTimeType();
        if (this.configuration.getRegularTimeType() == null) {
            string = "m";
        }
        if ("s".equals(string)) {
            return this.configuration.getTimeBetweenRegularScans();
        }
        if ("h".equals(string)) {
            return this.configuration.getTimeBetweenRegularScans() * 3600;
        }
        return this.configuration.getTimeBetweenRegularScans() * 60;
    }

    public boolean isAutodownload() {
        return this.configuration.isAutoDownload();
    }

    public boolean isSyncDeletion() {
        return this.configuration.isSyncDeletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteProfile(SyncProfile syncProfile) {
        List<SyncProfile> list = customProfiles;
        synchronized (list) {
            Iterator<SyncProfile> iterator = customProfiles.iterator();
            while (iterator.hasNext()) {
                SyncProfile syncProfile2 = iterator.next();
                if (!syncProfile2.equals(syncProfile)) continue;
                iterator.remove();
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SyncProfile syncProfile = (SyncProfile)object;
        return this.configuration.equals(syncProfile.configuration);
    }

    public int hashCode() {
        return this.configuration.hashCode();
    }

    public String toString() {
        return "SyncProfile{profileId='" + this.profileId + "', custom=" + this.custom + ", profileId='" + this.profileId + "', configuration=" + this.configuration + "}";
    }
}

