/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.EncryptedFileSystemUtils;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.UserDirectories;
import de.dal33t.powerfolder.util.UserDirectory;
import de.dal33t.powerfolder.util.Util;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class FolderSettings {
    public static final Logger LOG = Logger.getLogger(FolderSettings.class.getName());
    public static final String PREFIX_V4 = "f.";
    public static final String ID = ".id";
    public static final String SYNC_PROFILE = ".syncprofile";
    public static final String DIR = ".dir";
    public static final String COMMIT_DIR = ".commit-dir";
    public static final String DOWNLOAD_SCRIPT = ".dlscript";
    public static final String NAME = ".name";
    public static final String VERSIONS = ".versions";
    public static final String SYNC_PATTERNS = ".sync-patterns";
    public static final String EXCLUDES = ".excludes";
    public static final String SYNC_WARN_SECONDS = ".sync-warn-seconds";
    public static final String FOLDER_ID_FROM_ACCOUNT = "$fromAccount";
    private static final String PRE_777_BACKUP_TARGET_FIELD_LIST = "true,true,true,true,0,false,12,0,m";
    private static final String PRE_2040_AUTOMATIC_SYNCHRONIZATION_FIELD_LIST = "true,true,true,true,1,false,12,0,m," + Translation.get("transfer_mode.automatic_synchronization.name");
    private static final String PRE_2040_AUTOMATIC_SYNCHRONIZATION_10MIN_FIELD_LIST = "true,true,true,true,10,false,12,0,m," + Translation.get("transfer_mode.automatic_synchronization_10min.name");
    private static final String PRE_2074_BACKUP_SOURCE_5MIN_FIELD_LIST = "false,false,false,false,5,false,12,0,m," + Translation.get("transfer_mode.backup_source_5min.name") + ",false";
    private static final String PRE_2074_BACKUP_SOURCE_HOUR_FIELD_LIST = "false,false,false,false,60,false,12,0,m," + Translation.get("transfer_mode.backup_source_hour.name") + ",false";
    private String localBaseDirStr;
    private final Path localBaseDir;
    private final Path commitDir;
    private final SyncProfile syncProfile;
    private final int versions;
    private final String downloadScript;
    private final boolean syncPatterns;
    private String excludes;
    private final int syncWarnSeconds;
    private String configEntryId;

    public FolderSettings(Path path, SyncProfile syncProfile, int n) {
        this(path, syncProfile, null, n, true);
    }

    public FolderSettings(Path path, SyncProfile syncProfile, String string, int n, boolean bl) {
        this(path, syncProfile, string, n, bl, null, 0);
    }

    public FolderSettings(Path path, SyncProfile syncProfile, String string, int n, boolean bl, Path path2, int n2) {
        Reject.ifNull(path, "Local base dir required");
        Reject.ifNull(syncProfile, "Sync profile required");
        this.localBaseDir = path;
        this.commitDir = path2;
        this.syncProfile = syncProfile;
        this.downloadScript = string;
        this.versions = n;
        this.syncPatterns = bl;
        this.syncWarnSeconds = n2;
        this.excludes = null;
        this.configEntryId = new String(Util.encodeHex(Util.md5(IdGenerator.makeIdBytes())));
    }

    public Path getLocalBaseDir() {
        return this.localBaseDir;
    }

    public Path getCommitDir() {
        return this.commitDir;
    }

    public String getLocalBaseDirString() {
        if (this.localBaseDirStr == null) {
            return this.localBaseDir.toString();
        }
        return this.localBaseDirStr;
    }

    public SyncProfile getSyncProfile() {
        return this.syncProfile;
    }

    public int getVersions() {
        return this.versions;
    }

    public String getDownloadScript() {
        return this.downloadScript;
    }

    public boolean isSyncPatterns() {
        return this.syncPatterns;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public int getSyncWarnSeconds() {
        return this.syncWarnSeconds;
    }

    public String getConfigEntryId() {
        return this.configEntryId;
    }

    public static String loadFolderName(Properties properties, String string) {
        Reject.ifBlank(string, "EntryId");
        return properties.getProperty(PREFIX_V4 + string + NAME);
    }

    public static String loadFolderID(Properties properties, String string) {
        Reject.ifBlank(string, "EntryId");
        return properties.getProperty(PREFIX_V4 + string + ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> loadEntryIds(Properties properties) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Properties properties2 = properties;
        synchronized (properties2) {
            for (Object object : properties.keySet()) {
                String string = (String)object;
                if (!string.startsWith(PREFIX_V4)) continue;
                int n = string.indexOf(46);
                int n2 = string.indexOf(46, n + 1);
                if (n <= 0 || n2 <= 0 || n2 >= string.length()) continue;
                String string2 = string.substring(n + 1, n2);
                treeSet.add(string2);
            }
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEntries(Properties properties, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Properties properties2 = properties;
        synchronized (properties2) {
            for (Object object : properties.keySet()) {
                String string2 = (String)object;
                if (!string2.startsWith(PREFIX_V4 + string + ".")) continue;
                hashSet.add(string2);
            }
        }
        for (String string3 : hashSet) {
            properties.remove(string3);
        }
    }

    public static FolderSettings load(Controller controller, String string) {
        int n = ConfigurationEntry.DEFAULT_ARCHIVE_VERSIONS.getValueInt(controller);
        String string2 = ConfigurationEntry.DEFAULT_TRANSFER_MODE.getValue(controller);
        String string3 = controller.getConfig().getProperty(PREFIX_V4 + string + DIR);
        if (ConfigurationEntry.UNC_TRANSFER_MODE.hasNonBlankValue(controller) && string3 != null && string3.startsWith("\\\\")) {
            string2 = ConfigurationEntry.UNC_TRANSFER_MODE.getValue(controller);
            LOG.info("Took UNC transfer mode for path " + string3 + ": " + string2);
        }
        boolean bl = ConfigurationEntry.FOLDER_MAP_USER_DIRECTORIES.getValueBoolean(controller);
        return FolderSettings.load(controller.getConfig(), string, n, string2, bl, true);
    }

    public static FolderSettings load(Properties properties, String string, int n, String string2, boolean bl, boolean bl2) {
        int n2;
        String string3;
        Reject.ifNull(properties, "Config");
        Reject.ifBlank(string, "Entry Id");
        String string4 = properties.getProperty(PREFIX_V4 + string + DIR);
        Path path = FolderSettings.translateFolderDir(string4, bl, bl2);
        if (path == null) {
            return null;
        }
        Path path2 = null;
        String string5 = properties.getProperty(PREFIX_V4 + string + COMMIT_DIR);
        if (StringUtils.isNotBlank(string5)) {
            path2 = FolderSettings.translateFolderDir(string5, bl, bl2);
        }
        SyncProfile syncProfile = PRE_777_BACKUP_TARGET_FIELD_LIST.equals(string3 = properties.getProperty(PREFIX_V4 + string + SYNC_PROFILE)) ? SyncProfile.BACKUP_TARGET : (PRE_2040_AUTOMATIC_SYNCHRONIZATION_FIELD_LIST.equals(string3) || PRE_2040_AUTOMATIC_SYNCHRONIZATION_10MIN_FIELD_LIST.equals(string3) ? SyncProfile.AUTOMATIC_SYNCHRONIZATION : (PRE_2074_BACKUP_SOURCE_5MIN_FIELD_LIST.equals(string3) || PRE_2074_BACKUP_SOURCE_HOUR_FIELD_LIST.equals(string3) ? SyncProfile.BACKUP_SOURCE : (StringUtils.isBlank(string3) ? SyncProfile.getSyncProfileByFieldList(string2) : SyncProfile.getSyncProfileByFieldList(string3))));
        String string6 = properties.getProperty(PREFIX_V4 + string + VERSIONS);
        if (string6 != null && string6.length() > 0) {
            n2 = Integer.valueOf(string6);
        } else {
            n2 = n;
            LOG.fine("Unable to find archive settings for " + string + ". Using default: " + n2);
        }
        String string7 = properties.getProperty(PREFIX_V4 + string + DOWNLOAD_SCRIPT);
        String string8 = properties.getProperty(PREFIX_V4 + string + SYNC_PATTERNS);
        boolean bl3 = string8 == null || "true".equalsIgnoreCase(string8);
        String string9 = properties.getProperty(PREFIX_V4 + string + EXCLUDES);
        String string10 = properties.getProperty(PREFIX_V4 + string + SYNC_WARN_SECONDS);
        int n3 = 0;
        if (StringUtils.isNotBlank(string10)) {
            try {
                n3 = Integer.parseInt(string10);
            }
            catch (Exception exception) {
                LOG.warning("Unable to parse sync warning settings: " + string10 + ". Using default.");
            }
        }
        FolderSettings folderSettings = new FolderSettings(PathUtils.removeInvalidFilenameChars(path), syncProfile, string7, n2, bl3, path2, n3);
        folderSettings.configEntryId = string;
        folderSettings.localBaseDirStr = string4;
        folderSettings.excludes = string9;
        return folderSettings;
    }

    public FolderSettings changeBaseDir(Path path) {
        FolderSettings folderSettings = new FolderSettings(path, this.syncProfile, this.downloadScript, this.versions, this.syncPatterns, this.commitDir, this.syncWarnSeconds);
        folderSettings.configEntryId = this.configEntryId;
        folderSettings.localBaseDirStr = EncryptedFileSystemUtils.isCryptoInstance(path) ? EncryptedFileSystemUtils.getPhysicalStorageLocation(path).toString() : path.toString();
        folderSettings.excludes = this.excludes;
        return folderSettings;
    }

    public void set(FolderInfo folderInfo, Properties properties) {
        String string = this.configEntryId;
        if (StringUtils.isBlank(string)) {
            string = new String(Util.encodeHex(Util.md5(folderInfo.id.getBytes())));
        }
        properties.setProperty(PREFIX_V4 + string + NAME, folderInfo.getName());
        properties.setProperty(PREFIX_V4 + string + ID, folderInfo.id);
        String string2 = this.localBaseDirStr;
        if (StringUtils.isBlank(string2)) {
            string2 = this.localBaseDir.toAbsolutePath().toString();
        }
        properties.setProperty(PREFIX_V4 + string + DIR, string2);
        String string3 = this.commitDir != null ? this.commitDir.toAbsolutePath().toString() : "";
        properties.setProperty(PREFIX_V4 + string + COMMIT_DIR, string3);
        properties.setProperty(PREFIX_V4 + string + SYNC_PROFILE, this.syncProfile.getFieldList());
        properties.setProperty(PREFIX_V4 + string + VERSIONS, String.valueOf(this.versions));
        String string4 = this.getDownloadScript() != null ? this.getDownloadScript() : "";
        properties.setProperty(PREFIX_V4 + string + DOWNLOAD_SCRIPT, string4);
        properties.setProperty(PREFIX_V4 + string + SYNC_PATTERNS, String.valueOf(this.syncPatterns));
        if (StringUtils.isNotBlank(this.excludes)) {
            properties.setProperty(PREFIX_V4 + string + EXCLUDES, this.excludes);
        } else {
            properties.remove(PREFIX_V4 + string + EXCLUDES);
        }
        if (this.syncWarnSeconds > 0) {
            properties.setProperty(PREFIX_V4 + string + SYNC_WARN_SECONDS, String.valueOf(this.syncWarnSeconds));
        } else {
            properties.remove(PREFIX_V4 + string + SYNC_WARN_SECONDS);
        }
    }

    private static Path translateFolderDir(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return null;
        }
        if (!string.contains("$")) {
            try {
                return Paths.get(URI.create(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Paths.get(string, new String[0]);
            }
        }
        String string2 = string;
        if (bl) {
            try {
                Map<String, UserDirectory> map = UserDirectories.getUserDirectories();
                LOG.fine("Local placeholder directories: " + map);
                for (UserDirectory userDirectory : map.values()) {
                    if (StringUtils.isBlank(userDirectory.getPlaceholder()) || !string2.contains(userDirectory.getPlaceholder()) || string2.contains(userDirectory.getPlaceholder() + ".")) continue;
                    string2 = string2.replace(userDirectory.getPlaceholder(), userDirectory.getDirectory().toAbsolutePath().toString());
                }
            }
            catch (Exception exception) {
                LOG.warning("Unable to translate directory path: " + string + ". " + exception);
            }
        }
        if (string2 != null) {
            string2 = string2.replace("$personal_files".trim(), Translation.get("general.personal_files"));
            string2 = string2.replace("$public_shared_files".trim(), Translation.get("general.public_shared_files"));
        }
        if (bl2) {
            if (string2.contains("$user.dir.") || string2.contains("$apps.dir.")) {
                LOG.warning("Local directory for placeholders not found: " + string2);
                return null;
            }
            if (string2.contains("$") && !string2.contains("$RECYCLE.BIN") && !string2.contains("$mail_attachments")) {
                LOG.fine("Directory path may still contain placeholders: " + string2);
            }
        }
        try {
            return Paths.get(URI.create(string2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Paths.get(string2, new String[0]);
        }
    }
}

