/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.ScanResult;
import de.dal33t.powerfolder.disk.problem.FileProblemHelper;
import de.dal33t.powerfolder.light.DiskItem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;

public class FolderScanner
extends PFComponent {
    private Folder currentScanningFolder;
    private ScanResult currentScanResult;
    private Map<String, FileInfo> remaining = Util.createConcurrentHashMap();
    private final List<DirectoryCrawler> directoryCrawlersPool = new CopyOnWriteArrayList<DirectoryCrawler>();
    private final List<DirectoryCrawler> activeDirectoryCrawlers = new CopyOnWriteArrayList<DirectoryCrawler>();
    private int maxCrawlers = 3;
    private List<Path> unableToScanFiles = new CopyOnWriteArrayList<Path>();
    private volatile boolean failure = false;
    private volatile boolean abort = false;
    private Semaphore threadOwnership = new Semaphore(1);

    FolderScanner(Controller controller) {
        super(controller);
        this.maxCrawlers = ConfigurationEntry.FOLDER_SCANNER_MAX_CRAWLERS.getValueInt(this.getController());
    }

    public void start() {
        for (int i = 0; i < this.maxCrawlers; ++i) {
            DirectoryCrawler directoryCrawler = new DirectoryCrawler();
            Thread thread = new Thread((Runnable)directoryCrawler, "FolderScanner.DirectoryCrawler #" + i);
            thread.setPriority(1);
            thread.start();
            this.directoryCrawlersPool.add(directoryCrawler);
        }
        this.currentScanResult = new ScanResult(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.abort = true;
        List<DirectoryCrawler> list = this.directoryCrawlersPool;
        synchronized (list) {
            for (DirectoryCrawler directoryCrawler : this.directoryCrawlersPool) {
                directoryCrawler.shutdown();
            }
            for (DirectoryCrawler directoryCrawler : this.activeDirectoryCrawlers) {
                directoryCrawler.shutdown();
            }
        }
    }

    public Folder getCurrentScanningFolder() {
        return this.currentScanningFolder;
    }

    public boolean abortScan() {
        if (this.currentScanningFolder != null) {
            this.abort = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized ScanResult scanFolder(Folder folder) {
        Reject.ifNull(folder, "folder cannot be null");
        if (!this.threadOwnership.tryAcquire()) {
            return new ScanResult(ScanResult.ResultState.BUSY);
        }
        try {
            Object object;
            void var6_11;
            Object object3;
            this.currentScanningFolder = folder;
            long l = System.currentTimeMillis();
            Path path = this.currentScanningFolder.getLocalBase();
            this.remaining.clear();
            for (FileInfo fileInfo : this.currentScanningFolder.getKnownFiles()) {
                this.remaining.put(fileInfo.getRelativeName(), fileInfo);
            }
            for (FileInfo object4 : this.currentScanningFolder.getKnownDirectories()) {
                this.remaining.put(object4.getRelativeName(), object4);
            }
            if (this.isFiner()) {
                this.logFiner("Scan of folder: " + folder.getName() + " start. Items in FileDB: " + this.remaining.size());
            }
            if (!this.scan(path) || this.failure) {
                this.reset();
                object3 = new ScanResult(ScanResult.ResultState.FAILURE);
                return object3;
            }
            if (this.abort) {
                this.reset();
                object3 = new ScanResult(ScanResult.ResultState.USER_ABORT);
                return object3;
            }
            this.tryFindMovementsInCurrentScan();
            this.tryFindProblemsInCurrentScan();
            int n = this.unableToScanFiles.size();
            boolean bl = false;
            while (var6_11 < n) {
                Path path2 = this.unableToScanFiles.get((int)var6_11);
                object = FileInfoFactory.buildFileName(this.currentScanningFolder.getLocalBase(), path2);
                this.remaining.remove(object);
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    String string = path2.toAbsolutePath().toString().replace(path2.getFileSystem().getSeparator(), "/");
                    this.logFiner("Checking unreadable folder for files that were not scanned: " + string);
                    Iterator<FileInfo> iterator = this.remaining.values().iterator();
                    while (iterator.hasNext()) {
                        FileInfo fileInfo = iterator.next();
                        String string2 = fileInfo.getLowerCaseFilenameOnly();
                        if (!string.endsWith(string2)) continue;
                        this.logWarning("Found file in unreadable folder. Unable to scan: " + fileInfo);
                        iterator.remove();
                        this.unableToScanFiles.add(fileInfo.getDiskFile(this.getController().getFolderRepository()));
                    }
                }
                ++var6_11;
            }
            if (this.isWarning()) {
                if (this.unableToScanFiles.isEmpty()) {
                    this.logFiner("Unable to scan " + this.unableToScanFiles.size() + " file(s)");
                } else {
                    this.logInfo("Unable to scan " + this.unableToScanFiles.size() + " file(s)");
                }
            }
            Iterator<FileInfo> iterator = this.remaining.values().iterator();
            while (iterator.hasNext()) {
                FileInfo fileInfo = iterator.next();
                if (!fileInfo.isDeleted()) continue;
                iterator.remove();
            }
            for (FileInfo fileInfo : this.remaining.values()) {
                try {
                    object = FileInfoFactory.deletedFile(fileInfo, this.getController().getMySelf().getInfo(), this.getController().getMySelf().getAccountInfo(), new Date());
                    this.currentScanningFolder.logFileOperation("DELETED", fileInfo, (FileInfo)object);
                    this.currentScanResult.deletedFiles.add((FileInfo)object);
                }
                catch (RuntimeException runtimeException) {
                    this.logWarning(fileInfo.toDetailString() + ": Problem while marking as deleted: " + runtimeException);
                }
            }
            ScanResult scanResult = this.currentScanResult;
            this.reset();
            if (this.isWarning()) {
                long l2 = System.currentTimeMillis() - l;
                if (this.currentScanResult.getResultState() == ScanResult.ResultState.SCANNED || l2 > 300000L) {
                    this.logFiner("Scan of folder " + folder.getName() + " done in " + l2 + "ms. Result: " + this.currentScanResult.getResultState());
                } else {
                    this.logWarning("Scan of folder " + folder.getName() + " done in " + l2 + "ms. Result: " + this.currentScanResult.getResultState());
                }
            }
            ScanResult scanResult2 = scanResult;
            return scanResult2;
        }
        catch (RuntimeException runtimeException) {
            this.logWarning("Folder scanner crashed at " + this.currentScanningFolder, runtimeException);
            this.failure = true;
            this.reset();
            ScanResult scanResult = new ScanResult(ScanResult.ResultState.FAILURE);
            return scanResult;
        }
        finally {
            this.currentScanningFolder = null;
            this.threadOwnership.release();
        }
    }

    private void reset() {
        this.waitForCrawlersToStop();
        this.abort = false;
        this.failure = false;
        this.unableToScanFiles.clear();
        this.currentScanResult = new ScanResult(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCrawlersToStop() {
        while (!this.activeDirectoryCrawlers.isEmpty()) {
            this.logFine("Waiting for " + this.activeDirectoryCrawlers.size() + " crawlers to stop");
            FolderScanner folderScanner = this;
            synchronized (folderScanner) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void tryFindProblemsInCurrentScan() {
        if (!PreferencesEntry.FILE_NAME_CHECK.getValueBoolean(this.getController()).booleanValue()) {
            return;
        }
        this.tryToFindProblemsInCurrentScan(this.currentScanResult.getChangedFiles());
        this.tryToFindProblemsInCurrentScan(this.currentScanResult.getRestoredFiles());
        this.tryToFindProblemsInCurrentScan(this.currentScanResult.getNewFiles());
    }

    private void tryToFindProblemsInCurrentScan(Collection<FileInfo> collection) {
        for (FileInfo fileInfo : collection) {
            this.currentScanResult.putFileProblems(fileInfo, FileProblemHelper.getProblems(this.getController(), fileInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean scan(Path path) {
        Object object;
        if (path == null) {
            this.failure = true;
            return false;
        }
        try {
            object = Files.newDirectoryStream(path);
            try {
                if (object == null) {
                    this.failure = true;
                    boolean bl = false;
                    return bl;
                }
                Iterator<Path> iterator = object.iterator();
                while (iterator.hasNext()) {
                    Path path2 = iterator.next();
                    if (this.failure) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.abort) {
                        break;
                    }
                    if (Files.exists(path2, new LinkOption[0]) && Files.isRegularFile(path2, new LinkOption[0])) {
                        if (!PathUtils.isScannable(path2, this.currentScanningFolder) || this.scanFile(path2, "")) continue;
                        this.failure = true;
                        boolean bl = false;
                        return bl;
                    }
                    if (Files.isDirectory(path2, new LinkOption[0])) {
                        if (!PathUtils.isScannable(path2, this.currentScanningFolder) || this.currentScanningFolder.isSystemSubDir(path2)) continue;
                        while (this.directoryCrawlersPool.isEmpty()) {
                            FolderScanner folderScanner = this;
                            synchronized (folderScanner) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                        }
                        List<DirectoryCrawler> list = this.directoryCrawlersPool;
                        synchronized (list) {
                            DirectoryCrawler directoryCrawler = this.directoryCrawlersPool.remove(0);
                            this.activeDirectoryCrawlers.add(directoryCrawler);
                            directoryCrawler.scan(path2);
                            continue;
                        }
                    }
                    boolean bl = this.currentScanningFolder.checkIfDeviceDisconnected();
                    this.logWarning(this.currentScanResult + ": Unable to scan file: " + path2.toAbsolutePath() + ". Folder device disconnected? " + bl);
                    if (bl) {
                        this.failure = true;
                        boolean bl2 = false;
                        return bl2;
                    }
                    this.unableToScanFiles.add(path2);
                }
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        while (!this.isReady()) {
            try {
                object = this;
                synchronized (object) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                this.logFiner(interruptedException);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReady() {
        boolean bl;
        List<DirectoryCrawler> list = this.directoryCrawlersPool;
        synchronized (list) {
            bl = this.activeDirectoryCrawlers.isEmpty() && this.directoryCrawlersPool.size() == this.maxCrawlers;
        }
        return bl;
    }

    private void tryFindMovementsInCurrentScan() {
        if (Feature.CORRECT_MOVEMENT_DETECTION.isDisabled()) {
            return;
        }
        for (FileInfo fileInfo : this.remaining.values()) {
            long l = fileInfo.getSize();
            long l2 = fileInfo.getModifiedDate().getTime();
            for (FileInfo fileInfo2 : this.currentScanResult.newFiles) {
                if (fileInfo2.getSize() != l || fileInfo2.getModifiedDate().getTime() != l2) continue;
                if (this.isFine()) {
                    this.logFine("Movement from: " + fileInfo + " to: " + fileInfo2);
                }
                this.currentScanResult.movedFiles.put(fileInfo, fileInfo2);
            }
        }
    }

    private boolean scanFile(Path path, String string) {
        Reject.ifNull(this.currentScanningFolder, "currentScanningFolder must not be null");
        this.currentScanResult.incrementTotalFilesCount();
        Object object = string.isEmpty() ? path.getFileName().toString() : string + "/" + path.getFileName().toString();
        return this.scanDiskItem(path, FileInfoFactory.decodeIllegalChars((String)object), false);
    }

    private boolean scanDirectory(Path path, String string) {
        Reject.ifNull(this.currentScanningFolder, "currentScanningFolder must not be null");
        if (this.isFiner()) {
            this.logFiner("Scanning subdir " + path + " / " + string);
        }
        this.currentScanResult.incrementTotalFilesCount();
        return this.scanDiskItem(path, FileInfoFactory.decodeIllegalChars(string), true);
    }

    private boolean scanDiskItem(Path path, String string, boolean bl) {
        Reject.ifNull(this.currentScanningFolder, "currentScanningFolder must not be null");
        FileInfo fileInfo = this.remaining.remove(string);
        if (fileInfo == null && FileInfo.IGNORE_CASE) {
            for (FileInfo fileInfo2 : this.remaining.values()) {
                if (!fileInfo2.getRelativeName().equalsIgnoreCase(string)) continue;
                if (this.isFiner()) {
                    this.logFiner("Found local diskfile with diffrent name-case in db. file: " + path.toAbsolutePath().toString() + ", dbFile: " + fileInfo2.toDetailString());
                }
                this.remaining.remove(fileInfo2.getRelativeName());
                fileInfo = fileInfo2;
            }
        }
        try {
            Object object;
            if (fileInfo != null) {
                if (fileInfo.isDeleted()) {
                    object = fileInfo.syncFromDiskIfRequired(this.currentScanningFolder, path, null);
                    if (object != null) {
                        this.currentScanningFolder.logFileOperation("RESTORED", fileInfo, (FileInfo)object);
                        ((FileInfo)object).setPreviousSize(fileInfo.getSize());
                        this.currentScanResult.restoredFiles.add((FileInfo)object);
                    }
                } else {
                    object = fileInfo.syncFromDiskIfRequired(this.currentScanningFolder, path, null);
                    if (object != null) {
                        if (this.currentScanningFolder.getDiskItemFilter().isRetained((DiskItem)object)) {
                            this.currentScanningFolder.logFileOperation("CHANGED", fileInfo, (FileInfo)object);
                        }
                        ((FileInfo)object).setPreviousSize(fileInfo.getSize());
                        this.currentScanResult.changedFiles.add((FileInfo)object);
                    }
                }
            } else {
                object = FileInfoFactory.newFile(this.currentScanningFolder, path, null, this.getController().getMySelf().getInfo(), this.getController().getMySelf().getAccountInfo(), null, bl, null);
                this.currentScanningFolder.logFileOperation("ADDED", null, (FileInfo)object);
                this.currentScanResult.newFiles.add((FileInfo)object);
                if (this.isFiner()) {
                    this.logFiner("New found: " + string + " @ " + path + ". Result: " + ((FileInfo)object).toDetailString() + ". Remaining know items: " + this.remaining.size());
                }
            }
        }
        catch (Exception exception) {
            this.logWarning("Unable to scan: " + path + ". " + exception);
            this.unableToScanFiles.add(path);
        }
        return true;
    }

    private static String getCurrentDirName(Folder folder, Path path) {
        Object object = path.getFileName().toString();
        Path path2 = path.getParent();
        Path path3 = folder.getLocalBase();
        while (!path3.equals(path2)) {
            if (path2 == null) {
                throw new NullPointerException("Local file seems not to be in a subdir of the local powerfolder copy");
            }
            object = path2.getFileName().toString() + "/" + (String)object;
            path2 = path2.getParent();
        }
        return object;
    }

    static /* synthetic */ void access$200(FolderScanner folderScanner, String string) {
        folderScanner.logFiner(string);
    }

    static /* synthetic */ List access$400(FolderScanner folderScanner) {
        return folderScanner.directoryCrawlersPool;
    }

    static /* synthetic */ List access$500(FolderScanner folderScanner) {
        return folderScanner.activeDirectoryCrawlers;
    }

    static /* synthetic */ void access$600(FolderScanner folderScanner, String string, Throwable throwable) {
        folderScanner.logWarning(string, throwable);
    }

    private class DirectoryCrawler
    implements Runnable {
        private Path root;
        private boolean shutdown = false;

        private DirectoryCrawler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scan(Path path) {
            if (this.root != null) {
                throw new IllegalStateException("cannot scan 2 directories at once");
            }
            DirectoryCrawler directoryCrawler = this;
            synchronized (directoryCrawler) {
                this.root = path;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            DirectoryCrawler directoryCrawler = this;
            synchronized (directoryCrawler) {
                this.notify();
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean scanDir(Path path) {
            if (FolderScanner.this.failure) {
                return false;
            }
            if (FolderScanner.this.currentScanningFolder == null) {
                FolderScanner.this.failure = true;
                FolderScanner.this.logWarning("Current scanning folder must not be null. Scanning path " + path);
                return false;
            }
            String string = FolderScanner.getCurrentDirName(FolderScanner.this.currentScanningFolder, path);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            FolderScanner.this.scanDirectory(path, string);
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                for (Path path2 : directoryStream) {
                    boolean bl;
                    if (FolderScanner.this.failure) {
                        bl = false;
                        return bl;
                    }
                    if (FolderScanner.this.abort) break;
                    if (Files.isRegularFile(path2, new LinkOption[0])) {
                        if (!PathUtils.isScannable(path2, FolderScanner.this.currentScanningFolder) || FolderScanner.this.scanFile(path2, string)) continue;
                        FolderScanner.this.failure = true;
                        bl = false;
                        return bl;
                    }
                    if (Files.isDirectory(path2, new LinkOption[0]) && !PathUtils.isReplicatedSubdir(path2)) {
                        if (!PathUtils.isScannable(path2, FolderScanner.this.currentScanningFolder) || this.scanDir(path2)) continue;
                        FolderScanner.this.failure = true;
                        bl = false;
                        return bl;
                    }
                    bl = FolderScanner.this.currentScanningFolder.checkIfDeviceDisconnected();
                    FolderScanner.this.logWarning(FolderScanner.this.currentScanningFolder + ": Unable to scan file: " + path2.toAbsolutePath() + ". Folder device disconnected? " + bl);
                    if (bl) {
                        FolderScanner.this.failure = true;
                        boolean bl2 = false;
                        return bl2;
                    }
                    FolderScanner.this.unableToScanFiles.add(path2);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = FolderScanner.this.currentScanningFolder.checkIfDeviceDisconnected();
                FolderScanner.this.logWarning("Unable to scan dir: " + path.toAbsolutePath() + ". Folder device disconnected? " + bl);
                if (bl) {
                    FolderScanner.this.failure = true;
                    return false;
                }
                FolderScanner.this.unableToScanFiles.add(path);
                return true;
            }
        }
    }
}

