/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.clientserver;

import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Notification
implements Serializable {
    private static final long serialVersionUID = 100L;
    public static final String PROPERTYNAME_OID = "oid";
    public static final String PROPERTYNAME_CREATION_DATE = "creationDate";
    public static final String PROPERTYNAME_EMAIL_SENT_DATE = "emailSentDate";
    public static final String PROPERTYNAME_CLIENT_RECEIVED_DATE = "clientReceivedDate";
    public static final String PROPERTYNAME_ACCOUNT_OID = "accountOID";
    public static final String PROPERTYNAME_TYPE_ID = "typeId";
    public static final String PROPERTYNAME_SUBJECT = "subject";
    public static final String PROPERTYNAME_SUBJECT_TRANSLATION_ID = "subjectTranslationID";
    public static final String PROPERTYNAME_TEXT = "text";
    public static final String PROPERTYNAME_TEXT_TRANSLATION_ID = "textTranslationID";
    @Id
    private String oid;
    private Date creationDate;
    private Date emailSentDate;
    private Date clientReceivedDate;
    @Index(name="IDX_NOT_ACCOUNT_OID")
    private String accountOID;
    @Index(name="IDX_TYPE_ID")
    private String typeId;
    private String subject;
    private String subjectTranslationID;
    private String text;
    private String textTranslationID;

    Notification() {
    }

    public Notification(String string) {
        Reject.ifBlank(string, "typeId id is blank");
        this.typeId = string;
        this.creationDate = new Date();
        this.oid = IdGenerator.makeId();
    }

    public String getOID() {
        return this.oid;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public boolean isEmailSent() {
        return this.emailSentDate != null;
    }

    public Date getEmailSentDate() {
        return this.emailSentDate;
    }

    public void setEmailSentDate(Date date) {
        this.emailSentDate = date;
    }

    public boolean isClientReceived() {
        return this.clientReceivedDate != null;
    }

    public Date getClientReceivedDate() {
        return this.clientReceivedDate;
    }

    public void setClientReceivedDate(Date date) {
        this.clientReceivedDate = date;
    }

    public String getAccountOID() {
        return this.accountOID;
    }

    public void setAccountOID(String string) {
        this.accountOID = string;
    }

    public String getSubjectI15D() {
        String string = null;
        if (StringUtils.isNotBlank(this.subjectTranslationID)) {
            string = Translation.get(this.subjectTranslationID);
        }
        if (StringUtils.isBlank(string) || string.startsWith(" -")) {
            string = this.subject;
        }
        return string;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public String getSubjectTranslationID() {
        return this.subjectTranslationID;
    }

    public void setSubjectTranslationID(String string) {
        this.subjectTranslationID = string;
    }

    public String getTextI15D() {
        String string = null;
        if (StringUtils.isNotBlank(this.textTranslationID)) {
            string = Translation.get(this.textTranslationID);
        }
        if (StringUtils.isBlank(string) || string.startsWith(" -")) {
            string = this.text;
        }
        return string;
    }

    public String getTextTranslationID() {
        return this.textTranslationID;
    }

    public void setTextTranslationID(String string) {
        this.textTranslationID = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.oid == null ? 0 : this.oid.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Notification notification = (Notification)object;
        return !(this.oid == null ? notification.oid != null : !this.oid.equals(notification.oid));
    }
}

