/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.activity.domain;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.protocol.FileActivityProto;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.annotations.Index;
import org.jetbrains.annotations.NotNull;

@Entity
public class FileActivity
implements D2DObject {
    @Id
    @Column(length=32)
    private final String id;
    @ManyToOne
    @JoinColumn(name="folder_id")
    private final FolderInfo folderInfo;
    @Index(name="IDX_REL_PATH")
    private final String relativePath;
    private final Date modificationDate;

    private FileActivity() {
        this.id = null;
        this.folderInfo = null;
        this.relativePath = null;
        this.modificationDate = null;
    }

    FileActivity(@NotNull FolderInfo folderInfo, @NotNull String string, @NotNull Date date) {
        this.id = UUID.randomUUID().toString().replaceAll("-", "");
        this.folderInfo = folderInfo;
        this.relativePath = string;
        this.modificationDate = date;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public FolderInfo getFolderInfo() {
        return this.folderInfo;
    }

    @NotNull
    public String getRelativePath() {
        return this.relativePath;
    }

    @NotNull
    public Date getModificationDate() {
        return this.modificationDate;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
    }

    @Override
    public AbstractMessage toD2D() {
        FileActivityProto.FileActivity.Builder builder = FileActivityProto.FileActivity.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setId(this.getId());
        builder.setFileId(this.getFolderInfo().getId() + "/" + this.getRelativePath());
        builder.setModificationDate(this.getModificationDate().getTime());
        return builder.build();
    }
}

