/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.PowerFolder;
import de.dal33t.powerfolder.pro.D.B;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.tanukisoftware.wrapper.WrapperListener;
import org.tanukisoftware.wrapper.WrapperManager;

public class PowerFolderService
extends Loggable
implements WrapperListener {
    private static Controller controller = null;

    protected PowerFolderService() {
    }

    @Override
    public Integer start(final String[] stringArray) {
        WrapperManager.signalStarting(20000);
        System.setProperty("user.home", B.N().toAbsolutePath().toString());
        Feature.CONFIGURATION_ALL_USERS.enable();
        Thread thread = new Thread(){

            @Override
            public void run() {
                Thread.setDefaultUncaughtExceptionHandler((thread, throwable) -> {
                    throwable.printStackTrace();
                    PowerFolderService.this.logSevere("Exception in " + thread + ": " + throwable.toString(), throwable);
                });
                WrapperManager.log(2, "Starting PowerFolder as Service");
                if (controller != null) {
                    return;
                }
                CommandLine commandLine = PowerFolder.parseCommandLine(stringArray);
                PowerFolderService.controller = Controller.createController();
                controller.startConfig(commandLine);
                boolean bl = false;
                while (true) {
                    if (controller.isStarted() || controller.isShuttingDown()) {
                        try {
                            Thread.sleep(400L);
                        }
                        catch (InterruptedException interruptedException) {
                            PowerFolderService.this.logWarning(interruptedException);
                            return;
                        }
                    }
                    bl = controller.isRestartRequested();
                    if (bl) {
                        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
                        for (Thread thread2 : map.keySet()) {
                            if (!thread2.getName().startsWith("PoolThread") && !thread2.getName().startsWith("Reconnector") && !thread2.getName().startsWith("ConHandler")) continue;
                            thread2.interrupt();
                        }
                        WrapperManager.log(2, "Restarting controller");
                        System.out.println("------------ PowerFolder 23.2.102 restarting ------------");
                        PowerFolderService.controller = null;
                        System.gc();
                        commandLine = PowerFolder.parseCommandLine(stringArray);
                        PowerFolderService.controller = Controller.createController();
                        controller.startConfig(commandLine);
                    }
                    if (!bl) break;
                }
            }
        };
        thread.start();
        return null;
    }

    @Override
    public int stop(int n) {
        WrapperManager.log(2, "Service is shutting down.");
        if (controller != null) {
            try {
                controller.shutdown();
                while (controller.isShuttingDown()) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public void controlEvent(int n) {
        if (!(WrapperManager.isControlledByNativeWrapper() || n != 200 && n != 201 && n != 203)) {
            WrapperManager.stop(0);
        }
    }

    public static void main(String[] stringArray) {
        WrapperManager.start(new PowerFolderService(), stringArray);
    }
}

