/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import com.google.common.collect.Maps;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.NetworkingMode;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum ConfigurationEntry {
    DISABLE_GUI("disableui", false),
    USER_INTERFACE_LOCKED("uilock.locked", false),
    KILL_RUNNING_INSTANCE("kill.running.instance", false),
    SYNC_AND_EXIT("sync.exit", false),
    AUTO_UPDATE("auto.update", false),
    ENABLE_UPDATE("enable.update", true){

        @Override
        public Boolean getValueBoolean(Controller controller) {
            if (OSUtil.isWindowsSystem() && WinUtils.isMSI(controller)) {
                return Boolean.FALSE;
            }
            return super.getValueBoolean(controller);
        }

        @Override
        public String getDefaultValue() {
            if (OSUtil.isWindowsSystem() && WinUtils.isMSI(null)) {
                return Boolean.FALSE.toString();
            }
            return super.getDefaultValue();
        }
    }
    ,
    SECURITY_PERMISSIONS_STRICT("security.permissions.strict", false){

        @Override
        public Boolean getValueBoolean(Properties properties) {
            return Boolean.FALSE;
        }
    }
    ,
    SECURITY_PERMISSIONS_SHOW_FOLDER_ADMIN("security.permissions.show_folder_admin", true),
    FOLDER_OWNERSHIP_CHANGEABLE("folder.change_owner.allowed", true),
    SECURITY_SSL_TRUST_ANY("security.ssl.trust_any", false),
    NICK("nick"){

        @Override
        public String getDefaultValue() {
            String string = null;
            if (StringUtils.isNotBlank(System.getenv("COMPUTERNAME"))) {
                string = System.getenv("COMPUTERNAME").toLowerCase();
            }
            if (string == null) {
                try {
                    InetAddress inetAddress = InetAddress.getLocalHost();
                    string = inetAddress.getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (string == null) {
                string = System.getProperty("user.name");
            }
            return string;
        }
    }
    ,
    NODE_ID("nodeid"),
    NETWORK_ID("networkid", "X", true),
    PROVIDER_URL("provider.url.main", "https://www.powerfolder.com"),
    PROVIDER_ABOUT_URL("provider.url.about", "https://www.powerfolder.com/about-us-2/"),
    PROVIDER_QUICKSTART_URL("provider.url.quickstart", "https://powerfolder.atlassian.net/wiki/spaces/PF/pages/301965/Getting+started"),
    PROVIDER_SUPPORT_URL("provider.url.support", "https://wiki.powerfolder.com"),
    PROVIDER_ACCESSIBILITY_URL("provider.url.accessibility", "https://powerfolder.atlassian.net/wiki/spaces/PF/pages/2159706129/Accessibility+Information"),
    PROVIDER_ACCESSIBILITY_REPORT_PROBLEM_URL("provider.accessibility.report.problem.url", ""),
    PROVIDER_COOKIES_POLICY_URL("provider.url.cookies.policy", "https://www.powerfolder.com/de/7084-2/"),
    PROVIDER_SUPPORT_URL_SHOW_IN_MENU("provider.url.support.show_in_menu", false),
    PROVIDER_SUPPORT_FILE_TICKET_URL("provider.url.ticket", "https://powerfolder.atlassian.net/servicedesk"),
    PROVIDER_BUY_URL("provider.url.buy", "https://www.powerfolder.com/pricing"),
    PROVIDER_CONTACT_URL("provider.url.contact", "https://www.powerfolder.com/contact"),
    PROVIDER_WIKI_URL("provider.url.wiki", "https://wiki.powerfolder.com"),
    DIST_BINARY_NAME("dist.binaryname", "PowerFolder"),
    DIST_NAME("dist.name", "PowerFolder"),
    DIST_DESCRIPTION("dist.description", "Sync your world"),
    DIST_FOLDERS_BASE_NAME("dist.folderbasename", Constants.FOLDERS_BASE_DIR_SUBDIR_NAME),
    DIST_EMAIL("dist.email", ""),
    DIST_COMPANY("dist.company", ""),
    DIST_URL("dist.url", ""),
    DIST_CLASSNAME("dist.classname"),
    SERVER_CONNECT("server.connect.enabled", true, true),
    SERVER_NAME("server.name", "PowerFolder Cloud"),
    SERVER_WEB_URL("server.url", "https://my.powerfolder.com"),
    SERVER_NODEID("server.nodeid"),
    SERVER_HOST("server.host", "os007.powerfolder.com"),
    SERVER_HTTP_TUNNEL_RPC_URL("provider.url.httptunnel", "http://my.powerfolder.com/rpc"),
    SERVER_DISCONNECT_SYNC_ANYWAYS("server.disconnect.sync_anyways", false){

        @Override
        public String getValue(Controller controller) {
            return Boolean.toString(Feature.P2P_REQUIRES_LOGIN_AT_SERVER.isDisabled());
        }
    }
    ,
    SERVER_CONFIG_UPDATE("server.config.update", true),
    SERVER_LOAD_NODES("server.load.nodes", true),
    SERVER_CONNECTION_URLS("server.connection.urls"),
    SERVER_IDP_DISCO_FEED_URL("server.idp.disco_feed.url", null, true),
    SERVER_IDP_LAST_CONNECTED("server.idp.last_connected"),
    SERVER_IDP_LAST_CONNECTED_ECP("server.idp.last_connected.ecp"),
    SERVER_IDP_EXTERNAL_NAMES("server.idp.external_names", "", true),
    SERVER_LOGIN_SKIP_RETRY("server.skip.auto.login", 1000),
    SERVER_FEDERATION_ENABLED("server.federation.enabled", false),
    SERVER_FEDERATED_SHARING("server.federation.sharing_enabled", true),
    SERVER_FEDERATED_LOGIN("server.federation.login_enabled", true),
    SERVER_FEDERATED_MERGE("server.federation.auto_merge_accounts", false),
    SERVER_FEDERATED_MERGE_AT_NIGHT("server.federation.auto_merge_accounts.atnight", true),
    SERVER_FEDERATED_MERGE_ALWAYS("server.federation.auto_merge_accounts.always", false),
    WEB_LOGIN_ALLOWED("web.login.allowed", true),
    WEB_DAV_ENABLED("web.dav.enabled", true),
    MEMBERS_ENABLED("members.enabled", true),
    SETTINGS_ENABLED("settings.enabled", true),
    FILES_ENABLED("files.enabled", true),
    ARCHIVE_DIRECTORY_NAME("files.archive.dir.name", "archive"),
    PROBLEMS_ENABLED("problems.enabled", true),
    MY_ACCOUNT_ENABLED("web.my_account.enabled", true),
    CONFIG_PROMPT_SERVER_IF_PF_COM("config.promptifpf", false),
    CONFIG_URL("config.url"),
    CONFIG_OVERWRITE_VALUES("config.overwrite", false),
    CONFIG_DROP_FOLDER_SETTINGS("config.drop.folders.settings", false),
    CONFIG_ASSIGN_IP_LIST("config.assign.iplist"),
    CONFIG_LDAP_GROUP("config.ldap.group"),
    CONFIG_ORGANIZATION("config.organization"),
    INSTALLER_FILENAME("installer.file"),
    UPDATE_VERSION_URL("update.version.url"),
    UPDATE_DOWNLOADLINK_INFO_URL("update.download_info.url"),
    UPDATE_WINDOWS_EXE_URL("update.windows_exe.url"),
    UPDATE_SILENT_ALLOWED("update.silent.allowed", true),
    UPDATE_FORCE("update.force", false),
    SERVER_REGISTER_ENABLED("server.register.enabled", false),
    SERVER_INVITE_ENABLED("server.invite.enabled", true),
    SERVER_SYNC_MANDATORY("server.sync.mandatory", true),
    FOLDER_AGREE_INVITATION_ENABLED("folder.agree.invitation.enabled", true),
    FOLDER_SHARE_SUBFOLDER_ENABLED("folder.share.subfolder.enabled", false),
    SERVER_INVITE_NEW_USERS_ENABLED("server.invite.new_users.enabled", true),
    SERVER_RECOVER_PASSWORD_ENABLED("server.recover.password.enabled", true),
    SERVER_USERNAME_IS_EMAIL("server.username.isemail", "both"),
    SERVER_INVITE_VALIDATE_EMAIL_ENABLED("server.invite.validate_email.enabled", false){

        @Override
        public Boolean getValueBoolean(Controller controller) {
            boolean bl;
            if (SERVER_USERNAME_IS_EMAIL.hasNonBlankValue(controller) && (bl = "true".equalsIgnoreCase(SERVER_USERNAME_IS_EMAIL.getValue(controller)))) {
                return true;
            }
            return super.getValueBoolean(controller);
        }
    }
    ,
    SERVER_CONNECT_USERNAME("server.connect.username"),
    SERVER_CONNECT_PASSWORD("server.connect.passwordobf"),
    SERVER_CONNECT_TOKEN("server.connect.token"),
    SERVER_CONNECT_TOKEN_WEBDAV("server.connect.token.webdav"),
    SERVER_CONNECT_PASSWORD_CLEAR("server.connect.password"),
    SERVER_CONNECT_NO_PASSWORD_ALLOWED("server.connect.nopassword.allowed", false),
    SERVER_CONNECT_REMEMBER_PASSWORD_ALLOWED("server.connect.rememberpassword.allowed", true),
    SERVER_CONNECT_CHANGE_LOGIN_ALLOWED("server.connect.changelogin.allowed", true),
    SERVER_CONNECT_FROM_LAN_TO_INTERNET("server.connect.lan2internet", true),
    KERBEROS_SSO_ENABLED("kerberos.sso.enabled", false),
    KERBEROS_SSO_REALM("kerberos.sso.realm", "WORKGROUP"),
    KERBEROS_SSO_KDC("kerberos.sso.kdc"),
    KERBEROS_SSO_SERVICE_NAME("kerberos.sso.service_name", "domain/hostname"),
    NETWORKING_MODE("networkingmode", NetworkingMode.PRIVATEMODE.name()),
    NET_BIND_ADDRESS("net.bindaddress"),
    NET_PORT("net.port", null, true){

        @Override
        public String getValue(Controller controller) {
            String string = super.getValue(controller);
            if (string == null) {
                string = controller.getConfig().getProperty("port");
            }
            return string;
        }

        @Override
        public void removeValue(Controller controller) {
            super.removeValue(controller);
            controller.getConfig().remove("port");
        }

        @Override
        public void setValue(Controller controller, String string) {
            super.setValue(controller, string);
            controller.getConfig().remove("port");
        }
    }
    ,
    NET_PORT_D2D("net.port.d2d", 0, true){

        @Override
        public String getValue(Controller controller) {
            String string;
            String string2 = super.getValue(controller);
            if ((string2 == null || string2.equals(this.defaultValue)) && (string = controller.getConfig().getProperty("d2d.port")) != null) {
                string2 = string;
            }
            return string2;
        }

        @Override
        public void removeValue(Controller controller) {
            super.removeValue(controller);
            controller.getConfig().remove("d2d.port");
        }

        @Override
        public void setValue(Controller controller, String string) {
            super.setValue(controller, string);
            controller.getConfig().remove("d2d.port");
        }
    }
    ,
    NET_PORT_RCON("net.port.rcon", 1338){

        @Override
        public String getValue(Controller controller) {
            String string = super.getValue(controller);
            if (string == null) {
                string = controller.getConfig().getProperty("net.rcon.port");
            }
            return string;
        }

        @Override
        public void removeValue(Controller controller) {
            super.removeValue(controller);
            controller.getConfig().remove("net.rcon.port");
        }

        @Override
        public void setValue(Controller controller, String string) {
            super.setValue(controller, string);
            controller.getConfig().remove("net.rcon.port");
        }
    }
    ,
    NET_VERSION_MINIMUM("net.version.minimum"),
    NET_USE_RELAY_TUNNEL_ON_LAN("net.relaytunnel.lan.enabled", false),
    NET_RCON_MANAGER("net.rcon", true),
    NET_BROADCAST("net.broadcast", true),
    NET_BROADCAST_INTERVAL_SECONDS("net.broadcast.interval.seconds", 60),
    NET_BIND_RANDOM_PORT("random-port", true),
    NET_SOCKET_INTERNET_BUFFER_SIZE("net.socket.internet.buffer.size", 0x100000),
    NET_SOCKET_LAN_BUFFER_SIZE("net.socket.lan.buffer.size", 0x400000),
    NET_SOCKET_INTERNET_BUFFER_LIMIT("net.socket.internet.buffer.limit", 0x800000),
    NET_SOCKET_LAN_BUFFER_LIMIT("net.socket.lan.buffer.limit", 0x2000000),
    TRANSFER_LIMIT_AUTODETECT("transfer.limit.autodetect", false),
    UPLOAD_LIMIT_WAN("uploadlimit", 0),
    DOWNLOAD_LIMIT_WAN("downloadlimit", 0),
    UPLOAD_LIMIT_LAN("lanuploadlimit", 0),
    DOWNLOAD_LIMIT_LAN("landownloadlimit", 0),
    TRANSFERS_MAX_FILE_CHUNK_SIZE("transfers.max.file.chunk.size", 131072),
    TRANSFERS_MAX_REQUESTS_QUEUED("transfers.max.request.queued", 30),
    TRANSFER_BUFFER_THRESHOLD("transfer.buffer.threshold", 0x200000),
    HOSTNAME("hostname", null, true){

        @Override
        public String getValue(Controller controller) {
            String string = super.getValue(controller);
            if (string == null) {
                string = controller.getConfig().getProperty("mydyndns");
            }
            return string;
        }

        @Override
        public void removeValue(Controller controller) {
            super.removeValue(controller);
            controller.getConfig().remove("mydyndns");
        }

        @Override
        public void setValue(Controller controller, String string) {
            super.setValue(controller, string);
            controller.getConfig().remove("mydyndns");
        }
    }
    ,
    USE_ZIP_ON_LAN("use_zip_on_lan", false),
    USE_SWARMING_ON_LAN("swarming.lan.enabled", true),
    USE_DELTA_ON_INTERNET("deltasync.internet.enabled", true),
    USE_DELTA_ON_LAN("deltasync.lan.enabled", true),
    USE_SWARMING_ON_INTERNET("swarming.internet.enabled", true),
    FOLDER_BASEDIR("foldersbase"){

        @Override
        public String getDefaultValue() {
            String string;
            WinUtils winUtils;
            String string2 = System.getProperty("user.home");
            if (OSUtil.isWindowsSystem() && OSUtil.isWindowsXPSystem() && (winUtils = WinUtils.getInstance()) != null && StringUtils.isNotBlank(string = winUtils.getSystemFolderPath(5, false))) {
                string2 = string;
            }
            return Paths.get(string2, new String[0]).resolve(Constants.FOLDERS_BASE_DIR_SUBDIR_NAME).toString();
        }
    }
    ,
    FOLDER_BASEDIR_FALLBACK_TO_DEFAULT("folderbase.fallback.enabled", false),
    FOLDER_BASEDIR_DELETED_DIR("folderbase.deleteddir", "BACKUP_REMOVE"),
    PLUGINS("plugins"),
    PLUGINS_DISABLED("plugins.disabled"),
    DYNDNS_AUTO_UPDATE("dyndns.autoUpdate", false){

        @Override
        public String getValue(Controller controller) {
            String string = super.getValue(controller);
            if (string == null) {
                string = controller.getConfig().getProperty("onStartUpdate");
            }
            return string != null ? string : Boolean.FALSE.toString();
        }
    }
    ,
    DYNDNS_USERNAME("dyndnsUserName"),
    DYNDNS_PASSWORD("dyndnsPassword"),
    DYNDNS_LAST_UPDATED_IP("lastUpdatedIP"),
    LANLIST("lanlist", ""),
    USE_PF_ICON("use.pf.icon", true),
    CONFLICT_DETECTION("conflict.detection", true),
    LOOK_FOR_FOLDER_CANDIDATES("look.for.folder.candidates", true, true){

        @Override
        public String getValue(Controller controller) {
            if (controller.getMySelf().isServer()) {
                return Boolean.FALSE.toString();
            }
            return super.getValue(controller);
        }
    }
    ,
    LOOK_FOR_FOLDERS_TO_BE_REMOVED("look.for.folder.removes", false),
    VERBOSE("verbose", false),
    PROFILING("profiling", false),
    LOG_LEVEL_FILE("log.file.level", Level.FINE.getName(), true),
    LOG_FILE_ROTATE("log.file.rotate", true, true),
    LOG_FILE_DELETE_DAYS("log.file.keep.days", 31, true),
    LOG_LEVEL_CONSOLE("log.console.level", Level.INFO.getName(), true),
    LOG_LEVEL_SYSLOG("log.syslog.level", Level.INFO.getName(), true),
    LOG_SYSLOG_CONNECTION("log.syslog.connection", "UDP", true),
    LOG_SYSLOG_HOST("log.syslog.host", null, true),
    LOG_SYSLOG_PORT("log.syslog.port", 514, true),
    LOG_ACTIVE_THREADS("log.active_threads", false, true),
    DEBUG_REPORTS("debug.reports", false),
    AUTO_CONNECT("auto.connect", true),
    CONNECT_WAIT("connect.wait.seconds", 120),
    RELAYED_CONNECTIONS_ENABLED("connections.relayed", false),
    UDT_CONNECTIONS_ENABLED("connections.udt", true),
    NODEMANAGER_ENABLED("nodemanager.enabled", true),
    TRANSFER_MANAGER_ENABLED("transfermanager.enabled", true),
    FOLDER_REPOSITORY_ENABLED("folderepository.enabled", true),
    FOLDER_STATS_CALC_TIME("filedb.stats.seconds", 60),
    FOLDER_DB_PERSIST_TIME("filedb.persist.seconds", 60),
    FOLDER_WATCHER_ENABLED("folder.watcher.enabled", true, true),
    FOLDER_WATCHER_DELAY("folder.watcher.delay.seconds", 1),
    FILE_REQUESTOR_INTERVAL("file.requestor.interval.seconds", 300),
    FOLDER_COPY_AFTER_TRANSFER("folder.copy_after_transfer.enabled", false, true),
    DB_MAINTENANCE_SECONDS("filedb.maintenance.seconds", 86400),
    MAX_FILEINFO_DELETED_AGE_SECONDS("filedb.deleted.maxage", 93312000),
    HTTP_PROXY_HOST("http.proxy.host", null, true){

        @Override
        public String getDefaultValue() {
            String string = System.getProperty("https.proxyHost");
            if (StringUtils.isBlank(string)) {
                string = System.getProperty("http.proxyHost");
            }
            return string;
        }
    }
    ,
    HTTP_PROXY_PORT("http.proxy.port", 80, true){

        @Override
        public String getDefaultValue() {
            String string = System.getProperty("https.proxyPort");
            if (StringUtils.isBlank(string)) {
                string = System.getProperty("http.proxyPort");
            }
            if (StringUtils.isBlank(string)) {
                string = "80";
            }
            return string;
        }
    }
    ,
    HTTP_PROXY_USERNAME("http.proxy.username", null, true),
    HTTP_PROXY_PASSWORD("http.proxy.password", null, true),
    HTTP_PROXY_NON_PROXY_HOSTS("http.proxy.nonproxyhosts"){

        @Override
        public String getDefaultValue() {
            String string = System.getProperty("https.nonProxyHosts");
            if (StringUtils.isBlank(string)) {
                string = System.getProperty("http.nonProxyHosts");
            }
            return string;
        }
    }
    ,
    UPLOAD_AUTO_CLEANUP_FREQUENCY("uploads.auto.cleanup.frequency", 2),
    DOWNLOAD_AUTO_CLEANUP_FREQUENCY("downloads.auto.cleanup.frequency", 2),
    FOLDER_SYNC_USE("sync.folder.use", false),
    FOLDER_SYNC_WARN_SECONDS("sync.folder.warn.seconds", 864000){

        @Override
        public String getValue(Controller controller) {
            String string = super.getValue(controller);
            if (string == null) {
                try {
                    string = String.valueOf(86400L * (long)Integer.valueOf(controller.getConfig().getProperty("sync.folder.warn")).intValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string;
        }

        @Override
        public void removeValue(Controller controller) {
            super.removeValue(controller);
            controller.getConfig().remove("sync.folder.warn");
        }

        @Override
        public void setValue(Controller controller, String string) {
            super.setValue(controller, string);
            controller.getConfig().remove("sync.folder.warn");
        }
    }
    ,
    FOLDER_CREATE_AVOID_DUPES("create.folder.avoid.dupes", false),
    FOLDER_CREATE_USE_EXISTING("create.folder.use.existing", true),
    FOLDER_CREATE_ON_STARTUP("create.folder.on.startup", false),
    FOLDER_CREATE_ALLOW_NETWORK("create.folder.allow.network", true),
    FOLDER_CREATE_IN_BASEDIR_ONLY("create.folder.basedir.only", false){

        @Override
        public Boolean getValueBoolean(Controller controller) {
            String string = this.getValue(controller);
            if (string == null) {
                if (!PreferencesEntry.EXPERT_MODE.getValueBoolean(controller).booleanValue()) {
                    return Boolean.TRUE;
                }
                string = this.getDefaultValue();
            }
            try {
                return string.trim().equalsIgnoreCase("true");
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.WARNING, "Unable to parse configuration entry 'create.folder.basedir.only' into a boolean. Value: " + string, numberFormatException);
                return "true".equalsIgnoreCase(this.getDefaultValue());
            }
        }
    }
    ,
    FOLDER_REMOVE_IN_BASEDIR_WHEN_DISAPPEARED("remove.folder.basedir.when_disappeared", true),
    FOLDER_MAP_USER_DIRECTORIES("create.folder.map.user.directories", true),
    DEFAULT_ARCHIVE_VERSIONS("default.archive.versions", 25){

        @Override
        public Integer getValueInt(Controller controller) {
            String string = super.getValue(controller);
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (Objects.equals(string, "unlimited")) {
                    return -1;
                }
                return 25;
            }
        }
    }
    ,
    DEFAULT_ARCHIVE_CLEANUP_DAYS("archive.cleanup.days", 0){

        @Override
        public Integer getValueInt(Controller controller) {
            String string = super.getValue(controller);
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                String[] stringArray = string.split("\\s+");
                if (stringArray.length != 2) {
                    return 0;
                }
                try {
                    String string2;
                    int n = Integer.parseInt(stringArray[0]);
                    switch (string2 = stringArray[1].toLowerCase()) {
                        case "day": 
                        case "days": {
                            return n;
                        }
                        case "week": 
                        case "weeks": {
                            return 7 * n;
                        }
                        case "month": 
                        case "months": {
                            return 30 * n;
                        }
                        case "year": 
                        case "years": {
                            return 365 * n;
                        }
                    }
                    return 0;
                }
                catch (NumberFormatException numberFormatException2) {
                    return 0;
                }
            }
        }
    }
    ,
    DEFAULT_TRANSFER_MODE("default.transfer.mode", SyncProfile.AUTOMATIC_SYNCHRONIZATION.getFieldList()),
    UNC_TRANSFER_MODE("unc.transfer.mode"),
    FOLDER_SCANNER_MAX_CRAWLERS("sync.folder.max_crawlers", 3),
    FOLDER_FILE_REQUESTOR_MAX_WORKERS("sync.folder.max_filerequestors", 300),
    FOLDER_FOLDERS_PER_FILE_REQUESTOR("sync.folder.folders_per_filerequestors", 200),
    AUTO_SETUP_ACCOUNT_FOLDERS("auto.setup.account.folders", true),
    AUTO_SETUP_FOLDERS_IGNORED("auto.setup.folders.ignored", ""),
    PAUSE_RESUME_SECONDS("pause.resume.seconds", 3600),
    SHOW_CREATE_FOLDER("show.create.folder", true),
    SHOW_DESKTOP_SYNC_OPTION("show.desktop.sync", false),
    SHOW_WALLPAPER_OPTION("show.wallpaper", false),
    COPY_GETTING_STARTED_GUIDE("copy.getting_started.guide", false),
    RECOVER_0BYTE_FILES("recover.zero_byte.files", true),
    ENCRYPTED_STORAGE("encrypted_storage.enabled", false),
    ENCRYPTED_STORAGE_PASSPHRASE("encrypted_storage.passphrase", null),
    ENCRYPTED_STORAGE_DEFAULT("encrypted_storage.default", true),
    WEB_CLIENT_PORT("web.client.port", 0),
    WEB_INLINE_VIEW_EXTENSIONS("web.inline_view.extensions"),
    EVENT_API_URL_UPLOADED_FILE_CLIENT("event.api.file.uploaded.client"),
    EVENT_API_URL_DOWNLOADED_FILE_CLIENT("event.api.file.downloaded.client"),
    EVENT_API_URL_UPLOADED_FILE_WEB("event.api.file.uploaded.web"),
    EVENT_API_URL_DOWNLOADED_FILE_WEB("event.api.file.downloaded.web"),
    EVENT_API_URL_DOWNLOADED_FILE_LINK("event.api.file.downloaded.link"),
    EVENT_API_URL_DELETED_FILE("event.api.file.deleted"),
    WDNAS_CLIENT("wdnas.client", false),
    LOCKING_CHANGES_FILE_PERMISSIONS("locking.changes.file_permissions", false),
    SCU_ENABLED("scu.enabled", false);

    private static final Logger LOG;
    private final String configKey;
    protected final String defaultValue;
    protected final boolean restartRequired;
    private static final Map<String, ConfigurationEntry> LOOKUP;

    private ConfigurationEntry(String string2) {
        this(string2, (String)null);
    }

    private ConfigurationEntry(String string2, String string3) {
        this(string2, string3, false);
    }

    private ConfigurationEntry(String string2, String string3, boolean bl) {
        Reject.ifBlank(string2, "Config key is blank");
        Reject.ifTrue(string2.startsWith("f."), "Config entries must not start with 'f.'");
        this.configKey = string2;
        this.restartRequired = bl;
        this.defaultValue = string3 != null ? string3 : this.getDefaultValue();
    }

    private ConfigurationEntry(String string2, boolean bl) {
        this(string2, String.valueOf(bl));
    }

    private ConfigurationEntry(String string2, boolean bl, boolean bl2) {
        this(string2, String.valueOf(bl), bl2);
    }

    private ConfigurationEntry(String string2, int n2) {
        this(string2, String.valueOf(n2));
    }

    private ConfigurationEntry(String string2, int n2, boolean bl) {
        this(string2, String.valueOf(n2), bl);
    }

    public boolean hasValue(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        return this.hasValue(controller.getConfig());
    }

    public boolean hasValue(Properties properties) {
        Reject.ifNull(properties, "Config is null");
        return properties.getProperty(this.configKey) != null;
    }

    public boolean hasNonBlankValue(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        return this.hasNonBlankValue(controller.getConfig());
    }

    public boolean hasNonBlankValue(Properties properties) {
        return this.hasValue(properties) && StringUtils.isNotBlank(this.getValue(properties));
    }

    public String getValue(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        return this.getValue(controller.getConfig());
    }

    public String getValue(Properties properties) {
        Reject.ifNull(properties, "Config is null");
        String string = properties.getProperty(this.configKey);
        if (string == null) {
            string = this.getDefaultValue();
        }
        return string;
    }

    public Integer getValueInt(Controller controller) {
        return this.getValueInt(controller.getConfig());
    }

    public Integer getValueInt(Properties properties) {
        String string = this.getValue(properties);
        if (string == null || StringUtils.isBlank(string)) {
            string = this.getDefaultValue();
        }
        if (string == null) {
            return null;
        }
        try {
            return Integer.valueOf(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            LOG.log(Level.WARNING, "Unable to parse configuration entry '" + this.configKey + "' into a int. Value: " + string, numberFormatException);
            return Integer.valueOf(this.getDefaultValue());
        }
    }

    public Boolean getValueBoolean(Controller controller) {
        return this.getValueBoolean(controller.getConfig());
    }

    public Boolean getValueBoolean(Properties properties) {
        String string = this.getValue(properties);
        if (string == null || StringUtils.isBlank(string)) {
            string = this.getDefaultValue();
        }
        if (string == null) {
            return null;
        }
        try {
            return string.trim().equalsIgnoreCase("true");
        }
        catch (NumberFormatException numberFormatException) {
            LOG.log(Level.WARNING, "Unable to parse configuration entry '" + this.configKey + "' into a boolean. Value: " + string, numberFormatException);
            return "true".equalsIgnoreCase(this.getDefaultValue());
        }
    }

    public String[] getValueArray(Controller controller) {
        String[] stringArray = new String[1];
        String string = this.getValue(controller.getConfig());
        if (string != null) {
            stringArray = string.split("\\s*,\\s*");
        }
        return stringArray;
    }

    @Deprecated
    public ValueModel getModel(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        ValueHolder valueHolder = new ValueHolder(this.getValue(controller), false);
        valueHolder.addValueChangeListener(propertyChangeEvent -> this.setValue(controller, (String)propertyChangeEvent.getNewValue()));
        return valueHolder;
    }

    public void setValue(Controller controller, String string) {
        this.setValue(controller.getConfig(), string);
    }

    public void setValue(Properties properties, String string) {
        Reject.ifNull(properties, "config is null");
        properties.setProperty(this.configKey, string);
    }

    public void setValue(Controller controller, boolean bl) {
        this.setValue(controller, String.valueOf(bl));
    }

    public void setValue(Controller controller, int n) {
        this.setValue(controller, String.valueOf(n));
    }

    public void setValue(Properties properties, boolean bl) {
        this.setValue(properties, String.valueOf(bl));
    }

    public void removeValue(Controller controller) {
        this.removeValue(controller.getConfig());
    }

    public void removeValue(Properties properties) {
        Reject.ifNull(properties, "config is null");
        properties.remove(this.configKey);
    }

    public void setOverwrite(Properties properties, Boolean bl) {
        if (bl != null) {
            properties.setProperty(this.getConfigKey() + ".overwrite", String.valueOf(bl));
        } else {
            properties.remove(this.getConfigKey() + ".overwrite");
        }
    }

    public void copy(Controller controller, Properties properties) {
        String string = this.getValue(controller);
        if (string != null) {
            properties.setProperty(this.getConfigKey(), string);
        } else {
            properties.remove(this.getConfigKey());
        }
    }

    public void copyIfNotDefault(Controller controller, Properties properties) {
        String string = this.getValue(controller);
        if (!Util.equals(string, this.getDefaultValue())) {
            this.copy(controller, properties);
        } else {
            this.removeValue(properties);
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public static ConfigurationEntry getEnum(String string) {
        return LOOKUP.get(string);
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    static {
        LOG = Logger.getLogger(ConfigurationEntry.class.getName());
        LOOKUP = Maps.uniqueIndex(Arrays.asList(ConfigurationEntry.values()), ConfigurationEntry::getConfigKey);
    }
}

