/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dagger.producers.monitoring.ProducerTimingRecorder;
import dagger.producers.monitoring.ProducerToken;
import dagger.producers.monitoring.ProductionComponentTimingRecorder;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TimingRecorders {
    private static final Logger logger = Logger.getLogger(TimingRecorders.class.getName());
    private static final ProductionComponentTimingRecorder.Factory NO_OP_PRODUCTION_COMPONENT_TIMING_RECORDER_FACTORY = new ProductionComponentTimingRecorder.Factory(){

        @Override
        public ProductionComponentTimingRecorder create(Object object) {
            return TimingRecorders.noOpProductionComponentTimingRecorder();
        }
    };
    private static final ProductionComponentTimingRecorder NO_OP_PRODUCTION_COMPONENT_TIMING_RECORDER = new ProductionComponentTimingRecorder(){

        @Override
        public ProducerTimingRecorder producerTimingRecorderFor(ProducerToken producerToken) {
            return ProducerTimingRecorder.noOp();
        }
    };

    public static ProductionComponentTimingRecorder.Factory delegatingProductionComponentTimingRecorderFactory(Collection<ProductionComponentTimingRecorder.Factory> collection) {
        switch (collection.size()) {
            case 0: {
                return TimingRecorders.noOpProductionComponentTimingRecorderFactory();
            }
            case 1: {
                return new NonThrowingProductionComponentTimingRecorder.Factory(Iterables.getOnlyElement(collection));
            }
        }
        return new DelegatingProductionComponentTimingRecorder.Factory(collection);
    }

    public static ProductionComponentTimingRecorder.Factory noOpProductionComponentTimingRecorderFactory() {
        return NO_OP_PRODUCTION_COMPONENT_TIMING_RECORDER_FACTORY;
    }

    public static ProductionComponentTimingRecorder noOpProductionComponentTimingRecorder() {
        return NO_OP_PRODUCTION_COMPONENT_TIMING_RECORDER;
    }

    private static void logCreateException(RuntimeException runtimeException, ProductionComponentTimingRecorder.Factory factory, Object object) {
        logger.log(Level.SEVERE, "RuntimeException while calling ProductionComponentTimingRecorder.Factory.create on factory " + factory + " with component " + object, runtimeException);
    }

    private static void logProducerTimingRecorderForException(RuntimeException runtimeException, ProductionComponentTimingRecorder productionComponentTimingRecorder, ProducerToken producerToken) {
        logger.log(Level.SEVERE, "RuntimeException while calling ProductionComponentTimingRecorder.producerTimingRecorderForon recorder " + productionComponentTimingRecorder + " with token " + producerToken, runtimeException);
    }

    private static void logProducerTimingRecorderMethodException(RuntimeException runtimeException, ProducerTimingRecorder producerTimingRecorder, String string) {
        logger.log(Level.SEVERE, "RuntimeException while calling ProducerTimingRecorder." + string + " on recorder " + producerTimingRecorder, runtimeException);
    }

    private TimingRecorders() {
    }

    private static final class DelegatingProducerTimingRecorder
    extends ProducerTimingRecorder {
        private final ImmutableList<ProducerTimingRecorder> delegates;

        DelegatingProducerTimingRecorder(ImmutableList<ProducerTimingRecorder> immutableList) {
            this.delegates = immutableList;
        }

        @Override
        public void recordMethod(long l, long l2) {
            for (ProducerTimingRecorder producerTimingRecorder : this.delegates) {
                try {
                    producerTimingRecorder.recordMethod(l, l2);
                }
                catch (RuntimeException runtimeException) {
                    TimingRecorders.logProducerTimingRecorderMethodException(runtimeException, producerTimingRecorder, "recordMethod");
                }
            }
        }

        @Override
        public void recordSuccess(long l) {
            for (ProducerTimingRecorder producerTimingRecorder : this.delegates) {
                try {
                    producerTimingRecorder.recordSuccess(l);
                }
                catch (RuntimeException runtimeException) {
                    TimingRecorders.logProducerTimingRecorderMethodException(runtimeException, producerTimingRecorder, "recordSuccess");
                }
            }
        }

        @Override
        public void recordFailure(Throwable throwable, long l) {
            for (ProducerTimingRecorder producerTimingRecorder : this.delegates) {
                try {
                    producerTimingRecorder.recordFailure(throwable, l);
                }
                catch (RuntimeException runtimeException) {
                    TimingRecorders.logProducerTimingRecorderMethodException(runtimeException, producerTimingRecorder, "recordFailure");
                }
            }
        }

        @Override
        public void recordSkip(Throwable throwable) {
            for (ProducerTimingRecorder producerTimingRecorder : this.delegates) {
                try {
                    producerTimingRecorder.recordSkip(throwable);
                }
                catch (RuntimeException runtimeException) {
                    TimingRecorders.logProducerTimingRecorderMethodException(runtimeException, producerTimingRecorder, "recordSkip");
                }
            }
        }
    }

    private static final class DelegatingProductionComponentTimingRecorder
    implements ProductionComponentTimingRecorder {
        private final ImmutableList<ProductionComponentTimingRecorder> delegates;

        DelegatingProductionComponentTimingRecorder(ImmutableList<ProductionComponentTimingRecorder> immutableList) {
            this.delegates = immutableList;
        }

        @Override
        public ProducerTimingRecorder producerTimingRecorderFor(ProducerToken producerToken) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ProductionComponentTimingRecorder productionComponentTimingRecorder : this.delegates) {
                try {
                    ProducerTimingRecorder producerTimingRecorder = productionComponentTimingRecorder.producerTimingRecorderFor(producerToken);
                    if (producerTimingRecorder == null) continue;
                    builder.add(producerTimingRecorder);
                }
                catch (RuntimeException runtimeException) {
                    TimingRecorders.logProducerTimingRecorderForException(runtimeException, productionComponentTimingRecorder, producerToken);
                }
            }
            ImmutableCollection immutableCollection = builder.build();
            switch (immutableCollection.size()) {
                case 0: {
                    return ProducerTimingRecorder.noOp();
                }
                case 1: {
                    return new NonThrowingProducerTimingRecorder((ProducerTimingRecorder)Iterables.getOnlyElement(immutableCollection));
                }
            }
            return new DelegatingProducerTimingRecorder((ImmutableList<ProducerTimingRecorder>)immutableCollection);
        }

        static final class Factory
        implements ProductionComponentTimingRecorder.Factory {
            private final ImmutableList<? extends ProductionComponentTimingRecorder.Factory> delegates;

            Factory(Iterable<? extends ProductionComponentTimingRecorder.Factory> iterable) {
                this.delegates = ImmutableList.copyOf(iterable);
            }

            @Override
            public ProductionComponentTimingRecorder create(Object object) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (ProductionComponentTimingRecorder.Factory factory : this.delegates) {
                    try {
                        ProductionComponentTimingRecorder productionComponentTimingRecorder = factory.create(object);
                        if (productionComponentTimingRecorder == null) continue;
                        builder.add(productionComponentTimingRecorder);
                    }
                    catch (RuntimeException runtimeException) {
                        TimingRecorders.logCreateException(runtimeException, factory, object);
                    }
                }
                ImmutableCollection immutableCollection = builder.build();
                switch (immutableCollection.size()) {
                    case 0: {
                        return TimingRecorders.noOpProductionComponentTimingRecorder();
                    }
                    case 1: {
                        return new NonThrowingProductionComponentTimingRecorder((ProductionComponentTimingRecorder)Iterables.getOnlyElement(immutableCollection));
                    }
                }
                return new DelegatingProductionComponentTimingRecorder((ImmutableList<ProductionComponentTimingRecorder>)immutableCollection);
            }
        }
    }

    private static final class NonThrowingProducerTimingRecorder
    extends ProducerTimingRecorder {
        private final ProducerTimingRecorder delegate;

        NonThrowingProducerTimingRecorder(ProducerTimingRecorder producerTimingRecorder) {
            this.delegate = producerTimingRecorder;
        }

        @Override
        public void recordMethod(long l, long l2) {
            try {
                this.delegate.recordMethod(l, l2);
            }
            catch (RuntimeException runtimeException) {
                TimingRecorders.logProducerTimingRecorderMethodException(runtimeException, this.delegate, "recordMethod");
            }
        }

        @Override
        public void recordSuccess(long l) {
            try {
                this.delegate.recordSuccess(l);
            }
            catch (RuntimeException runtimeException) {
                TimingRecorders.logProducerTimingRecorderMethodException(runtimeException, this.delegate, "recordSuccess");
            }
        }

        @Override
        public void recordFailure(Throwable throwable, long l) {
            try {
                this.delegate.recordFailure(throwable, l);
            }
            catch (RuntimeException runtimeException) {
                TimingRecorders.logProducerTimingRecorderMethodException(runtimeException, this.delegate, "recordFailure");
            }
        }

        @Override
        public void recordSkip(Throwable throwable) {
            try {
                this.delegate.recordSkip(throwable);
            }
            catch (RuntimeException runtimeException) {
                TimingRecorders.logProducerTimingRecorderMethodException(runtimeException, this.delegate, "recordSkip");
            }
        }
    }

    private static final class NonThrowingProductionComponentTimingRecorder
    implements ProductionComponentTimingRecorder {
        private final ProductionComponentTimingRecorder delegate;

        NonThrowingProductionComponentTimingRecorder(ProductionComponentTimingRecorder productionComponentTimingRecorder) {
            this.delegate = productionComponentTimingRecorder;
        }

        @Override
        public ProducerTimingRecorder producerTimingRecorderFor(ProducerToken producerToken) {
            try {
                ProducerTimingRecorder producerTimingRecorder = this.delegate.producerTimingRecorderFor(producerToken);
                return producerTimingRecorder == null ? ProducerTimingRecorder.noOp() : new NonThrowingProducerTimingRecorder(producerTimingRecorder);
            }
            catch (RuntimeException runtimeException) {
                TimingRecorders.logProducerTimingRecorderForException(runtimeException, this.delegate, producerToken);
                return ProducerTimingRecorder.noOp();
            }
        }

        static final class Factory
        implements ProductionComponentTimingRecorder.Factory {
            private final ProductionComponentTimingRecorder.Factory delegate;

            Factory(ProductionComponentTimingRecorder.Factory factory) {
                this.delegate = factory;
            }

            @Override
            public ProductionComponentTimingRecorder create(Object object) {
                try {
                    ProductionComponentTimingRecorder productionComponentTimingRecorder = this.delegate.create(object);
                    return productionComponentTimingRecorder == null ? TimingRecorders.noOpProductionComponentTimingRecorder() : new NonThrowingProductionComponentTimingRecorder(productionComponentTimingRecorder);
                }
                catch (RuntimeException runtimeException) {
                    TimingRecorders.logCreateException(runtimeException, this.delegate, object);
                    return TimingRecorders.noOpProductionComponentTimingRecorder();
                }
            }
        }
    }
}

