/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.internal.DaggerCollections;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class SetProducer<T>
extends AbstractProducer<Set<T>> {
    private static final Producer<Set<Object>> EMPTY_PRODUCER = new Producer<Set<Object>>(){

        @Override
        public ListenableFuture<Set<Object>> get() {
            return Futures.immediateFuture(ImmutableSet.of());
        }
    };
    private final List<Producer<T>> individualProducers;
    private final List<Producer<Collection<T>>> collectionProducers;

    public static <T> Producer<Set<T>> empty() {
        return EMPTY_PRODUCER;
    }

    public static <T> Builder<T> builder(int n, int n2) {
        return new Builder(n, n2);
    }

    private SetProducer(List<Producer<T>> list, List<Producer<Collection<T>>> list2) {
        this.individualProducers = list;
        this.collectionProducers = list2;
    }

    @Override
    public ListenableFuture<Set<T>> compute() {
        ArrayList<ListenableFuture<T>> arrayList = new ArrayList<ListenableFuture<T>>(this.individualProducers.size());
        for (Producer<T> object : this.individualProducers) {
            arrayList.add(Preconditions.checkNotNull(object.get()));
        }
        ArrayList arrayList2 = new ArrayList(this.collectionProducers.size() + 1);
        arrayList2.add(Futures.allAsList(arrayList));
        for (Producer<Collection<T>> producer : this.collectionProducers) {
            arrayList2.add(Preconditions.checkNotNull(producer.get()));
        }
        return Futures.transform(Futures.allAsList(arrayList2), new Function<List<Collection<T>>, Set<T>>(){

            @Override
            public Set<T> apply(List<Collection<T>> list) {
                ImmutableSet.Builder builder = ImmutableSet.builder();
                for (Collection collection : list) {
                    builder.addAll((Iterable)collection);
                }
                return builder.build();
            }
        }, MoreExecutors.directExecutor());
    }

    public static final class Builder<T> {
        private final List<Producer<T>> individualProducers;
        private final List<Producer<Collection<T>>> collectionProducers;

        private Builder(int n, int n2) {
            this.individualProducers = DaggerCollections.presizedList(n);
            this.collectionProducers = DaggerCollections.presizedList(n2);
        }

        public Builder<T> addProducer(Producer<? extends T> producer) {
            assert (producer != null) : "Codegen error? Null producer";
            this.individualProducers.add(producer);
            return this;
        }

        public Builder<T> addCollectionProducer(Producer<? extends Collection<? extends T>> producer) {
            assert (producer != null) : "Codegen error? Null producer";
            this.collectionProducers.add(producer);
            return this;
        }

        public SetProducer<T> build() {
            assert (!DaggerCollections.hasDuplicates(this.individualProducers)) : "Codegen error?  Duplicates in the producer list";
            assert (!DaggerCollections.hasDuplicates(this.collectionProducers)) : "Codegen error?  Duplicates in the producer list";
            return new SetProducer(this.individualProducers, this.collectionProducers);
        }
    }
}

