/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
public abstract class Produced<T> {
    public abstract T get() throws ExecutionException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static <T> Produced<T> successful(@Nullable T t) {
        return new Successful(t);
    }

    public static <T> Produced<T> failed(Throwable throwable) {
        return new Failed(Preconditions.checkNotNull(throwable));
    }

    private Produced() {
    }

    private static final class Failed<T>
    extends Produced<T> {
        private final Throwable throwable;

        private Failed(Throwable throwable) {
            this.throwable = Preconditions.checkNotNull(throwable);
        }

        @Override
        public T get() throws ExecutionException {
            throw new ExecutionException(this.throwable);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Failed) {
                Failed failed = (Failed)object;
                return this.throwable.equals(failed.throwable);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.throwable.hashCode();
        }
    }

    private static final class Successful<T>
    extends Produced<T> {
        @Nullable
        private final T value;

        private Successful(@Nullable T t) {
            this.value = t;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Successful) {
                Successful successful = (Successful)object;
                return Objects.equal(this.value, successful.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }
    }
}

