/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.nativity.modules.contextmenu;

import com.liferay.nativity.control.NativityControl;
import com.liferay.nativity.modules.contextmenu.ContextMenuControlCallback;
import com.liferay.nativity.modules.contextmenu.model.ContextMenuItem;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextMenuControl
implements ContextMenuControlCallback {
    protected ContextMenuControlCallback contextMenuControlCallback;
    protected List<ContextMenuItem> contextMenuItems;
    protected NativityControl nativityControl;
    private static Logger _logger = LoggerFactory.getLogger(ContextMenuControl.class.getName());

    public ContextMenuControl(NativityControl nativityControl, ContextMenuControlCallback contextMenuControlCallback) {
        this.nativityControl = nativityControl;
        this.contextMenuControlCallback = contextMenuControlCallback;
        this.contextMenuItems = new ArrayList<ContextMenuItem>();
    }

    public void fireContextMenuAction(String string, String[] stringArray) {
        for (ContextMenuItem contextMenuItem : this.contextMenuItems) {
            if (!contextMenuItem.getUuid().equals(string)) continue;
            _logger.trace("Firing action uuid: {} for: {}", (Object)string, (Object)stringArray);
            contextMenuItem.fireContextMenuAction(stringArray);
            break;
        }
    }

    @Override
    public List<ContextMenuItem> getContextMenuItems(String[] stringArray) {
        List<ContextMenuItem> list = this.contextMenuControlCallback.getContextMenuItems(stringArray);
        this.contextMenuItems.clear();
        if (list == null) {
            return null;
        }
        for (ContextMenuItem contextMenuItem : list) {
            this.contextMenuItems.addAll(contextMenuItem.getAllContextMenuItems());
        }
        return list;
    }

    @Deprecated
    public abstract void registerIcon(String var1, String var2);
}

