/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.util;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.message.PropertyValidationMessage;

public final class PropertyValidationSupport {
    private ValidationResult defaultResult;
    private final Severity defaultSeverity;
    private final Object target;
    private final String role;

    public PropertyValidationSupport(Object object, String string) {
        this(Severity.WARNING, object, string);
    }

    public PropertyValidationSupport(Severity severity, Object object, String string) {
        this(new ValidationResult(), severity, object, string);
    }

    public PropertyValidationSupport(ValidationResult validationResult, Severity severity, Object object, String string) {
        if (severity == Severity.OK) {
            throw new IllegalArgumentException("Severity.OK must not be used in validation messages.");
        }
        this.defaultResult = validationResult;
        this.defaultSeverity = severity;
        this.target = object;
        this.role = string;
    }

    public void clearResult() {
        this.defaultResult = new ValidationResult();
    }

    public ValidationResult getResult() {
        return this.defaultResult;
    }

    public PropertyValidationMessage createError(String string, String string2) {
        return this.create(Severity.ERROR, string, string2);
    }

    public PropertyValidationMessage createWarning(String string, String string2) {
        return this.create(Severity.WARNING, string, string2);
    }

    public PropertyValidationMessage create(String string, String string2) {
        return this.create(this.defaultSeverity, string, string2);
    }

    public PropertyValidationMessage create(Severity severity, String string, String string2) {
        return new PropertyValidationMessage(severity, string2, this.target, this.role, string);
    }

    public void addError(String string, String string2) {
        this.addError(this.defaultResult, string, string2);
    }

    public void addWarning(String string, String string2) {
        this.addWarning(this.defaultResult, string, string2);
    }

    public void add(String string, String string2) {
        this.add(this.defaultResult, string, string2);
    }

    public void add(Severity severity, String string, String string2) {
        this.add(this.defaultResult, severity, string, string2);
    }

    public void addError(ValidationResult validationResult, String string, String string2) {
        validationResult.add(this.createError(string, string2));
    }

    public void addWarning(ValidationResult validationResult, String string, String string2) {
        validationResult.add(this.createWarning(string, string2));
    }

    public void add(ValidationResult validationResult, String string, String string2) {
        validationResult.add(this.create(string, string2));
    }

    public void add(ValidationResult validationResult, Severity severity, String string, String string2) {
        if (severity == Severity.OK) {
            throw new IllegalArgumentException("Severity.OK must not be used in validation messages.");
        }
        validationResult.add(this.create(severity, string, string2));
    }
}

