/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.message.SimpleValidationMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationResult
implements Serializable {
    public static final ValidationResult EMPTY = new ValidationResult(Collections.<ValidationMessage>emptyList(), false);
    private final List<ValidationMessage> messageList;
    private final boolean modifiable;

    public ValidationResult() {
        this(new ArrayList<ValidationMessage>(), true);
    }

    private ValidationResult(List<ValidationMessage> list, boolean bl) {
        this.messageList = list;
        this.modifiable = bl;
    }

    public static ValidationResult unmodifiableResult(ValidationResult validationResult) {
        return validationResult.modifiable ? new ValidationResult(new ArrayList<ValidationMessage>(validationResult.messageList), false) : validationResult;
    }

    public void add(ValidationMessage validationMessage) {
        this.assertModifiable();
        if (validationMessage == null) {
            throw new NullPointerException("The validation message must not be null.");
        }
        if (validationMessage.severity() == Severity.OK) {
            throw new IllegalArgumentException("You must not add a validation message with severity OK.");
        }
        this.messageList.add(validationMessage);
    }

    public void addError(String string) {
        this.assertModifiable();
        if (string == null) {
            throw new NullPointerException("The message text must not be null.");
        }
        this.add(new SimpleValidationMessage(string, Severity.ERROR));
    }

    public void addWarning(String string) {
        this.assertModifiable();
        if (string == null) {
            throw new NullPointerException("The message text must not be null.");
        }
        this.add(new SimpleValidationMessage(string));
    }

    public void addAll(List<ValidationMessage> list) {
        this.assertModifiable();
        if (list == null) {
            throw new NullPointerException("The messages list must not be null.");
        }
        for (ValidationMessage validationMessage : list) {
            if (validationMessage.severity() != Severity.OK) continue;
            throw new IllegalArgumentException("You must not add a validation message with severity OK.");
        }
        this.messageList.addAll(list);
    }

    public void addAllFrom(ValidationResult validationResult) {
        this.assertModifiable();
        if (validationResult == null) {
            throw new NullPointerException("The validation result to add must not be null.");
        }
        this.addAll(validationResult.messageList);
    }

    public boolean isEmpty() {
        return this.messageList.isEmpty();
    }

    public int size() {
        return this.messageList.size();
    }

    public boolean contains(ValidationMessage validationMessage) {
        return this.messageList.contains(validationMessage);
    }

    public ValidationResult subResult(int n, int n2) {
        List<ValidationMessage> list = this.messageList.subList(n, n2);
        return new ValidationResult(list, false);
    }

    public ValidationResult subResult(Object object) {
        if (object == null) {
            return EMPTY;
        }
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        for (ValidationMessage validationMessage : this.messageList) {
            if (!object.equals(validationMessage.key())) continue;
            arrayList.add(validationMessage);
        }
        return new ValidationResult(arrayList, false);
    }

    public ValidationResult subResult(Object[] objectArray) {
        if (objectArray == null) {
            return EMPTY;
        }
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        for (ValidationMessage validationMessage : this.messageList) {
            Object object = validationMessage.key();
            for (Object object2 : objectArray) {
                if (!object.equals(object2)) continue;
                arrayList.add(validationMessage);
            }
        }
        return new ValidationResult(arrayList, false);
    }

    public Map<Object, ValidationResult> keyMap() {
        LinkedList<ValidationMessage> linkedList;
        HashMap<Object, LinkedList<ValidationMessage>> hashMap = new HashMap<Object, LinkedList<ValidationMessage>>();
        for (ValidationMessage object : this.messageList) {
            Object object2 = object.key();
            linkedList = (LinkedList<ValidationMessage>)hashMap.get(object2);
            if (linkedList == null) {
                linkedList = new LinkedList<ValidationMessage>();
                hashMap.put(object2, linkedList);
            }
            linkedList.add(object);
        }
        HashMap hashMap2 = new HashMap(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            linkedList = entry.getKey();
            List list = (List)entry.getValue();
            hashMap2.put(linkedList, new ValidationResult(list, false));
        }
        return Collections.unmodifiableMap(hashMap2);
    }

    public Severity getSeverity() {
        return ValidationResult.getSeverity(this.messageList);
    }

    public boolean hasMessages() {
        return !this.isEmpty();
    }

    public boolean hasErrors() {
        return ValidationResult.hasSeverity(this.messageList, Severity.ERROR);
    }

    public boolean hasWarnings() {
        return ValidationResult.hasSeverity(this.messageList, Severity.WARNING);
    }

    public List<ValidationMessage> getMessages() {
        return Collections.unmodifiableList(this.messageList);
    }

    public List<ValidationMessage> getErrors() {
        return ValidationResult.getMessagesWithSeverity(this.messageList, Severity.ERROR);
    }

    public List<ValidationMessage> getWarnings() {
        return ValidationResult.getMessagesWithSeverity(this.messageList, Severity.WARNING);
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public String getMessagesText() {
        return ValidationResult.getMessagesText(this.messageList);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty ValidationResult";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.modifiable ? "Modifiable" : "Unmodifiable");
        stringBuilder.append(" ValidationResult:");
        for (ValidationMessage validationMessage : this.messageList) {
            stringBuilder.append("\n\t").append(validationMessage);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ValidationResult)) {
            return false;
        }
        return ((Object)this.messageList).equals(((ValidationResult)object).messageList);
    }

    public int hashCode() {
        return ((Object)this.messageList).hashCode();
    }

    private void assertModifiable() {
        if (!this.modifiable) {
            throw new UnsupportedOperationException("This validation result is unmodifiable.");
        }
    }

    private static Severity getSeverity(List<ValidationMessage> list) {
        if (list.isEmpty()) {
            return Severity.OK;
        }
        for (ValidationMessage validationMessage : list) {
            if (validationMessage.severity() != Severity.ERROR) continue;
            return Severity.ERROR;
        }
        return Severity.WARNING;
    }

    private static boolean hasSeverity(List<ValidationMessage> list, Severity severity) {
        for (ValidationMessage validationMessage : list) {
            if (validationMessage.severity() != severity) continue;
            return true;
        }
        return false;
    }

    private static List<ValidationMessage> getMessagesWithSeverity(List<ValidationMessage> list, Severity severity) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        for (ValidationMessage validationMessage : list) {
            if (validationMessage.severity() != severity) continue;
            arrayList.add(validationMessage);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static String getMessagesText(List<ValidationMessage> list) {
        if (list.isEmpty()) {
            return "OK";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (ValidationMessage validationMessage : list) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(validationMessage.formattedText());
        }
        return stringBuilder.toString();
    }
}

