/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.AbstractFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class PanelBuilder
extends AbstractFormBuilder {
    private ComponentFactory componentFactory;

    public PanelBuilder(FormLayout formLayout) {
        this(formLayout, new JPanel(null));
    }

    public PanelBuilder(FormLayout formLayout, JPanel jPanel) {
        super(formLayout, jPanel);
    }

    public final JPanel getPanel() {
        return (JPanel)this.getContainer();
    }

    public final void setBackground(Color color) {
        this.getPanel().setBackground(color);
    }

    public final void setBorder(Border border) {
        this.getPanel().setBorder(border);
    }

    public final void setDefaultDialogBorder() {
        this.setBorder(Borders.DIALOG_BORDER);
    }

    public final void setOpaque(boolean bl) {
        this.getPanel().setOpaque(bl);
    }

    public final JLabel addLabel(String string) {
        return this.addLabel(string, this.cellConstraints());
    }

    public final JLabel addLabel(String string, CellConstraints cellConstraints) {
        JLabel jLabel = this.getComponentFactory().createLabel(string);
        this.add((Component)jLabel, cellConstraints);
        return jLabel;
    }

    public final JLabel addLabel(String string, String string2) {
        return this.addLabel(string, new CellConstraints(string2));
    }

    public final JLabel add(JLabel jLabel, CellConstraints cellConstraints, Component component, CellConstraints cellConstraints2) {
        if (cellConstraints == cellConstraints2) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        this.add((Component)jLabel, cellConstraints);
        this.add(component, cellConstraints2);
        jLabel.setLabelFor(component);
        return jLabel;
    }

    public final JLabel addLabel(String string, CellConstraints cellConstraints, Component component, CellConstraints cellConstraints2) {
        if (cellConstraints == cellConstraints2) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        JLabel jLabel = this.addLabel(string, cellConstraints);
        this.add(component, cellConstraints2);
        jLabel.setLabelFor(component);
        return jLabel;
    }

    public final JLabel addTitle(String string) {
        return this.addTitle(string, this.cellConstraints());
    }

    public final JLabel addTitle(String string, CellConstraints cellConstraints) {
        JLabel jLabel = this.getComponentFactory().createTitle(string);
        this.add((Component)jLabel, cellConstraints);
        return jLabel;
    }

    public final JLabel addTitle(String string, String string2) {
        return this.addTitle(string, new CellConstraints(string2));
    }

    public final JComponent addSeparator(String string) {
        return this.addSeparator(string, this.getLayout().getColumnCount());
    }

    public final JComponent addSeparator(String string, CellConstraints cellConstraints) {
        int n = this.isLeftToRight() ? 2 : 4;
        JComponent jComponent = this.getComponentFactory().createSeparator(string, n);
        this.add((Component)jComponent, cellConstraints);
        return jComponent;
    }

    public final JComponent addSeparator(String string, String string2) {
        return this.addSeparator(string, new CellConstraints(string2));
    }

    public final JComponent addSeparator(String string, int n) {
        return this.addSeparator(string, this.createLeftAdjustedConstraints(n));
    }

    public final ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = DefaultComponentFactory.getInstance();
        }
        return this.componentFactory;
    }

    public final void setComponentFactory(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }
}

