/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.util;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class ChangeTracker
extends Model {
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final PropertyChangeListener updateHandler = new UpdateHandler();
    private boolean changed = false;

    public boolean isChanged() {
        return this.changed;
    }

    public void reset() {
        this.setChanged(false);
    }

    private void setChanged(boolean bl) {
        boolean bl2 = this.isChanged();
        this.changed = bl;
        this.firePropertyChange(PROPERTYNAME_CHANGED, bl2, bl);
    }

    public void observe(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        BeanUtils.addPropertyChangeListener(object, string, this.updateHandler);
    }

    public void observe(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The ValueModel must not be null.");
        }
        valueModel.addValueChangeListener(this.updateHandler);
    }

    public void retractInterestFor(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        BeanUtils.removePropertyChangeListener(object, string, this.updateHandler);
    }

    public void retractInterestFor(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The ValueModel must not be null.");
        }
        valueModel.removeValueChangeListener(this.updateHandler);
    }

    private final class UpdateHandler
    implements PropertyChangeListener {
        private UpdateHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!ChangeTracker.PROPERTYNAME_CHANGED.equals(string) || ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                ChangeTracker.this.setChanged(true);
            }
        }
    }
}

