/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.list.ObservableList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkedListModel<E>
extends LinkedList<E>
implements ObservableList<E> {
    private static final long serialVersionUID = 5753378113505707237L;
    private EventListenerList listenerList;

    public LinkedListModel() {
    }

    public LinkedListModel(Collection<? extends E> collection) {
        super(collection);
    }

    @Override
    public void add(int n, E e) {
        super.add(n, e);
        this.fireIntervalAdded(n, n);
    }

    @Override
    public boolean add(E e) {
        int n = this.size();
        super.add(e);
        this.fireIntervalAdded(n, n);
        return true;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = super.addAll(n, collection);
        if (bl) {
            int n2 = n + collection.size() - 1;
            this.fireIntervalAdded(n, n2);
        }
        return bl;
    }

    @Override
    public void addFirst(E e) {
        super.addFirst(e);
        this.fireIntervalAdded(0, 0);
    }

    @Override
    public void addLast(E e) {
        int n = this.size();
        super.addLast(e);
        this.fireIntervalAdded(n, n);
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        int n = this.size() - 1;
        super.clear();
        this.fireIntervalRemoved(0, n);
    }

    @Override
    public E remove(int n) {
        Object e = super.remove(n);
        this.fireIntervalRemoved(n, n);
        return e;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    @Override
    public E removeFirst() {
        Object e = super.removeFirst();
        this.fireIntervalRemoved(0, 0);
        return e;
    }

    @Override
    public E removeLast() {
        int n = this.size() - 1;
        Object e = super.removeLast();
        this.fireIntervalRemoved(n, n);
        return e;
    }

    @Override
    protected void removeRange(int n, int n2) {
        super.removeRange(n, n2);
        this.fireIntervalRemoved(n, n2 - 1);
    }

    @Override
    public E set(int n, E e) {
        E e2 = super.set(n, e);
        this.fireContentsChanged(n, n);
        return e2;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new ReportingListIterator(super.listIterator(n));
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.getEventListenerList().add(ListDataListener.class, listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.getEventListenerList().remove(ListDataListener.class, listDataListener);
    }

    @Override
    public E getElementAt(int n) {
        return this.get(n);
    }

    @Override
    public int getSize() {
        return this.size();
    }

    public void fireContentsChanged(int n) {
        this.fireContentsChanged(n, n);
    }

    public ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.getEventListenerList().getListeners(ListDataListener.class);
    }

    private void fireContentsChanged(int n, int n2) {
        Object[] objectArray = this.getEventListenerList().getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 0, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }

    private void fireIntervalAdded(int n, int n2) {
        Object[] objectArray = this.getEventListenerList().getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 1, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
        }
    }

    private void fireIntervalRemoved(int n, int n2) {
        Object[] objectArray = this.getEventListenerList().getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListDataListener.class) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 2, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
        }
    }

    private EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ReportingListIterator
    implements ListIterator<E> {
        private final ListIterator<E> delegate;
        private int lastReturnedIndex;

        ReportingListIterator(ListIterator<E> listIterator) {
            this.delegate = listIterator;
            this.lastReturnedIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            this.lastReturnedIndex = this.nextIndex();
            return this.delegate.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public E previous() {
            this.lastReturnedIndex = this.previousIndex();
            return this.delegate.previous();
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            int n = LinkedListModel.this.size();
            this.delegate.remove();
            int n2 = LinkedListModel.this.size();
            if (n2 < n) {
                LinkedListModel.this.fireIntervalRemoved(this.lastReturnedIndex, this.lastReturnedIndex);
            }
        }

        @Override
        public void set(E e) {
            this.delegate.set(e);
        }

        @Override
        public void add(E e) {
            this.delegate.add(e);
            int n = this.previousIndex();
            LinkedListModel.this.fireIntervalAdded(n, n);
            this.lastReturnedIndex = -1;
        }
    }
}

