/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@Immutable
@Beta
@GwtCompatible
public final class ImmutableLongArray
implements Serializable {
    private static final ImmutableLongArray EMPTY = new ImmutableLongArray(new long[0]);
    private final long[] array;
    private final transient int start;
    private final int end;

    public static ImmutableLongArray of() {
        return EMPTY;
    }

    public static ImmutableLongArray of(long l) {
        return new ImmutableLongArray(new long[]{l});
    }

    public static ImmutableLongArray of(long l, long l2) {
        return new ImmutableLongArray(new long[]{l, l2});
    }

    public static ImmutableLongArray of(long l, long l2, long l3) {
        return new ImmutableLongArray(new long[]{l, l2, l3});
    }

    public static ImmutableLongArray of(long l, long l2, long l3, long l4) {
        return new ImmutableLongArray(new long[]{l, l2, l3, l4});
    }

    public static ImmutableLongArray of(long l, long l2, long l3, long l4, long l5) {
        return new ImmutableLongArray(new long[]{l, l2, l3, l4, l5});
    }

    public static ImmutableLongArray of(long l, long l2, long l3, long l4, long l5, long l6) {
        return new ImmutableLongArray(new long[]{l, l2, l3, l4, l5, l6});
    }

    public static ImmutableLongArray of(long l, long ... lArray) {
        long[] lArray2 = new long[lArray.length + 1];
        lArray2[0] = l;
        System.arraycopy(lArray, 0, lArray2, 1, lArray.length);
        return new ImmutableLongArray(lArray2);
    }

    public static ImmutableLongArray copyOf(long[] lArray) {
        return lArray.length == 0 ? EMPTY : new ImmutableLongArray(Arrays.copyOf(lArray, lArray.length));
    }

    public static ImmutableLongArray copyOf(Collection<Long> collection) {
        return collection.isEmpty() ? EMPTY : new ImmutableLongArray(Longs.toArray(collection));
    }

    public static ImmutableLongArray copyOf(Iterable<Long> iterable) {
        if (iterable instanceof Collection) {
            return ImmutableLongArray.copyOf((Collection)iterable);
        }
        return ImmutableLongArray.builder().addAll(iterable).build();
    }

    public static ImmutableLongArray copyOf(LongStream longStream) {
        long[] lArray = longStream.toArray();
        return lArray.length == 0 ? EMPTY : new ImmutableLongArray(lArray);
    }

    public static Builder builder(int n) {
        Preconditions.checkArgument(n >= 0, "Invalid initialCapacity: %s", n);
        return new Builder(n);
    }

    public static Builder builder() {
        return new Builder(10);
    }

    private ImmutableLongArray(long[] lArray) {
        this(lArray, 0, lArray.length);
    }

    private ImmutableLongArray(long[] lArray, int n, int n2) {
        this.array = lArray;
        this.start = n;
        this.end = n2;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isEmpty() {
        return this.end == this.start;
    }

    public long get(int n) {
        Preconditions.checkElementIndex(n, this.length());
        return this.array[this.start + n];
    }

    public int indexOf(long l) {
        for (int i = this.start; i < this.end; ++i) {
            if (this.array[i] != l) continue;
            return i - this.start;
        }
        return -1;
    }

    public int lastIndexOf(long l) {
        for (int i = this.end - 1; i >= this.start; --i) {
            if (this.array[i] != l) continue;
            return i - this.start;
        }
        return -1;
    }

    public boolean contains(long l) {
        return this.indexOf(l) >= 0;
    }

    public void forEach(LongConsumer longConsumer) {
        Preconditions.checkNotNull(longConsumer);
        for (int i = this.start; i < this.end; ++i) {
            longConsumer.accept(this.array[i]);
        }
    }

    public LongStream stream() {
        return Arrays.stream(this.array, this.start, this.end);
    }

    public long[] toArray() {
        return Arrays.copyOfRange(this.array, this.start, this.end);
    }

    public ImmutableLongArray subArray(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.length());
        return n == n2 ? EMPTY : new ImmutableLongArray(this.array, this.start + n, this.start + n2);
    }

    private Spliterator.OfLong spliterator() {
        return Spliterators.spliterator(this.array, this.start, this.end, 1040);
    }

    public List<Long> asList() {
        return new AsList(this);
    }

    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImmutableLongArray)) {
            return false;
        }
        ImmutableLongArray immutableLongArray = (ImmutableLongArray)object;
        if (this.length() != immutableLongArray.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.get(i) == immutableLongArray.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        for (int i = this.start; i < this.end; ++i) {
            n *= 31;
            n += Longs.hashCode(this.array[i]);
        }
        return n;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(this.length() * 5);
        stringBuilder.append('[').append(this.array[this.start]);
        for (int i = this.start + 1; i < this.end; ++i) {
            stringBuilder.append(", ").append(this.array[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public ImmutableLongArray trimmed() {
        return this.isPartialView() ? new ImmutableLongArray(this.toArray()) : this;
    }

    private boolean isPartialView() {
        return this.start > 0 || this.end < this.array.length;
    }

    Object writeReplace() {
        return this.trimmed();
    }

    Object readResolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    static class AsList
    extends AbstractList<Long>
    implements RandomAccess,
    Serializable {
        private final ImmutableLongArray parent;

        private AsList(ImmutableLongArray immutableLongArray) {
            this.parent = immutableLongArray;
        }

        @Override
        public int size() {
            return this.parent.length();
        }

        @Override
        public Long get(int n) {
            return this.parent.get(n);
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf(object) >= 0;
        }

        @Override
        public int indexOf(Object object) {
            return object instanceof Long ? this.parent.indexOf((Long)object) : -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return object instanceof Long ? this.parent.lastIndexOf((Long)object) : -1;
        }

        @Override
        public List<Long> subList(int n, int n2) {
            return this.parent.subArray(n, n2).asList();
        }

        @Override
        public Spliterator<Long> spliterator() {
            return this.parent.spliterator();
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof AsList) {
                AsList asList = (AsList)object;
                return this.parent.equals(asList.parent);
            }
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            int n = this.parent.start;
            for (Object e : list) {
                if (e instanceof Long && this.parent.array[n++] == (Long)e) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.parent.hashCode();
        }

        @Override
        public String toString() {
            return this.parent.toString();
        }
    }

    @CanIgnoreReturnValue
    public static final class Builder {
        private long[] array;
        private int count = 0;

        Builder(int n) {
            this.array = new long[n];
        }

        public Builder add(long l) {
            this.ensureRoomFor(1);
            this.array[this.count] = l;
            ++this.count;
            return this;
        }

        public Builder addAll(long[] lArray) {
            this.ensureRoomFor(lArray.length);
            System.arraycopy(lArray, 0, this.array, this.count, lArray.length);
            this.count += lArray.length;
            return this;
        }

        public Builder addAll(Iterable<Long> iterable) {
            if (iterable instanceof Collection) {
                return this.addAll((Collection)iterable);
            }
            for (Long l : iterable) {
                this.add(l);
            }
            return this;
        }

        public Builder addAll(Collection<Long> collection) {
            this.ensureRoomFor(collection.size());
            for (Long l : collection) {
                this.array[this.count++] = l;
            }
            return this;
        }

        public Builder addAll(LongStream longStream) {
            Spliterator.OfLong ofLong = longStream.spliterator();
            long l = ofLong.getExactSizeIfKnown();
            if (l > 0L) {
                this.ensureRoomFor(Ints.saturatedCast(l));
            }
            ofLong.forEachRemaining(this::add);
            return this;
        }

        public Builder addAll(ImmutableLongArray immutableLongArray) {
            this.ensureRoomFor(immutableLongArray.length());
            System.arraycopy(immutableLongArray.array, immutableLongArray.start, this.array, this.count, immutableLongArray.length());
            this.count += immutableLongArray.length();
            return this;
        }

        private void ensureRoomFor(int n) {
            int n2 = this.count + n;
            if (n2 > this.array.length) {
                long[] lArray = new long[Builder.expandedCapacity(this.array.length, n2)];
                System.arraycopy(this.array, 0, lArray, 0, this.count);
                this.array = lArray;
            }
        }

        private static int expandedCapacity(int n, int n2) {
            if (n2 < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n3 = n + (n >> 1) + 1;
            if (n3 < n2) {
                n3 = Integer.highestOneBit(n2 - 1) << 1;
            }
            if (n3 < 0) {
                n3 = Integer.MAX_VALUE;
            }
            return n3;
        }

        @CheckReturnValue
        public ImmutableLongArray build() {
            return this.count == 0 ? EMPTY : new ImmutableLongArray(this.array, 0, this.count);
        }
    }
}

