/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.AbstractGraph;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import com.google.common.math.IntMath;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

@Beta
@GwtIncompatible
public abstract class AbstractNetwork<N, E>
implements Network<N, E> {
    @Override
    public Graph<N> asGraph() {
        return new AbstractGraph<N>(){

            @Override
            public Set<N> nodes() {
                return AbstractNetwork.this.nodes();
            }

            @Override
            public Set<EndpointPair<N>> edges() {
                if (AbstractNetwork.this.allowsParallelEdges()) {
                    return super.edges();
                }
                return new AbstractSet<EndpointPair<N>>(){

                    @Override
                    public Iterator<EndpointPair<N>> iterator() {
                        return Iterators.transform(AbstractNetwork.this.edges().iterator(), new Function<E, EndpointPair<N>>(){

                            @Override
                            public EndpointPair<N> apply(E e) {
                                return AbstractNetwork.this.incidentNodes(e);
                            }
                        });
                    }

                    @Override
                    public int size() {
                        return AbstractNetwork.this.edges().size();
                    }

                    @Override
                    public boolean contains(@Nullable Object object) {
                        if (!(object instanceof EndpointPair)) {
                            return false;
                        }
                        EndpointPair endpointPair = (EndpointPair)object;
                        return this.isDirected() == endpointPair.isOrdered() && this.nodes().contains(endpointPair.nodeU()) && this.successors(endpointPair.nodeU()).contains(endpointPair.nodeV());
                    }
                };
            }

            @Override
            public ElementOrder<N> nodeOrder() {
                return AbstractNetwork.this.nodeOrder();
            }

            @Override
            public boolean isDirected() {
                return AbstractNetwork.this.isDirected();
            }

            @Override
            public boolean allowsSelfLoops() {
                return AbstractNetwork.this.allowsSelfLoops();
            }

            @Override
            public Set<N> adjacentNodes(N n) {
                return AbstractNetwork.this.adjacentNodes(n);
            }

            @Override
            public Set<N> predecessors(N n) {
                return AbstractNetwork.this.predecessors(n);
            }

            @Override
            public Set<N> successors(N n) {
                return AbstractNetwork.this.successors(n);
            }
        };
    }

    @Override
    public int degree(N n) {
        if (this.isDirected()) {
            return IntMath.saturatedAdd(this.inEdges(n).size(), this.outEdges(n).size());
        }
        return IntMath.saturatedAdd(this.incidentEdges(n).size(), this.edgesConnecting(n, n).size());
    }

    @Override
    public int inDegree(N n) {
        return this.isDirected() ? this.inEdges(n).size() : this.degree(n);
    }

    @Override
    public int outDegree(N n) {
        return this.isDirected() ? this.outEdges(n).size() : this.degree(n);
    }

    @Override
    public Set<E> adjacentEdges(E e) {
        EndpointPair endpointPair = this.incidentNodes(e);
        Sets.SetView setView = Sets.union(this.incidentEdges(endpointPair.nodeU()), this.incidentEdges(endpointPair.nodeV()));
        return Sets.difference(setView, ImmutableSet.of(e));
    }

    @Override
    public Set<E> edgesConnecting(N n, N n2) {
        Set set = this.outEdges(n);
        Set set2 = this.inEdges(n2);
        return set.size() <= set2.size() ? Collections.unmodifiableSet(Sets.filter(set, this.connectedPredicate(n, n2))) : Collections.unmodifiableSet(Sets.filter(set2, this.connectedPredicate(n2, n)));
    }

    private Predicate<E> connectedPredicate(final N n, final N n2) {
        return new Predicate<E>(){

            @Override
            public boolean apply(E e) {
                return AbstractNetwork.this.incidentNodes(e).adjacentNode(n).equals(n2);
            }
        };
    }

    @Override
    public Optional<E> edgeConnecting(N n, N n2) {
        Set<E> set = this.edgesConnecting(n, n2);
        switch (set.size()) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return Optional.of(set.iterator().next());
            }
        }
        throw new IllegalArgumentException(String.format("Cannot call edgeConnecting() when parallel edges exist between %s and %s. Consider calling edgesConnecting() instead.", n, n2));
    }

    @Override
    @Nullable
    public E edgeConnectingOrNull(N n, N n2) {
        return this.edgeConnecting(n, n2).orElse(null);
    }

    @Override
    public boolean hasEdgeConnecting(N n, N n2) {
        return !this.edgesConnecting(n, n2).isEmpty();
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Network)) {
            return false;
        }
        Network network = (Network)object;
        return this.isDirected() == network.isDirected() && this.nodes().equals(network.nodes()) && AbstractNetwork.edgeIncidentNodesMap(this).equals(AbstractNetwork.edgeIncidentNodesMap(network));
    }

    @Override
    public final int hashCode() {
        return AbstractNetwork.edgeIncidentNodesMap(this).hashCode();
    }

    public String toString() {
        return "isDirected: " + this.isDirected() + ", allowsParallelEdges: " + this.allowsParallelEdges() + ", allowsSelfLoops: " + this.allowsSelfLoops() + ", nodes: " + this.nodes() + ", edges: " + AbstractNetwork.edgeIncidentNodesMap(this);
    }

    private static <N, E> Map<E, EndpointPair<N>> edgeIncidentNodesMap(final Network<N, E> network) {
        Function function = new Function<E, EndpointPair<N>>(){

            @Override
            public EndpointPair<N> apply(E e) {
                return network.incidentNodes(e);
            }
        };
        return Maps.asMap(network.edges(), function);
    }
}

