/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StaticListSerializerBase;
import java.io.IOException;
import java.util.List;

@JacksonStdImpl
public final class IndexedStringListSerializer
extends StaticListSerializerBase<List<String>> {
    private static final long serialVersionUID = 1L;
    public static final IndexedStringListSerializer instance = new IndexedStringListSerializer();

    protected IndexedStringListSerializer() {
        super(List.class);
    }

    public IndexedStringListSerializer(IndexedStringListSerializer indexedStringListSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        super(indexedStringListSerializer, jsonSerializer, bl);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, Boolean bl) {
        return new IndexedStringListSerializer(this, jsonSerializer, bl);
    }

    @Override
    protected JsonNode contentSchema() {
        return this.createSchemaNode("string", true);
    }

    @Override
    protected void acceptContentVisitor(JsonArrayFormatVisitor jsonArrayFormatVisitor) throws JsonMappingException {
        jsonArrayFormatVisitor.itemsFormat(JsonFormatTypes.STRING);
    }

    @Override
    public void serialize(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n = list.size();
        if (n == 1 && (this._unwrapSingle == null && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this._serializeUnwrapped(list, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(n);
        if (this._serializer == null) {
            this.serializeContents(list, jsonGenerator, serializerProvider, n);
        } else {
            this.serializeUsingCustom(list, jsonGenerator, serializerProvider, n);
        }
        jsonGenerator.writeEndArray();
    }

    private final void _serializeUnwrapped(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._serializer == null) {
            this.serializeContents(list, jsonGenerator, serializerProvider, 1);
        } else {
            this.serializeUsingCustom(list, jsonGenerator, serializerProvider, 1);
        }
    }

    @Override
    public void serializeWithType(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        int n = list.size();
        typeSerializer.writeTypePrefixForArray(list, jsonGenerator);
        if (this._serializer == null) {
            this.serializeContents(list, jsonGenerator, serializerProvider, n);
        } else {
            this.serializeUsingCustom(list, jsonGenerator, serializerProvider, n);
        }
        typeSerializer.writeTypeSuffixForArray(list, jsonGenerator);
    }

    private final void serializeContents(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, int n) throws IOException {
        int n2;
        try {
            for (n2 = 0; n2 < n; ++n2) {
                String string = list.get(n2);
                if (string == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                jsonGenerator.writeString(string);
            }
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, list, n2);
        }
    }

    private final void serializeUsingCustom(List<String> list, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, int n) throws IOException {
        int n2 = 0;
        try {
            JsonSerializer jsonSerializer = this._serializer;
            for (n2 = 0; n2 < n; ++n2) {
                String string = list.get(n2);
                if (string == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                jsonSerializer.serialize(string, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, list, n2);
        }
    }
}

