/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.util.Annotations;
import java.io.Serializable;

public abstract class VirtualBeanPropertyWriter
extends BeanPropertyWriter
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected VirtualBeanPropertyWriter(BeanPropertyDefinition beanPropertyDefinition, Annotations annotations, JavaType javaType) {
        this(beanPropertyDefinition, annotations, javaType, null, null, null, beanPropertyDefinition.findInclusion());
    }

    protected VirtualBeanPropertyWriter() {
    }

    protected VirtualBeanPropertyWriter(BeanPropertyDefinition beanPropertyDefinition, Annotations annotations, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JavaType javaType2, JsonInclude.Value value) {
        super(beanPropertyDefinition, beanPropertyDefinition.getPrimaryMember(), annotations, javaType, jsonSerializer, typeSerializer, javaType2, VirtualBeanPropertyWriter._suppressNulls(value), VirtualBeanPropertyWriter._suppressableValue(value));
    }

    protected VirtualBeanPropertyWriter(VirtualBeanPropertyWriter virtualBeanPropertyWriter) {
        super(virtualBeanPropertyWriter);
    }

    protected VirtualBeanPropertyWriter(VirtualBeanPropertyWriter virtualBeanPropertyWriter, PropertyName propertyName) {
        super((BeanPropertyWriter)virtualBeanPropertyWriter, propertyName);
    }

    protected static boolean _suppressNulls(JsonInclude.Value value) {
        if (value == null) {
            return false;
        }
        JsonInclude.Include include = value.getValueInclusion();
        return include != JsonInclude.Include.ALWAYS && include != JsonInclude.Include.USE_DEFAULTS;
    }

    protected static Object _suppressableValue(JsonInclude.Value value) {
        if (value == null) {
            return false;
        }
        JsonInclude.Include include = value.getValueInclusion();
        if (include == JsonInclude.Include.ALWAYS || include == JsonInclude.Include.NON_NULL || include == JsonInclude.Include.USE_DEFAULTS) {
            return null;
        }
        return MARKER_FOR_EMPTY;
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    protected abstract Object value(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    public abstract VirtualBeanPropertyWriter withConfig(MapperConfig<?> var1, AnnotatedClass var2, BeanPropertyDefinition var3, JavaType var4);

    @Override
    public void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        Class<?> clazz;
        PropertySerializerMap propertySerializerMap;
        Object object2 = this.value(object, jsonGenerator, serializerProvider);
        if (object2 == null) {
            if (this._nullSerializer != null) {
                jsonGenerator.writeFieldName(this._name);
                this._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._serializer;
        if (jsonSerializer == null && (jsonSerializer = (propertySerializerMap = this._dynamicSerializers).serializerFor(clazz = object2.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? jsonSerializer.isEmpty(serializerProvider, object2) : this._suppressableValue.equals(object2))) {
            return;
        }
        if (object2 == object && this._handleSelfReference(object, jsonGenerator, serializerProvider, jsonSerializer)) {
            return;
        }
        jsonGenerator.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        } else {
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsElement(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        Class<?> clazz;
        PropertySerializerMap propertySerializerMap;
        Object object2 = this.value(object, jsonGenerator, serializerProvider);
        if (object2 == null) {
            if (this._nullSerializer != null) {
                this._nullSerializer.serialize(null, jsonGenerator, serializerProvider);
            } else {
                jsonGenerator.writeNull();
            }
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._serializer;
        if (jsonSerializer == null && (jsonSerializer = (propertySerializerMap = this._dynamicSerializers).serializerFor(clazz = object2.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (jsonSerializer.isEmpty(serializerProvider, object2)) {
                    this.serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                    return;
                }
            } else if (this._suppressableValue.equals(object2)) {
                this.serializeAsPlaceholder(object, jsonGenerator, serializerProvider);
                return;
            }
        }
        if (object2 == object && this._handleSelfReference(object, jsonGenerator, serializerProvider, jsonSerializer)) {
            return;
        }
        if (this._typeSerializer == null) {
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
        } else {
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._typeSerializer);
        }
    }
}

