/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.ConfigOverride;
import com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.LinkedNode;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.TimeZone;

public final class DeserializationConfig
extends MapperConfigBase<DeserializationFeature, DeserializationConfig>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final LinkedNode<DeserializationProblemHandler> _problemHandlers;
    protected final JsonNodeFactory _nodeFactory;
    protected final int _deserFeatures;
    protected final int _parserFeatures;
    protected final int _parserFeaturesToChange;
    protected final int _formatReadFeatures;
    protected final int _formatReadFeaturesToChange;

    public DeserializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, configOverrides);
        this._deserFeatures = DeserializationConfig.collectFeatureDefaults(DeserializationFeature.class);
        this._nodeFactory = JsonNodeFactory.instance;
        this._problemHandlers = null;
        this._parserFeatures = 0;
        this._parserFeaturesToChange = 0;
        this._formatReadFeatures = 0;
        this._formatReadFeaturesToChange = 0;
    }

    @Deprecated
    public DeserializationConfig(BaseSettings baseSettings, SubtypeResolver subtypeResolver, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup) {
        this(baseSettings, subtypeResolver, simpleMixInResolver, rootNameLookup, null);
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, int n, int n2, int n3, int n4, int n5, int n6) {
        super(deserializationConfig, n);
        this._deserFeatures = n2;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._parserFeatures = n3;
        this._parserFeaturesToChange = n4;
        this._formatReadFeatures = n5;
        this._formatReadFeaturesToChange = n6;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, SubtypeResolver subtypeResolver) {
        super(deserializationConfig, subtypeResolver);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, BaseSettings baseSettings) {
        super(deserializationConfig, baseSettings);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, JsonNodeFactory jsonNodeFactory) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = jsonNodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, LinkedNode<DeserializationProblemHandler> linkedNode) {
        super(deserializationConfig);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = linkedNode;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, PropertyName propertyName) {
        super(deserializationConfig, propertyName);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    private DeserializationConfig(DeserializationConfig deserializationConfig, Class<?> clazz) {
        super(deserializationConfig, clazz);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected DeserializationConfig(DeserializationConfig deserializationConfig, ContextAttributes contextAttributes) {
        super(deserializationConfig, contextAttributes);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected DeserializationConfig(DeserializationConfig deserializationConfig, SimpleMixInResolver simpleMixInResolver) {
        super(deserializationConfig, simpleMixInResolver);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected DeserializationConfig(DeserializationConfig deserializationConfig, SimpleMixInResolver simpleMixInResolver, RootNameLookup rootNameLookup, ConfigOverrides configOverrides) {
        super(deserializationConfig, simpleMixInResolver, rootNameLookup, configOverrides);
        this._deserFeatures = deserializationConfig._deserFeatures;
        this._problemHandlers = deserializationConfig._problemHandlers;
        this._nodeFactory = deserializationConfig._nodeFactory;
        this._parserFeatures = deserializationConfig._parserFeatures;
        this._parserFeaturesToChange = deserializationConfig._parserFeaturesToChange;
        this._formatReadFeatures = deserializationConfig._formatReadFeatures;
        this._formatReadFeaturesToChange = deserializationConfig._formatReadFeaturesToChange;
    }

    protected BaseSettings getBaseSettings() {
        return this._base;
    }

    @Override
    public DeserializationConfig with(MapperFeature ... mapperFeatureArray) {
        int n = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            n |= mapperFeature.getMask();
        }
        return n == this._mapperFeatures ? this : new DeserializationConfig(this, n, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    @Override
    public DeserializationConfig without(MapperFeature ... mapperFeatureArray) {
        int n = this._mapperFeatures;
        for (MapperFeature mapperFeature : mapperFeatureArray) {
            n &= ~mapperFeature.getMask();
        }
        return n == this._mapperFeatures ? this : new DeserializationConfig(this, n, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    @Override
    public DeserializationConfig with(MapperFeature mapperFeature, boolean bl) {
        int n = bl ? this._mapperFeatures | mapperFeature.getMask() : this._mapperFeatures & ~mapperFeature.getMask();
        return n == this._mapperFeatures ? this : new DeserializationConfig(this, n, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    @Override
    public DeserializationConfig with(ClassIntrospector classIntrospector) {
        return this._withBase(this._base.withClassIntrospector(classIntrospector));
    }

    @Override
    public DeserializationConfig with(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withAnnotationIntrospector(annotationIntrospector));
    }

    @Override
    public DeserializationConfig with(VisibilityChecker<?> visibilityChecker) {
        return this._withBase(this._base.withVisibilityChecker(visibilityChecker));
    }

    @Override
    public DeserializationConfig withVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
        return this._withBase(this._base.withVisibility(propertyAccessor, visibility));
    }

    @Override
    public DeserializationConfig with(TypeResolverBuilder<?> typeResolverBuilder) {
        return this._withBase(this._base.withTypeResolverBuilder(typeResolverBuilder));
    }

    @Override
    public DeserializationConfig with(SubtypeResolver subtypeResolver) {
        return this._subtypeResolver == subtypeResolver ? this : new DeserializationConfig(this, subtypeResolver);
    }

    @Override
    public DeserializationConfig with(PropertyNamingStrategy propertyNamingStrategy) {
        return this._withBase(this._base.withPropertyNamingStrategy(propertyNamingStrategy));
    }

    @Override
    public DeserializationConfig withRootName(PropertyName propertyName) {
        if (propertyName == null ? this._rootName == null : propertyName.equals(this._rootName)) {
            return this;
        }
        return new DeserializationConfig(this, propertyName);
    }

    @Override
    public DeserializationConfig with(TypeFactory typeFactory) {
        return this._withBase(this._base.withTypeFactory(typeFactory));
    }

    @Override
    public DeserializationConfig with(DateFormat dateFormat) {
        return this._withBase(this._base.withDateFormat(dateFormat));
    }

    @Override
    public DeserializationConfig with(HandlerInstantiator handlerInstantiator) {
        return this._withBase(this._base.withHandlerInstantiator(handlerInstantiator));
    }

    @Override
    public DeserializationConfig withInsertedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withInsertedAnnotationIntrospector(annotationIntrospector));
    }

    @Override
    public DeserializationConfig withAppendedAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        return this._withBase(this._base.withAppendedAnnotationIntrospector(annotationIntrospector));
    }

    @Override
    public DeserializationConfig withView(Class<?> clazz) {
        return this._view == clazz ? this : new DeserializationConfig(this, clazz);
    }

    @Override
    public DeserializationConfig with(Locale locale) {
        return this._withBase(this._base.with(locale));
    }

    @Override
    public DeserializationConfig with(TimeZone timeZone) {
        return this._withBase(this._base.with(timeZone));
    }

    @Override
    public DeserializationConfig with(Base64Variant base64Variant) {
        return this._withBase(this._base.with(base64Variant));
    }

    @Override
    public DeserializationConfig with(ContextAttributes contextAttributes) {
        return contextAttributes == this._attributes ? this : new DeserializationConfig(this, contextAttributes);
    }

    private final DeserializationConfig _withBase(BaseSettings baseSettings) {
        return this._base == baseSettings ? this : new DeserializationConfig(this, baseSettings);
    }

    public DeserializationConfig with(DeserializationFeature deserializationFeature) {
        int n = this._deserFeatures | deserializationFeature.getMask();
        return n == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig with(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        int n = this._deserFeatures | deserializationFeature.getMask();
        for (DeserializationFeature deserializationFeature2 : deserializationFeatureArray) {
            n |= deserializationFeature2.getMask();
        }
        return n == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig withFeatures(DeserializationFeature ... deserializationFeatureArray) {
        int n = this._deserFeatures;
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            n |= deserializationFeature.getMask();
        }
        return n == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig without(DeserializationFeature deserializationFeature) {
        int n = this._deserFeatures & ~deserializationFeature.getMask();
        return n == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig without(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        int n = this._deserFeatures & ~deserializationFeature.getMask();
        for (DeserializationFeature deserializationFeature2 : deserializationFeatureArray) {
            n &= ~deserializationFeature2.getMask();
        }
        return n == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig withoutFeatures(DeserializationFeature ... deserializationFeatureArray) {
        int n = this._deserFeatures;
        for (DeserializationFeature deserializationFeature : deserializationFeatureArray) {
            n &= ~deserializationFeature.getMask();
        }
        return n == this._deserFeatures ? this : new DeserializationConfig(this, this._mapperFeatures, n, this._parserFeatures, this._parserFeaturesToChange, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig with(JsonParser.Feature feature) {
        int n = this._parserFeatures | feature.getMask();
        int n2 = this._parserFeaturesToChange | feature.getMask();
        return this._parserFeatures == n && this._parserFeaturesToChange == n2 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, n, n2, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig withFeatures(JsonParser.Feature ... featureArray) {
        int n = this._parserFeatures;
        int n2 = this._parserFeaturesToChange;
        for (JsonParser.Feature feature : featureArray) {
            int n3 = feature.getMask();
            n |= n3;
            n2 |= n3;
        }
        return this._parserFeatures == n && this._parserFeaturesToChange == n2 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, n, n2, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig without(JsonParser.Feature feature) {
        int n = this._parserFeatures & ~feature.getMask();
        int n2 = this._parserFeaturesToChange | feature.getMask();
        return this._parserFeatures == n && this._parserFeaturesToChange == n2 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, n, n2, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig withoutFeatures(JsonParser.Feature ... featureArray) {
        int n = this._parserFeatures;
        int n2 = this._parserFeaturesToChange;
        for (JsonParser.Feature feature : featureArray) {
            int n3 = feature.getMask();
            n &= ~n3;
            n2 |= n3;
        }
        return this._parserFeatures == n && this._parserFeaturesToChange == n2 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, n, n2, this._formatReadFeatures, this._formatReadFeaturesToChange);
    }

    public DeserializationConfig with(FormatFeature formatFeature) {
        int n = this._formatReadFeatures | formatFeature.getMask();
        int n2 = this._formatReadFeaturesToChange | formatFeature.getMask();
        return this._formatReadFeatures == n && this._formatReadFeaturesToChange == n2 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n, n2);
    }

    public DeserializationConfig withFeatures(FormatFeature ... formatFeatureArray) {
        int n = this._formatReadFeatures;
        int n2 = this._formatReadFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n3 = formatFeature.getMask();
            n |= n3;
            n2 |= n3;
        }
        return this._formatReadFeatures == n && this._formatReadFeaturesToChange == n2 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n, n2);
    }

    public DeserializationConfig without(FormatFeature formatFeature) {
        int n = this._formatReadFeatures & ~formatFeature.getMask();
        int n2 = this._formatReadFeaturesToChange | formatFeature.getMask();
        return this._formatReadFeatures == n && this._formatReadFeaturesToChange == n2 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n, n2);
    }

    public DeserializationConfig withoutFeatures(FormatFeature ... formatFeatureArray) {
        int n = this._formatReadFeatures;
        int n2 = this._formatReadFeaturesToChange;
        for (FormatFeature formatFeature : formatFeatureArray) {
            int n3 = formatFeature.getMask();
            n &= ~n3;
            n2 |= n3;
        }
        return this._formatReadFeatures == n && this._formatReadFeaturesToChange == n2 ? this : new DeserializationConfig(this, this._mapperFeatures, this._deserFeatures, this._parserFeatures, this._parserFeaturesToChange, n, n2);
    }

    public DeserializationConfig with(JsonNodeFactory jsonNodeFactory) {
        if (this._nodeFactory == jsonNodeFactory) {
            return this;
        }
        return new DeserializationConfig(this, jsonNodeFactory);
    }

    public DeserializationConfig withHandler(DeserializationProblemHandler deserializationProblemHandler) {
        if (LinkedNode.contains(this._problemHandlers, deserializationProblemHandler)) {
            return this;
        }
        return new DeserializationConfig(this, new LinkedNode<DeserializationProblemHandler>(deserializationProblemHandler, this._problemHandlers));
    }

    public DeserializationConfig withNoProblemHandlers() {
        if (this._problemHandlers == null) {
            return this;
        }
        return new DeserializationConfig(this, (LinkedNode<DeserializationProblemHandler>)null);
    }

    public void initialize(JsonParser jsonParser) {
        if (this._parserFeaturesToChange != 0) {
            jsonParser.overrideStdFeatures(this._parserFeatures, this._parserFeaturesToChange);
        }
        if (this._formatReadFeaturesToChange != 0) {
            jsonParser.overrideFormatFeatures(this._formatReadFeatures, this._formatReadFeaturesToChange);
        }
    }

    @Override
    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(MapperFeature.USE_ANNOTATIONS)) {
            return super.getAnnotationIntrospector();
        }
        return NopAnnotationIntrospector.instance;
    }

    @Override
    public BeanDescription introspectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forClassAnnotations(this, javaType, this);
    }

    @Override
    public BeanDescription introspectDirectClassAnnotations(JavaType javaType) {
        return this.getClassIntrospector().forDirectClassAnnotations(this, javaType, this);
    }

    @Override
    public JsonInclude.Value getDefaultPropertyInclusion() {
        return EMPTY_INCLUDE;
    }

    @Override
    public JsonInclude.Value getDefaultPropertyInclusion(Class<?> clazz) {
        JsonInclude.Value value;
        ConfigOverride configOverride = this.findConfigOverride(clazz);
        if (configOverride != null && (value = configOverride.getInclude()) != null) {
            return value;
        }
        return EMPTY_INCLUDE;
    }

    @Override
    public boolean useRootWrapping() {
        if (this._rootName != null) {
            return !this._rootName.isEmpty();
        }
        return this.isEnabled(DeserializationFeature.UNWRAP_ROOT_VALUE);
    }

    public final boolean isEnabled(DeserializationFeature deserializationFeature) {
        return (this._deserFeatures & deserializationFeature.getMask()) != 0;
    }

    public final boolean isEnabled(JsonParser.Feature feature, JsonFactory jsonFactory) {
        int n = feature.getMask();
        if ((this._parserFeaturesToChange & n) != 0) {
            return (this._parserFeatures & feature.getMask()) != 0;
        }
        return jsonFactory.isEnabled(feature);
    }

    public final boolean hasDeserializationFeatures(int n) {
        return (this._deserFeatures & n) == n;
    }

    public final boolean hasSomeOfFeatures(int n) {
        return (this._deserFeatures & n) != 0;
    }

    public final int getDeserializationFeatures() {
        return this._deserFeatures;
    }

    public LinkedNode<DeserializationProblemHandler> getProblemHandlers() {
        return this._problemHandlers;
    }

    public final JsonNodeFactory getNodeFactory() {
        return this._nodeFactory;
    }

    public <T extends BeanDescription> T introspect(JavaType javaType) {
        return (T)this.getClassIntrospector().forDeserialization(this, javaType, this);
    }

    public <T extends BeanDescription> T introspectForCreation(JavaType javaType) {
        return (T)this.getClassIntrospector().forCreation(this, javaType, this);
    }

    public <T extends BeanDescription> T introspectForBuilder(JavaType javaType) {
        return (T)this.getClassIntrospector().forDeserializationWithBuilder(this, javaType, this);
    }

    public TypeDeserializer findTypeDeserializer(JavaType javaType) throws JsonMappingException {
        BeanDescription beanDescription = this.introspectClassAnnotations(javaType.getRawClass());
        AnnotatedClass annotatedClass = beanDescription.getClassInfo();
        TypeResolverBuilder<?> typeResolverBuilder = this.getAnnotationIntrospector().findTypeResolver(this, annotatedClass, javaType);
        Collection<NamedType> collection = null;
        if (typeResolverBuilder == null) {
            typeResolverBuilder = this.getDefaultTyper(javaType);
            if (typeResolverBuilder == null) {
                return null;
            }
        } else {
            collection = this.getSubtypeResolver().collectAndResolveSubtypesByTypeId(this, annotatedClass);
        }
        return typeResolverBuilder.buildTypeDeserializer(this, javaType, collection);
    }
}

