/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.BitSet;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    protected static final int DEFAULT_T_SIZE = 64;
    protected static final int MAX_T_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 100;
    static final CharsToNameCanonicalizer sBootstrapSymbolTable = new CharsToNameCanonicalizer();
    protected CharsToNameCanonicalizer _parent;
    private final int _hashSeed;
    protected final int _flags;
    protected boolean _canonicalize;
    protected String[] _symbols;
    protected Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _dirty;
    protected BitSet _overflows;

    public static CharsToNameCanonicalizer createRoot() {
        long l = System.currentTimeMillis();
        int n = (int)l + (int)(l >>> 32) | 1;
        return CharsToNameCanonicalizer.createRoot(n);
    }

    protected static CharsToNameCanonicalizer createRoot(int n) {
        return sBootstrapSymbolTable.makeOrphan(n);
    }

    private CharsToNameCanonicalizer() {
        this._canonicalize = true;
        this._flags = -1;
        this._dirty = true;
        this._hashSeed = 0;
        this._longestCollisionList = 0;
        this.initTables(64);
    }

    private void initTables(int n) {
        this._symbols = new String[n];
        this._buckets = new Bucket[n >> 1];
        this._indexMask = n - 1;
        this._size = 0;
        this._longestCollisionList = 0;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n);
    }

    private static int _thresholdSize(int n) {
        return n - (n >> 2);
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, int n, String[] stringArray, Bucket[] bucketArray, int n2, int n3, int n4) {
        this._parent = charsToNameCanonicalizer;
        this._flags = n;
        this._canonicalize = JsonFactory.Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n);
        this._symbols = stringArray;
        this._buckets = bucketArray;
        this._size = n2;
        this._hashSeed = n3;
        int n5 = stringArray.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n5);
        this._indexMask = n5 - 1;
        this._longestCollisionList = n4;
        this._dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharsToNameCanonicalizer makeChild(int n) {
        int n2;
        int n3;
        int n4;
        Bucket[] bucketArray;
        String[] stringArray;
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        synchronized (charsToNameCanonicalizer) {
            stringArray = this._symbols;
            bucketArray = this._buckets;
            n4 = this._size;
            n3 = this._hashSeed;
            n2 = this._longestCollisionList;
        }
        return new CharsToNameCanonicalizer(this, n, stringArray, bucketArray, n4, n3, n2);
    }

    private CharsToNameCanonicalizer makeOrphan(int n) {
        return new CharsToNameCanonicalizer(null, -1, this._symbols, this._buckets, this._size, n, this._longestCollisionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeChild(CharsToNameCanonicalizer charsToNameCanonicalizer) {
        if (charsToNameCanonicalizer.size() > 12000) {
            CharsToNameCanonicalizer charsToNameCanonicalizer2 = this;
            synchronized (charsToNameCanonicalizer2) {
                this.initTables(256);
                this._dirty = false;
            }
        }
        if (charsToNameCanonicalizer.size() <= this.size()) {
            return;
        }
        CharsToNameCanonicalizer charsToNameCanonicalizer3 = this;
        synchronized (charsToNameCanonicalizer3) {
            this._symbols = charsToNameCanonicalizer._symbols;
            this._buckets = charsToNameCanonicalizer._buckets;
            this._size = charsToNameCanonicalizer._size;
            this._sizeThreshold = charsToNameCanonicalizer._sizeThreshold;
            this._indexMask = charsToNameCanonicalizer._indexMask;
            this._longestCollisionList = charsToNameCanonicalizer._longestCollisionList;
            this._dirty = false;
        }
    }

    public void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null && this._canonicalize) {
            this._parent.mergeChild(this);
            this._dirty = false;
        }
    }

    public int size() {
        return this._size;
    }

    public int bucketCount() {
        return this._symbols.length;
    }

    public boolean maybeDirty() {
        return this._dirty;
    }

    public int hashSeed() {
        return this._hashSeed;
    }

    public int collisionCount() {
        int n = 0;
        for (Bucket bucket : this._buckets) {
            if (bucket == null) continue;
            n += bucket.length;
        }
        return n;
    }

    public int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public String findSymbol(char[] cArray, int n, int n2, int n3) {
        if (n2 < 1) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(cArray, n, n2);
        }
        int n4 = this._hashToIndex(n3);
        String string = this._symbols[n4];
        if (string != null) {
            Bucket bucket;
            if (string.length() == n2) {
                int n5 = 0;
                while (string.charAt(n5) == cArray[n + n5]) {
                    if (++n5 != n2) continue;
                    return string;
                }
            }
            if ((bucket = this._buckets[n4 >> 1]) != null) {
                string = bucket.has(cArray, n, n2);
                if (string != null) {
                    return string;
                }
                string = this._findSymbol2(cArray, n, n2, bucket.next);
                if (string != null) {
                    return string;
                }
            }
        }
        return this._addSymbol(cArray, n, n2, n3, n4);
    }

    private String _findSymbol2(char[] cArray, int n, int n2, Bucket bucket) {
        while (bucket != null) {
            String string = bucket.has(cArray, n, n2);
            if (string != null) {
                return string;
            }
            bucket = bucket.next;
        }
        return null;
    }

    private String _addSymbol(char[] cArray, int n, int n2, int n3, int n4) {
        if (!this._dirty) {
            this.copyArrays();
            this._dirty = true;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            n4 = this._hashToIndex(this.calcHash(cArray, n, n2));
        }
        String string = new String(cArray, n, n2);
        if (JsonFactory.Feature.INTERN_FIELD_NAMES.enabledIn(this._flags)) {
            string = InternCache.instance.intern(string);
        }
        ++this._size;
        if (this._symbols[n4] == null) {
            this._symbols[n4] = string;
        } else {
            int n5 = n4 >> 1;
            Bucket bucket = new Bucket(string, this._buckets[n5]);
            int n6 = bucket.length;
            if (n6 > 100) {
                this._handleSpillOverflow(n5, bucket);
            } else {
                this._buckets[n5] = bucket;
                this._longestCollisionList = Math.max(n6, this._longestCollisionList);
            }
        }
        return string;
    }

    private void _handleSpillOverflow(int n, Bucket bucket) {
        if (this._overflows == null) {
            this._overflows = new BitSet();
            this._overflows.set(n);
        } else if (this._overflows.get(n)) {
            if (JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(this._flags)) {
                this.reportTooManyCollisions(100);
            }
            this._canonicalize = false;
        } else {
            this._overflows.set(n);
        }
        this._symbols[n + n] = bucket.symbol;
        this._buckets[n] = null;
        this._size -= bucket.length;
        this._longestCollisionList = -1;
    }

    public int _hashToIndex(int n) {
        n += n >>> 15;
        n ^= n << 7;
        n += n >>> 3;
        return n & this._indexMask;
    }

    public int calcHash(char[] cArray, int n, int n2) {
        int n3 = this._hashSeed;
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            n3 = n3 * 33 + cArray[i];
        }
        return n3 == 0 ? 1 : n3;
    }

    public int calcHash(String string) {
        int n = string.length();
        int n2 = this._hashSeed;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 33 + string.charAt(i);
        }
        return n2 == 0 ? 1 : n2;
    }

    private void copyArrays() {
        String[] stringArray = this._symbols;
        this._symbols = Arrays.copyOf(stringArray, stringArray.length);
        Bucket[] bucketArray = this._buckets;
        this._buckets = Arrays.copyOf(bucketArray, bucketArray.length);
    }

    private void rehash() {
        int n;
        Object object;
        int n2;
        int n3 = this._symbols.length;
        int n4 = n3 + n3;
        if (n4 > 65536) {
            this._size = 0;
            this._canonicalize = false;
            this._symbols = new String[64];
            this._buckets = new Bucket[32];
            this._indexMask = 63;
            this._dirty = true;
            return;
        }
        String[] stringArray = this._symbols;
        Bucket[] bucketArray = this._buckets;
        this._symbols = new String[n4];
        this._buckets = new Bucket[n4 >> 1];
        this._indexMask = n4 - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n4);
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            Bucket bucket;
            object = stringArray[n2];
            if (object == null) continue;
            ++n5;
            int n7 = this._hashToIndex(this.calcHash((String)object));
            if (this._symbols[n7] == null) {
                this._symbols[n7] = object;
                continue;
            }
            n = n7 >> 1;
            this._buckets[n] = bucket = new Bucket((String)object, this._buckets[n]);
            n6 = Math.max(n6, bucket.length);
        }
        n3 >>= 1;
        for (n2 = 0; n2 < n3; ++n2) {
            object = bucketArray[n2];
            while (object != null) {
                ++n5;
                String string = ((Bucket)object).symbol;
                n = this._hashToIndex(this.calcHash(string));
                if (this._symbols[n] == null) {
                    this._symbols[n] = string;
                } else {
                    Bucket bucket;
                    int n8 = n >> 1;
                    this._buckets[n8] = bucket = new Bucket(string, this._buckets[n8]);
                    n6 = Math.max(n6, bucket.length);
                }
                object = ((Bucket)object).next;
            }
        }
        this._longestCollisionList = n6;
        this._overflows = null;
        if (n5 != this._size) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this._size + " entries; now have " + n5 + ".");
        }
    }

    protected void reportTooManyCollisions(int n) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n + " -- suspect a DoS attack based on hash collisions");
    }

    static final class Bucket {
        public final String symbol;
        public final Bucket next;
        public final int length;

        public Bucket(String string, Bucket bucket) {
            this.symbol = string;
            this.next = bucket;
            this.length = bucket == null ? 1 : bucket.length + 1;
        }

        public String has(char[] cArray, int n, int n2) {
            if (this.symbol.length() != n2) {
                return null;
            }
            int n3 = 0;
            do {
                if (this.symbol.charAt(n3) == cArray[n + n3]) continue;
                return null;
            } while (++n3 < n2);
            return this.symbol;
        }
    }
}

