/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.filter;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.filter.TokenFilterContext;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FilteringParserDelegate
extends JsonParserDelegate {
    protected TokenFilter rootFilter;
    protected boolean _allowMultipleMatches;
    protected boolean _includePath;
    @Deprecated
    protected boolean _includeImmediateParent;
    protected JsonToken _currToken;
    protected JsonToken _lastClearedToken;
    protected TokenFilterContext _headContext;
    protected TokenFilterContext _exposedContext;
    protected TokenFilter _itemFilter;
    protected int _matchCount;

    public FilteringParserDelegate(JsonParser jsonParser, TokenFilter tokenFilter, boolean bl, boolean bl2) {
        super(jsonParser);
        this.rootFilter = tokenFilter;
        this._itemFilter = tokenFilter;
        this._headContext = TokenFilterContext.createRootContext(tokenFilter);
        this._includePath = bl;
        this._allowMultipleMatches = bl2;
    }

    public TokenFilter getFilter() {
        return this.rootFilter;
    }

    public int getMatchCount() {
        return this._matchCount;
    }

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    public JsonToken currentToken() {
        return this._currToken;
    }

    @Override
    public final int getCurrentTokenId() {
        JsonToken jsonToken = this._currToken;
        return jsonToken == null ? 0 : jsonToken.id();
    }

    @Override
    public final int currentTokenId() {
        JsonToken jsonToken = this._currToken;
        return jsonToken == null ? 0 : jsonToken.id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public boolean hasTokenId(int n) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return 0 == n;
        }
        return jsonToken.id() == n;
    }

    @Override
    public final boolean hasToken(JsonToken jsonToken) {
        return this._currToken == jsonToken;
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        return this._currToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedStartObjectToken() {
        return this._currToken == JsonToken.START_OBJECT;
    }

    @Override
    public JsonLocation getCurrentLocation() {
        return this.delegate.getCurrentLocation();
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._filterContext();
    }

    @Override
    public String getCurrentName() throws IOException {
        JsonStreamContext jsonStreamContext = this._filterContext();
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            JsonStreamContext jsonStreamContext2 = jsonStreamContext.getParent();
            return jsonStreamContext2 == null ? null : jsonStreamContext2.getCurrentName();
        }
        return jsonStreamContext.getCurrentName();
    }

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public void overrideCurrentName(String string) {
        throw new UnsupportedOperationException("Can not currently override name during filtering read");
    }

    @Override
    public JsonToken nextToken() throws IOException {
        JsonToken jsonToken;
        block32: {
            TokenFilterContext tokenFilterContext;
            if (!this._allowMultipleMatches && this._currToken != null && this._exposedContext == null) {
                if (this._currToken.isStructEnd() && this._headContext.isStartHandled()) {
                    this._currToken = null;
                    return null;
                }
                if (this._currToken.isScalarValue() && !this._headContext.isStartHandled() && !this._includePath && this._itemFilter == TokenFilter.INCLUDE_ALL) {
                    this._currToken = null;
                    return null;
                }
            }
            if ((tokenFilterContext = this._exposedContext) != null) {
                do {
                    if ((jsonToken = tokenFilterContext.nextTokenToRead()) != null) {
                        this._currToken = jsonToken;
                        return jsonToken;
                    }
                    if (tokenFilterContext == this._headContext) {
                        this._exposedContext = null;
                        if (tokenFilterContext.inArray()) {
                            this._currToken = jsonToken = this.delegate.getCurrentToken();
                            return jsonToken;
                        }
                        break block32;
                    }
                    this._exposedContext = tokenFilterContext = this._headContext.findChildOf(tokenFilterContext);
                } while (tokenFilterContext != null);
                throw this._constructError("Unexpected problem: chain of filtered context broken");
            }
        }
        if ((jsonToken = this.delegate.nextToken()) == null) {
            this._currToken = jsonToken;
            return this._currToken;
        }
        switch (jsonToken.id()) {
            case 3: {
                TokenFilter tokenFilter = this._itemFilter;
                if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (tokenFilter == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if ((tokenFilter = this._headContext.checkValue(tokenFilter)) == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if (tokenFilter != TokenFilter.INCLUDE_ALL) {
                    tokenFilter = tokenFilter.filterStartArray();
                }
                this._itemFilter = tokenFilter;
                if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                this._headContext = this._headContext.createChildArrayContext(tokenFilter, false);
                if (!this._includePath || (jsonToken = this._nextTokenWithBuffering(this._headContext)) == null) break;
                this._currToken = jsonToken;
                return jsonToken;
            }
            case 1: {
                TokenFilter tokenFilter = this._itemFilter;
                if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (tokenFilter == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if ((tokenFilter = this._headContext.checkValue(tokenFilter)) == null) {
                    this.delegate.skipChildren();
                    break;
                }
                if (tokenFilter != TokenFilter.INCLUDE_ALL) {
                    tokenFilter = tokenFilter.filterStartObject();
                }
                this._itemFilter = tokenFilter;
                if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                    this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                this._headContext = this._headContext.createChildObjectContext(tokenFilter, false);
                if (!this._includePath || (jsonToken = this._nextTokenWithBuffering(this._headContext)) == null) break;
                this._currToken = jsonToken;
                return jsonToken;
            }
            case 2: 
            case 4: {
                boolean bl = this._headContext.isStartHandled();
                TokenFilter tokenFilter = this._headContext.getFilter();
                if (tokenFilter != null && tokenFilter != TokenFilter.INCLUDE_ALL) {
                    tokenFilter.filterFinishArray();
                }
                this._headContext = this._headContext.getParent();
                this._itemFilter = this._headContext.getFilter();
                if (!bl) break;
                this._currToken = jsonToken;
                return this._currToken;
            }
            case 5: {
                String string = this.delegate.getCurrentName();
                TokenFilter tokenFilter = this._headContext.setFieldName(string);
                if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                    this._itemFilter = tokenFilter;
                    if (!this._includePath && this._includeImmediateParent && !this._headContext.isStartHandled()) {
                        jsonToken = this._headContext.nextTokenToRead();
                        this._exposedContext = this._headContext;
                    }
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (tokenFilter == null) {
                    this.delegate.nextToken();
                    this.delegate.skipChildren();
                    break;
                }
                if ((tokenFilter = tokenFilter.includeProperty(string)) == null) {
                    this.delegate.nextToken();
                    this.delegate.skipChildren();
                    break;
                }
                this._itemFilter = tokenFilter;
                if (tokenFilter == TokenFilter.INCLUDE_ALL && this._includePath) {
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (!this._includePath || (jsonToken = this._nextTokenWithBuffering(this._headContext)) == null) break;
                this._currToken = jsonToken;
                return jsonToken;
            }
            default: {
                TokenFilter tokenFilter = this._itemFilter;
                if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                if (tokenFilter == null || (tokenFilter = this._headContext.checkValue(tokenFilter)) != TokenFilter.INCLUDE_ALL && (tokenFilter == null || !tokenFilter.includeValue(this.delegate))) break;
                this._currToken = jsonToken;
                return this._currToken;
            }
        }
        return this._nextToken2();
    }

    protected final JsonToken _nextToken2() throws IOException {
        JsonToken jsonToken;
        block6: while (true) {
            TokenFilter tokenFilter;
            if ((jsonToken = this.delegate.nextToken()) == null) {
                this._currToken = jsonToken;
                return this._currToken;
            }
            switch (jsonToken.id()) {
                case 3: {
                    tokenFilter = this._itemFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    if (tokenFilter == null) {
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    if ((tokenFilter = this._headContext.checkValue(tokenFilter)) == null) {
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    if (tokenFilter != TokenFilter.INCLUDE_ALL) {
                        tokenFilter = tokenFilter.filterStartArray();
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    this._headContext = this._headContext.createChildArrayContext(tokenFilter, false);
                    if (!this._includePath || (jsonToken = this._nextTokenWithBuffering(this._headContext)) == null) continue block6;
                    this._currToken = jsonToken;
                    return jsonToken;
                }
                case 1: {
                    tokenFilter = this._itemFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    if (tokenFilter == null) {
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    if ((tokenFilter = this._headContext.checkValue(tokenFilter)) == null) {
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    if (tokenFilter != TokenFilter.INCLUDE_ALL) {
                        tokenFilter = tokenFilter.filterStartObject();
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    this._headContext = this._headContext.createChildObjectContext(tokenFilter, false);
                    if (!this._includePath || (jsonToken = this._nextTokenWithBuffering(this._headContext)) == null) continue block6;
                    this._currToken = jsonToken;
                    return jsonToken;
                }
                case 2: 
                case 4: {
                    boolean bl = this._headContext.isStartHandled();
                    tokenFilter = this._headContext.getFilter();
                    if (tokenFilter != null && tokenFilter != TokenFilter.INCLUDE_ALL) {
                        tokenFilter.filterFinishArray();
                    }
                    this._headContext = this._headContext.getParent();
                    this._itemFilter = this._headContext.getFilter();
                    if (!bl) continue block6;
                    this._currToken = jsonToken;
                    return this._currToken;
                }
                case 5: {
                    String string = this.delegate.getCurrentName();
                    tokenFilter = this._headContext.setFieldName(string);
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._itemFilter = tokenFilter;
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    if (tokenFilter == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    if ((tokenFilter = tokenFilter.includeProperty(string)) == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        if (!this._includePath) continue block6;
                        this._currToken = jsonToken;
                        return this._currToken;
                    }
                    if (!this._includePath || (jsonToken = this._nextTokenWithBuffering(this._headContext)) == null) continue block6;
                    this._currToken = jsonToken;
                    return jsonToken;
                }
            }
            tokenFilter = this._itemFilter;
            if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                this._currToken = jsonToken;
                return this._currToken;
            }
            if (tokenFilter != null && ((tokenFilter = this._headContext.checkValue(tokenFilter)) == TokenFilter.INCLUDE_ALL || tokenFilter != null && tokenFilter.includeValue(this.delegate))) break;
        }
        this._currToken = jsonToken;
        return this._currToken;
    }

    protected final JsonToken _nextTokenWithBuffering(TokenFilterContext tokenFilterContext) throws IOException {
        block6: while (true) {
            TokenFilter tokenFilter;
            JsonToken jsonToken;
            if ((jsonToken = this.delegate.nextToken()) == null) {
                return jsonToken;
            }
            switch (jsonToken.id()) {
                case 3: {
                    tokenFilter = this._headContext.checkValue(this._itemFilter);
                    if (tokenFilter == null) {
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    if (tokenFilter != TokenFilter.INCLUDE_ALL) {
                        tokenFilter = tokenFilter.filterStartArray();
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildArrayContext(tokenFilter, true);
                        return this._nextBuffered(tokenFilterContext);
                    }
                    this._headContext = this._headContext.createChildArrayContext(tokenFilter, false);
                    continue block6;
                }
                case 1: {
                    tokenFilter = this._itemFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                        return jsonToken;
                    }
                    if (tokenFilter == null) {
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    if ((tokenFilter = this._headContext.checkValue(tokenFilter)) == null) {
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    if (tokenFilter != TokenFilter.INCLUDE_ALL) {
                        tokenFilter = tokenFilter.filterStartObject();
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._headContext = this._headContext.createChildObjectContext(tokenFilter, true);
                        return this._nextBuffered(tokenFilterContext);
                    }
                    this._headContext = this._headContext.createChildObjectContext(tokenFilter, false);
                    continue block6;
                }
                case 2: 
                case 4: {
                    tokenFilter = this._headContext.getFilter();
                    if (tokenFilter != null && tokenFilter != TokenFilter.INCLUDE_ALL) {
                        tokenFilter.filterFinishArray();
                    }
                    boolean bl = this._headContext == tokenFilterContext;
                    boolean bl2 = bl && this._headContext.isStartHandled();
                    this._headContext = this._headContext.getParent();
                    this._itemFilter = this._headContext.getFilter();
                    if (bl2) {
                        return jsonToken;
                    }
                    if (!bl && this._headContext != tokenFilterContext) continue block6;
                    return null;
                }
                case 5: {
                    String string = this.delegate.getCurrentName();
                    tokenFilter = this._headContext.setFieldName(string);
                    if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                        this._itemFilter = tokenFilter;
                        return this._nextBuffered(tokenFilterContext);
                    }
                    if (tokenFilter == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    if ((tokenFilter = tokenFilter.includeProperty(string)) == null) {
                        this.delegate.nextToken();
                        this.delegate.skipChildren();
                        continue block6;
                    }
                    this._itemFilter = tokenFilter;
                    if (tokenFilter != TokenFilter.INCLUDE_ALL) continue block6;
                    return this._nextBuffered(tokenFilterContext);
                }
            }
            tokenFilter = this._itemFilter;
            if (tokenFilter == TokenFilter.INCLUDE_ALL) {
                return this._nextBuffered(tokenFilterContext);
            }
            if (tokenFilter != null && ((tokenFilter = this._headContext.checkValue(tokenFilter)) == TokenFilter.INCLUDE_ALL || tokenFilter != null && tokenFilter.includeValue(this.delegate))) break;
        }
        return this._nextBuffered(tokenFilterContext);
    }

    private JsonToken _nextBuffered(TokenFilterContext tokenFilterContext) throws IOException {
        this._exposedContext = tokenFilterContext;
        TokenFilterContext tokenFilterContext2 = tokenFilterContext;
        JsonToken jsonToken = tokenFilterContext2.nextTokenToRead();
        if (jsonToken != null) {
            return jsonToken;
        }
        do {
            if (tokenFilterContext2 == this._headContext) {
                throw this._constructError("Internal error: failed to locate expected buffered tokens");
            }
            this._exposedContext = tokenFilterContext2 = this._exposedContext.findChildOf(tokenFilterContext2);
            if (tokenFilterContext2 != null) continue;
            throw this._constructError("Unexpected problem: chain of filtered context broken");
        } while ((jsonToken = this._exposedContext.nextTokenToRead()) == null);
        return jsonToken;
    }

    @Override
    public JsonToken nextValue() throws IOException {
        JsonToken jsonToken = this.nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = this.nextToken();
        }
        return jsonToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int n = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = this.nextToken()) == null) {
                return this;
            }
            if (jsonToken.isStructStart()) {
                ++n;
                continue;
            }
            if (jsonToken.isStructEnd() && --n == 0) break;
        }
        return this;
    }

    @Override
    public String getText() throws IOException {
        return this.delegate.getText();
    }

    @Override
    public boolean hasTextCharacters() {
        return this.delegate.hasTextCharacters();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        return this.delegate.getTextCharacters();
    }

    @Override
    public int getTextLength() throws IOException {
        return this.delegate.getTextLength();
    }

    @Override
    public int getTextOffset() throws IOException {
        return this.delegate.getTextOffset();
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        return this.delegate.getBigIntegerValue();
    }

    @Override
    public boolean getBooleanValue() throws IOException {
        return this.delegate.getBooleanValue();
    }

    @Override
    public byte getByteValue() throws IOException {
        return this.delegate.getByteValue();
    }

    @Override
    public short getShortValue() throws IOException {
        return this.delegate.getShortValue();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        return this.delegate.getDecimalValue();
    }

    @Override
    public double getDoubleValue() throws IOException {
        return this.delegate.getDoubleValue();
    }

    @Override
    public float getFloatValue() throws IOException {
        return this.delegate.getFloatValue();
    }

    @Override
    public int getIntValue() throws IOException {
        return this.delegate.getIntValue();
    }

    @Override
    public long getLongValue() throws IOException {
        return this.delegate.getLongValue();
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        return this.delegate.getNumberType();
    }

    @Override
    public Number getNumberValue() throws IOException {
        return this.delegate.getNumberValue();
    }

    @Override
    public int getValueAsInt() throws IOException {
        return this.delegate.getValueAsInt();
    }

    @Override
    public int getValueAsInt(int n) throws IOException {
        return this.delegate.getValueAsInt(n);
    }

    @Override
    public long getValueAsLong() throws IOException {
        return this.delegate.getValueAsLong();
    }

    @Override
    public long getValueAsLong(long l) throws IOException {
        return this.delegate.getValueAsLong(l);
    }

    @Override
    public double getValueAsDouble() throws IOException {
        return this.delegate.getValueAsDouble();
    }

    @Override
    public double getValueAsDouble(double d) throws IOException {
        return this.delegate.getValueAsDouble(d);
    }

    @Override
    public boolean getValueAsBoolean() throws IOException {
        return this.delegate.getValueAsBoolean();
    }

    @Override
    public boolean getValueAsBoolean(boolean bl) throws IOException {
        return this.delegate.getValueAsBoolean(bl);
    }

    @Override
    public String getValueAsString() throws IOException {
        return this.delegate.getValueAsString();
    }

    @Override
    public String getValueAsString(String string) throws IOException {
        return this.delegate.getValueAsString(string);
    }

    @Override
    public Object getEmbeddedObject() throws IOException {
        return this.delegate.getEmbeddedObject();
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        return this.delegate.getBinaryValue(base64Variant);
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException {
        return this.delegate.readBinaryValue(base64Variant, outputStream);
    }

    @Override
    public JsonLocation getTokenLocation() {
        return this.delegate.getTokenLocation();
    }

    protected JsonStreamContext _filterContext() {
        if (this._exposedContext != null) {
            return this._exposedContext;
        }
        return this._headContext;
    }
}

