/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public class NSDate
extends NSObject {
    private final Date date;
    private static final long EPOCH = 978307200000L;
    private static final SimpleDateFormat sdfDefault = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat sdfGnuStep = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public NSDate(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public NSDate(byte[] byArray, int n, int n2) {
        this.date = new Date(978307200000L + (long)(1000.0 * BinaryPropertyListParser.parseDouble(byArray, n, n2)));
    }

    public NSDate(String string) throws ParseException {
        this.date = NSDate.parseDateString(string);
    }

    public NSDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Date cannot be null");
        }
        this.date = date;
    }

    private static synchronized Date parseDateString(String string) throws ParseException {
        try {
            return sdfDefault.parse(string);
        }
        catch (ParseException parseException) {
            return sdfGnuStep.parse(string);
        }
    }

    private static synchronized String makeDateString(Date date) {
        return sdfDefault.format(date);
    }

    private static synchronized String makeDateStringGnuStep(Date date) {
        return sdfGnuStep.format(date);
    }

    public Date getDate() {
        return this.date;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object.getClass().equals(this.getClass()) && this.date.equals(((NSDate)object).getDate());
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    @Override
    public NSDate clone() {
        return new NSDate((Date)this.getDate().clone());
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        stringBuilder.append("<date>");
        stringBuilder.append(NSDate.makeDateString(this.date));
        stringBuilder.append("</date>");
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) throws IOException {
        binaryPropertyListWriter.write(51);
        binaryPropertyListWriter.writeDouble((double)(this.date.getTime() - 978307200000L) / 1000.0);
    }

    public String toString() {
        return this.date.toString();
    }

    @Override
    public Object toJavaObject() {
        return this.date;
    }

    @Override
    public int compareTo(NSObject nSObject) {
        Objects.requireNonNull(nSObject);
        if (nSObject == this) {
            return 0;
        }
        if (nSObject instanceof NSDate) {
            return this.getDate().compareTo(((NSDate)nSObject).getDate());
        }
        return this.getClass().getName().compareTo(nSObject.getClass().getName());
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        stringBuilder.append('\"');
        stringBuilder.append(NSDate.makeDateString(this.date));
        stringBuilder.append('\"');
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        stringBuilder.append("<*D");
        stringBuilder.append(NSDate.makeDateStringGnuStep(this.date));
        stringBuilder.append('>');
    }

    static {
        sdfDefault.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdfGnuStep.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

