/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListWriter;
import com.dd.plist.NSData;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNull;
import com.dd.plist.NSObject;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class NSArray
extends NSObject {
    private NSObject[] array;

    public NSArray(int n) {
        this.array = new NSObject[n];
    }

    public NSArray(NSObject ... nSObjectArray) {
        this.array = nSObjectArray;
    }

    public NSObject objectAtIndex(int n) {
        return this.array[n];
    }

    public void remove(int n) {
        if (n >= this.array.length || n < 0) {
            throw new ArrayIndexOutOfBoundsException("invalid index:" + n + ";the array length is " + this.array.length);
        }
        NSObject[] nSObjectArray = new NSObject[this.array.length - 1];
        System.arraycopy(this.array, 0, nSObjectArray, 0, n);
        System.arraycopy(this.array, n + 1, nSObjectArray, n, this.array.length - n - 1);
        this.array = nSObjectArray;
    }

    public void setValue(int n, Object object) {
        this.array[n] = NSObject.fromJavaObject(object);
    }

    public NSObject[] getArray() {
        return this.array;
    }

    public int count() {
        return this.array.length;
    }

    public boolean containsObject(Object object) {
        NSObject nSObject = NSObject.fromJavaObject(object);
        for (NSObject nSObject2 : this.array) {
            if (!(nSObject2 == null ? object == null : nSObject2.equals(nSObject))) continue;
            return true;
        }
        return false;
    }

    public int indexOfObject(Object object) {
        NSObject nSObject = NSObject.fromJavaObject(object);
        for (int i = 0; i < this.array.length; ++i) {
            if (!this.array[i].equals(nSObject)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfIdenticalObject(Object object) {
        NSObject nSObject = NSObject.fromJavaObject(object);
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] != nSObject) continue;
            return i;
        }
        return -1;
    }

    public NSObject lastObject() {
        return this.array[this.array.length - 1];
    }

    public NSObject[] objectsAtIndexes(int ... nArray) {
        NSObject[] nSObjectArray = new NSObject[nArray.length];
        Arrays.sort(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            nSObjectArray[i] = this.array[nArray[i]];
        }
        return nSObjectArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass().equals(NSArray.class)) {
            return Arrays.equals(((NSArray)object).getArray(), this.array);
        }
        NSObject nSObject = NSObject.fromJavaObject(object);
        if (nSObject.getClass().equals(NSArray.class)) {
            return Arrays.equals(((NSArray)nSObject).getArray(), this.array);
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 89 * n + Arrays.deepHashCode(this.array);
        return n;
    }

    @Override
    public NSArray clone() {
        NSObject[] nSObjectArray = new NSObject[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            nSObjectArray[i] = this.array[i] != null ? this.array[i].clone() : null;
        }
        return new NSArray(nSObjectArray);
    }

    @Override
    public Object toJavaObject() {
        Object[] objectArray = new Object[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            objectArray[i] = this.array[i] == null ? null : this.array[i].toJavaObject();
        }
        return objectArray;
    }

    @Override
    public int compareTo(NSObject nSObject) {
        Objects.requireNonNull(nSObject);
        if (nSObject == this) {
            return 0;
        }
        if (nSObject instanceof NSArray) {
            NSArray nSArray = (NSArray)nSObject;
            if (nSArray.count() != this.count()) {
                return Integer.compare(this.count(), nSArray.count());
            }
            for (int i = 0; i < this.array.length; ++i) {
                int n = NSNull.wrap(this.array[i]).compareTo(NSNull.wrap(nSArray.array[i]));
                if (n == 0) continue;
                return n;
            }
            return 0;
        }
        return this.getClass().getName().compareTo(nSObject.getClass().getName());
    }

    @Override
    void toXML(StringBuilder stringBuilder, int n) {
        this.indent(stringBuilder, n);
        stringBuilder.append("<array>");
        stringBuilder.append(NSObject.NEWLINE);
        for (NSObject nSObject : this.array) {
            NSNull.wrap(nSObject).toXML(stringBuilder, n + 1);
            stringBuilder.append(NSObject.NEWLINE);
        }
        this.indent(stringBuilder, n);
        stringBuilder.append("</array>");
    }

    @Override
    void assignIDs(BinaryPropertyListWriter binaryPropertyListWriter) {
        super.assignIDs(binaryPropertyListWriter);
        for (NSObject nSObject : this.array) {
            nSObject.assignIDs(binaryPropertyListWriter);
        }
    }

    @Override
    void toBinary(BinaryPropertyListWriter binaryPropertyListWriter) throws IOException {
        binaryPropertyListWriter.writeIntHeader(10, this.array.length);
        for (NSObject nSObject : this.array) {
            binaryPropertyListWriter.writeID(binaryPropertyListWriter.getID(nSObject));
        }
    }

    public String toASCIIPropertyList() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toASCII(stringBuilder, 0);
        stringBuilder.append(NEWLINE);
        return stringBuilder.toString();
    }

    public String toGnuStepASCIIPropertyList() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toASCIIGnuStep(stringBuilder, 0);
        stringBuilder.append(NEWLINE);
        return stringBuilder.toString();
    }

    @Override
    protected void toASCII(StringBuilder stringBuilder, int n) {
        this.toASCII(stringBuilder, n, false);
    }

    @Override
    protected void toASCIIGnuStep(StringBuilder stringBuilder, int n) {
        this.toASCII(stringBuilder, n, true);
    }

    private void toASCII(StringBuilder stringBuilder, int n, boolean bl) {
        this.indent(stringBuilder, n);
        stringBuilder.append('(');
        int n2 = stringBuilder.lastIndexOf(NEWLINE);
        for (int i = 0; i < this.array.length; ++i) {
            NSObject nSObject = NSNull.wrap(this.array[i]);
            Class<?> clazz = nSObject.getClass();
            if ((clazz.equals(NSDictionary.class) || clazz.equals(NSArray.class) || clazz.equals(NSData.class)) && n2 != stringBuilder.length()) {
                stringBuilder.append(NEWLINE);
                n2 = stringBuilder.length();
                if (bl) {
                    nSObject.toASCIIGnuStep(stringBuilder, n + 1);
                } else {
                    nSObject.toASCII(stringBuilder, n + 1);
                }
            } else {
                if (i != 0) {
                    stringBuilder.append(' ');
                }
                if (bl) {
                    nSObject.toASCIIGnuStep(stringBuilder, 0);
                } else {
                    nSObject.toASCII(stringBuilder, 0);
                }
            }
            if (i != this.array.length - 1) {
                stringBuilder.append(',');
            }
            if (stringBuilder.length() - n2 <= 80) continue;
            stringBuilder.append(NEWLINE);
            n2 = stringBuilder.length();
        }
        stringBuilder.append(')');
    }
}

