/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryLocationInformation;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSSet;
import com.dd.plist.NSString;
import com.dd.plist.ParsedObjectStack;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import com.dd.plist.UID;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.BiFunction;

public final class BinaryPropertyListParser {
    private static final int SIMPLE_TYPE = 0;
    private static final int INT_TYPE = 1;
    private static final int REAL_TYPE = 2;
    private static final int DATE_TYPE = 3;
    private static final int DATA_TYPE = 4;
    private static final int ASCII_STRING_TYPE = 5;
    private static final int UTF16_STRING_TYPE = 6;
    private static final int UTF8_STRING_TYPE = 7;
    private static final int UID_TYPE = 8;
    private static final int ARRAY_TYPE = 10;
    private static final int ORDERED_SET_TYPE = 11;
    private static final int SET_TYPE = 12;
    private static final int DICTIONARY_TYPE = 13;
    private int majorVersion;
    private int minorVersion;
    private byte[] bytes;
    private int objectRefSize;
    private int offsetSize;
    private int numObjects;
    private int offsetTableOffset;
    private final HashMap<Integer, NSObject> parsedObjects = new HashMap();

    private BinaryPropertyListParser() {
    }

    public static NSObject parse(File file) throws IOException, PropertyListFormatException {
        return BinaryPropertyListParser.parse(file.toPath());
    }

    public static NSObject parse(Path path) throws IOException, PropertyListFormatException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = BinaryPropertyListParser.parse(inputStream);
            return nSObject;
        }
    }

    public static NSObject parse(InputStream inputStream) throws IOException, PropertyListFormatException {
        return BinaryPropertyListParser.parse(PropertyListParser.readAll(inputStream));
    }

    public static NSObject parse(byte[] byArray) throws PropertyListFormatException, UnsupportedEncodingException {
        BinaryPropertyListParser binaryPropertyListParser = new BinaryPropertyListParser();
        return binaryPropertyListParser.doParse(byArray);
    }

    public static long parseUnsignedInt(byte[] byArray) {
        return BinaryPropertyListParser.parseUnsignedInt(byArray, 0, byArray.length);
    }

    public static long parseUnsignedInt(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = n; i < n2; ++i) {
            l <<= 8;
            l |= (long)(byArray[i] & 0xFF);
        }
        return l &= 0xFFFFFFFFL;
    }

    public static long parseLong(byte[] byArray) {
        return BinaryPropertyListParser.parseLong(byArray, 0, byArray.length);
    }

    public static long parseLong(byte[] byArray, int n, int n2) {
        long l = 0L;
        for (int i = n; i < n2; ++i) {
            l <<= 8;
            l |= (long)(byArray[i] & 0xFF);
        }
        return l;
    }

    public static double parseDouble(byte[] byArray) {
        return BinaryPropertyListParser.parseDouble(byArray, 0, byArray.length);
    }

    public static double parseDouble(byte[] byArray, int n, int n2) {
        if (n2 - n == 8) {
            return Double.longBitsToDouble(BinaryPropertyListParser.parseLong(byArray, n, n2));
        }
        if (n2 - n == 4) {
            return Float.intBitsToFloat((int)BinaryPropertyListParser.parseLong(byArray, n, n2));
        }
        throw new IllegalArgumentException("endIndex (" + n2 + ") - startIndex (" + n + ") != 4 or 8");
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException("startIndex (" + n + ") > endIndex (" + n2 + ")");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, n3);
        return byArray2;
    }

    private NSObject doParse(byte[] byArray) throws PropertyListFormatException {
        Objects.requireNonNull(byArray);
        if (byArray.length < 8) {
            throw new PropertyListFormatException("The available binary property list data is too short.");
        }
        this.bytes = byArray;
        String string = new String(BinaryPropertyListParser.copyOfRange(this.bytes, 0, 8), StandardCharsets.US_ASCII);
        if (!(string.startsWith("bplist") && string.length() >= 8 && Character.isDigit(string.charAt(6)) && Character.isDigit(string.charAt(7)))) {
            throw new PropertyListFormatException("The binary property list has an invalid file header: " + string);
        }
        this.majorVersion = string.charAt(6) - 48;
        this.minorVersion = string.charAt(7) - 48;
        if (this.majorVersion > 0) {
            throw new PropertyListFormatException("Unsupported binary property list format: v" + this.majorVersion + "." + this.minorVersion + ". Version 1.0 and later are not yet supported.");
        }
        if (this.bytes.length < 40) {
            throw new PropertyListFormatException("The binary property list does not contain a complete object offset table.");
        }
        byte[] byArray2 = BinaryPropertyListParser.copyOfRange(this.bytes, this.bytes.length - 32, this.bytes.length);
        this.offsetSize = (int)BinaryPropertyListParser.parseUnsignedInt(byArray2, 6, 7);
        this.objectRefSize = (int)BinaryPropertyListParser.parseUnsignedInt(byArray2, 7, 8);
        this.numObjects = (int)BinaryPropertyListParser.parseUnsignedInt(byArray2, 8, 16);
        int n = (int)BinaryPropertyListParser.parseUnsignedInt(byArray2, 16, 24);
        this.offsetTableOffset = (int)BinaryPropertyListParser.parseUnsignedInt(byArray2, 24, 32);
        if (this.offsetTableOffset + (this.numObjects + 1) * this.offsetSize > this.bytes.length || n >= this.bytes.length - 32) {
            throw new PropertyListFormatException("The binary property list contains a corrupted object offset table.");
        }
        return this.parseObject(ParsedObjectStack.empty(), n);
    }

    private NSObject parseObject(ParsedObjectStack parsedObjectStack, int n3) throws PropertyListFormatException {
        NSObject nSObject;
        parsedObjectStack = parsedObjectStack.push(n3);
        if (this.parsedObjects.containsKey(n3)) {
            return this.parsedObjects.get(n3);
        }
        int n4 = this.getObjectOffset(n3);
        BinaryLocationInformation binaryLocationInformation = new BinaryLocationInformation(n3, n4);
        byte by = this.bytes[n4];
        int n5 = (by & 0xF0) >> 4;
        int n6 = by & 0xF;
        try {
            switch (n5) {
                case 0: {
                    nSObject = this.parseSimpleObject(n4, n6, n3);
                    break;
                }
                case 1: {
                    nSObject = this.parseNumber(n4, n6, 0);
                    break;
                }
                case 2: {
                    nSObject = this.parseNumber(n4, n6, 1);
                    break;
                }
                case 3: {
                    nSObject = this.parseDate(n4, n6);
                    break;
                }
                case 4: {
                    nSObject = this.parseData(n4, n6);
                    break;
                }
                case 5: {
                    nSObject = this.parseString(n4, n6, (n, n2) -> n2, StandardCharsets.US_ASCII.name());
                    break;
                }
                case 6: {
                    nSObject = this.parseString(n4, n6, (n, n2) -> 2 * n2, StandardCharsets.UTF_16BE.name());
                    break;
                }
                case 7: {
                    nSObject = this.parseString(n4, n6, this::calculateUtf8StringLength, StandardCharsets.UTF_8.name());
                    break;
                }
                case 8: {
                    nSObject = this.parseUid(n3, n4, n6 + 1);
                    break;
                }
                case 10: {
                    nSObject = this.parseArray(n4, n6, parsedObjectStack);
                    break;
                }
                case 11: {
                    nSObject = this.parseSet(n4, n6, true, parsedObjectStack);
                    break;
                }
                case 12: {
                    nSObject = this.parseSet(n4, n6, false, parsedObjectStack);
                    break;
                }
                case 13: {
                    nSObject = this.parseDictionary(n4, n6, parsedObjectStack);
                    break;
                }
                default: {
                    throw new PropertyListFormatException(this.buildTypeError(n4));
                }
            }
        }
        catch (PropertyListFormatException propertyListFormatException) {
            if (propertyListFormatException.getLocationInformation() == null) {
                propertyListFormatException.setLocationInformation(binaryLocationInformation);
            }
            throw propertyListFormatException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PropertyListFormatException("The encoding of the NSString at offset " + n4 + " is not supported.", binaryLocationInformation, unsupportedEncodingException);
        }
        if (nSObject != null) {
            nSObject.setLocationInformation(binaryLocationInformation);
        }
        this.parsedObjects.put(n3, nSObject);
        return nSObject;
    }

    private NSDate parseDate(int n, int n2) throws PropertyListFormatException {
        if (n2 != 3) {
            throw new PropertyListFormatException(this.buildTypeError(n, "NSDate"));
        }
        if (n + 9 > this.bytes.length) {
            throw new PropertyListFormatException(BinaryPropertyListParser.buildLengthError(n, "NSDate"));
        }
        return new NSDate(this.bytes, n + 1, n + 9);
    }

    private NSData parseData(int n, int n2) throws PropertyListFormatException {
        int n3;
        int[] nArray = this.readLengthAndOffset(n2, n);
        int n4 = n + nArray[1];
        if (n4 + (n3 = nArray[0]) > this.bytes.length) {
            throw new PropertyListFormatException(BinaryPropertyListParser.buildLengthError(n, "NSData"));
        }
        return new NSData(BinaryPropertyListParser.copyOfRange(this.bytes, n4, n4 + n3));
    }

    private NSObject parseSimpleObject(int n, int n2, int n3) throws PropertyListFormatException {
        switch (n2) {
            case 0: {
                return null;
            }
            case 8: {
                return new NSNumber(false);
            }
            case 9: {
                return new NSNumber(true);
            }
            case 12: 
            case 13: {
                throw new PropertyListFormatException("The NSObject at offset " + n + " is a URL, which is not supported.");
            }
            case 14: {
                return this.parseUid(n3, n, 16);
            }
        }
        throw new PropertyListFormatException(this.buildTypeError(n));
    }

    private UID parseUid(int n, int n2, int n3) throws PropertyListFormatException {
        if (n2 + 1 + n3 >= this.bytes.length) {
            throw new PropertyListFormatException(BinaryPropertyListParser.buildLengthError(n2, "UID"));
        }
        return new UID(String.valueOf(n), BinaryPropertyListParser.copyOfRange(this.bytes, n2 + 1, n2 + 1 + n3));
    }

    private NSNumber parseNumber(int n, int n2, int n3) throws PropertyListFormatException {
        int n4 = (int)Math.pow(2.0, n2);
        try {
            return new NSNumber(this.bytes, n + 1, n + 1 + n4, n3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new PropertyListFormatException(BinaryPropertyListParser.buildLengthError(n, "NSNumber"), indexOutOfBoundsException);
        }
    }

    private NSString parseString(int n, int n2, BiFunction<Integer, Integer, Integer> biFunction, String string) throws PropertyListFormatException, UnsupportedEncodingException {
        int n3;
        int[] nArray = this.readLengthAndOffset(n2, n);
        int n4 = n + nArray[1];
        if (n4 + (n3 = biFunction.apply(n4, nArray[0]).intValue()) > this.bytes.length) {
            throw new PropertyListFormatException(BinaryPropertyListParser.buildLengthError(n, "NSString"));
        }
        return new NSString(this.bytes, n4, n4 + n3, string);
    }

    private NSArray parseArray(int n, int n2, ParsedObjectStack parsedObjectStack) throws PropertyListFormatException, UnsupportedEncodingException {
        int[] nArray = this.readLengthAndOffset(n2, n);
        int n3 = nArray[0];
        int n4 = n + nArray[1];
        NSArray nSArray = new NSArray(n3);
        for (int i = 0; i < n3; ++i) {
            int n5 = this.parseObjectReferenceFromList(n4, i);
            nSArray.setValue(i, this.parseObject(parsedObjectStack, n5));
        }
        return nSArray;
    }

    private NSSet parseSet(int n, int n2, boolean bl, ParsedObjectStack parsedObjectStack) throws PropertyListFormatException, UnsupportedEncodingException {
        int[] nArray = this.readLengthAndOffset(n2, n);
        int n3 = nArray[0];
        int n4 = n + nArray[1];
        NSSet nSSet = new NSSet(bl);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < n3; ++i) {
            int n5 = this.parseObjectReferenceFromList(n4, i);
            if (!hashSet.add(n5)) continue;
            nSSet.addObject(this.parseObject(parsedObjectStack, n5));
        }
        return nSSet;
    }

    private NSDictionary parseDictionary(int n, int n2, ParsedObjectStack parsedObjectStack) throws PropertyListFormatException, UnsupportedEncodingException {
        int[] nArray = this.readLengthAndOffset(n2, n);
        int n3 = nArray[0];
        int n4 = nArray[1];
        int n5 = n + n4;
        int n6 = n5 + n3 * this.objectRefSize;
        NSDictionary nSDictionary = new NSDictionary();
        for (int i = 0; i < n3; ++i) {
            int n7 = this.parseObjectReferenceFromList(n5, i);
            int n8 = this.parseObjectReferenceFromList(n6, i);
            NSObject nSObject = this.parseObject(parsedObjectStack, n7);
            if (nSObject == null) {
                throw new PropertyListFormatException("The key #" + (i + 1) + " of the NSDictionary at offset " + n + " is NULL.");
            }
            NSObject nSObject2 = this.parseObject(parsedObjectStack, n8);
            nSDictionary.put(nSObject.toString(), nSObject2);
        }
        return nSDictionary;
    }

    private int[] readLengthAndOffset(int n, int n2) throws PropertyListFormatException {
        try {
            int n3 = n;
            int n4 = 1;
            if (n == 15) {
                byte by = this.bytes[n2 + 1];
                int n5 = (by & 0xF0) >> 4;
                if (n5 != 1) {
                    System.err.println("BinaryPropertyListParser: Length integer has an unexpected type (" + n5 + "). Attempting to parse anyway...");
                }
                int n6 = by & 0xF;
                int n7 = (int)Math.pow(2.0, n6);
                n4 = 2 + n7;
                n3 = n7 < 3 ? (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, n2 + 2, n2 + 2 + n7) : new BigInteger(BinaryPropertyListParser.copyOfRange(this.bytes, n2 + 2, n2 + 2 + n7)).intValue();
            }
            return new int[]{n3, n4};
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            throw new PropertyListFormatException("The length/offset integer at offset " + n2 + " is invalid.", runtimeException);
        }
    }

    private int calculateUtf8StringLength(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = n + n3;
            if (this.bytes.length <= n4) {
                return n2;
            }
            byte by = this.bytes[n4];
            if ((by & 0x80) != 128) {
                ++n3;
                continue;
            }
            int n5 = 0;
            if ((by & 0xC0) == 128) {
                return n2;
            }
            if ((by & 0xE0) == 192) {
                n5 = 1;
            } else if ((by & 0xF0) == 224) {
                n5 = 2;
            } else if ((by & 0xF8) == 240) {
                n5 = 3;
            }
            if (this.hastUtf8Sequence(n4, n5)) {
                n3 += 2;
                continue;
            }
            return n2;
        }
        return n3;
    }

    private boolean hastUtf8Sequence(int n, int n2) {
        for (int i = 1; i <= n2; ++i) {
            if (n + i < this.bytes.length && (this.bytes[n + i] & 0xC0) == 128) continue;
            return false;
        }
        return true;
    }

    private int parseObjectReferenceFromList(int n, int n2) throws PropertyListFormatException {
        return this.parseObjectReference(n + n2 * this.objectRefSize);
    }

    private int parseObjectReference(int n) throws PropertyListFormatException {
        if (n + this.objectRefSize >= this.bytes.length) {
            throw new PropertyListFormatException("Encountered the end of the file while parsing the object reference at offset " + n + ".");
        }
        return (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, n, n + this.objectRefSize);
    }

    private int getObjectOffset(int n) throws PropertyListFormatException {
        if (n >= this.numObjects) {
            throw new PropertyListFormatException("The given binary property list contains an invalid object identifier (" + n + ").");
        }
        int n2 = this.offsetTableOffset + n * this.offsetSize;
        return (int)BinaryPropertyListParser.parseUnsignedInt(this.bytes, n2, n2 + this.offsetSize);
    }

    private String buildTypeError(int n) {
        return this.buildTypeError(n, "NSObject");
    }

    private String buildTypeError(int n, String string) {
        return String.format("The %s at offset %d has an unknown or unsupported type (0x%02x)", string, n, this.bytes[n]);
    }

    private static String buildLengthError(int n, String string) {
        return String.format("The length of the %s at offset %d is larger than the amount of available data.", string, n);
    }
}

