/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.quartz;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.TimerTask;
import org.quartz.core.QuartzScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateChecker
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateChecker.class);
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final String UNKNOWN = "UNKNOWN";
    private static final String UPDATE_CHECK_URL = "http://www.terracotta.org/kit/reflector?kitID=quartz&pageID=update.properties";
    private static final long START_TIME = System.currentTimeMillis();
    private static final String PRODUCT_NAME = "Quartz Terracotta";

    @Override
    public void run() {
        this.checkForUpdate();
    }

    public void checkForUpdate() {
        try {
            if (!Boolean.getBoolean("org.terracotta.quartz.skipUpdateCheck")) {
                this.doCheck();
            }
        }
        catch (Throwable throwable) {
            LOG.debug("Update check failed: " + throwable.toString());
        }
    }

    private void doCheck() throws IOException {
        LOG.debug("Checking for update...");
        URL uRL = this.buildUpdateCheckUrl();
        Properties properties = this.getUpdateProperties(uRL);
        String string = this.getQuartzVersion();
        String string2 = properties.getProperty("general.notice");
        if (this.notBlank(string2)) {
            LOG.info(string2);
        }
        if (this.notBlank(string2 = properties.getProperty(string + ".notices"))) {
            LOG.info(string2);
        }
        if (this.notBlank(string2 = properties.getProperty(string + ".updates"))) {
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i].trim();
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(string3);
                string2 = properties.getProperty(string3 + ".release-notes");
                if (!this.notBlank(string2)) continue;
                stringBuilder.append(" [");
                stringBuilder.append(string2);
                stringBuilder.append("]");
            }
            if (stringBuilder.length() > 0) {
                LOG.info("New update(s) found: " + stringBuilder.toString());
            }
        }
    }

    private String getQuartzVersion() {
        return String.format("%s.%s.%s", QuartzScheduler.getVersionMajor(), QuartzScheduler.getVersionMinor(), QuartzScheduler.getVersionIteration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getUpdateProperties(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        try {
            Properties properties = new Properties();
            properties.load(uRLConnection.getInputStream());
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private URL buildUpdateCheckUrl() throws MalformedURLException, UnsupportedEncodingException {
        String string = System.getProperty("quartz.update-check.url", UPDATE_CHECK_URL);
        String string2 = string.indexOf(63) > 0 ? "&" : "?";
        return new URL(string + string2 + this.buildParamsString());
    }

    private String buildParamsString() throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id=");
        stringBuilder.append(this.getClientId());
        stringBuilder.append("&os-name=");
        stringBuilder.append(this.urlEncode(this.getProperty("os.name")));
        stringBuilder.append("&jvm-name=");
        stringBuilder.append(this.urlEncode(this.getProperty("java.vm.name")));
        stringBuilder.append("&jvm-version=");
        stringBuilder.append(this.urlEncode(this.getProperty("java.version")));
        stringBuilder.append("&platform=");
        stringBuilder.append(this.urlEncode(this.getProperty("os.arch")));
        stringBuilder.append("&tc-version=");
        stringBuilder.append(this.urlEncode(this.getQuartzVersion()));
        stringBuilder.append("&tc-product=");
        stringBuilder.append(this.urlEncode(PRODUCT_NAME));
        stringBuilder.append("&source=");
        stringBuilder.append(this.urlEncode(PRODUCT_NAME));
        stringBuilder.append("&uptime-secs=");
        stringBuilder.append(this.getUptimeInSeconds());
        stringBuilder.append("&patch=");
        stringBuilder.append(this.urlEncode(UNKNOWN));
        return stringBuilder.toString();
    }

    private long getUptimeInSeconds() {
        long l = System.currentTimeMillis() - START_TIME;
        return l > 0L ? l / 1000L : 0L;
    }

    private int getClientId() {
        try {
            return InetAddress.getLocalHost().hashCode();
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private String urlEncode(String string) throws UnsupportedEncodingException {
        return URLEncoder.encode(string, "UTF-8");
    }

    private String getProperty(String string) {
        return System.getProperty(string, UNKNOWN);
    }

    private boolean notBlank(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static void main(String[] stringArray) {
        new UpdateChecker().run();
    }
}

