/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import org.tanukisoftware.wrapper.security.WECollection;

public class WrapperEventPermission
extends Permission {
    public static String EVENT_TYPE_SERVICE = "service";
    public static String EVENT_TYPE_CONTROL = "control";
    public static String EVENT_TYPE_CORE = "core";
    private static int MASK_SERVICE = 1;
    private static int MASK_CONTROL = 2;
    private static int MASK_CORE = 65536;
    private static int MASK_ALL = MASK_SERVICE | MASK_CONTROL | MASK_CORE;
    private int m_eventTypeMask;

    public WrapperEventPermission(String string) {
        super("*");
        this.m_eventTypeMask = this.buildEventTypeMask(string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WrapperEventPermission)) {
            return false;
        }
        WrapperEventPermission wrapperEventPermission = (WrapperEventPermission)object;
        return this.m_eventTypeMask == wrapperEventPermission.m_eventTypeMask && this.getName().equals(wrapperEventPermission.getName());
    }

    public String getActions() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        if ((this.m_eventTypeMask & MASK_SERVICE) != 0) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = false;
            }
            stringBuffer.append(EVENT_TYPE_SERVICE);
        }
        if ((this.m_eventTypeMask & MASK_CONTROL) != 0) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = false;
            }
            stringBuffer.append(EVENT_TYPE_CONTROL);
        }
        if ((this.m_eventTypeMask & MASK_CORE) != 0) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = false;
            }
            stringBuffer.append(EVENT_TYPE_CORE);
        }
        return stringBuffer.toString();
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof WrapperEventPermission)) {
            return false;
        }
        WrapperEventPermission wrapperEventPermission = (WrapperEventPermission)permission;
        return (this.m_eventTypeMask & wrapperEventPermission.m_eventTypeMask) == wrapperEventPermission.m_eventTypeMask && this.impliesIgnoreEventTypeMask(wrapperEventPermission);
    }

    public PermissionCollection newPermissionCollection() {
        return new WECollection();
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    int getActionMask() {
        return this.m_eventTypeMask;
    }

    boolean impliesIgnoreEventTypeMask(WrapperEventPermission wrapperEventPermission) {
        if (this.getName().equals(wrapperEventPermission.getName())) {
            return true;
        }
        return wrapperEventPermission.getName().endsWith("*") && this.getName().startsWith(wrapperEventPermission.getName().substring(0, wrapperEventPermission.getName().length() - 1));
    }

    private int buildEventTypeMask(String string) {
        if (string == EVENT_TYPE_SERVICE) {
            return MASK_SERVICE;
        }
        if (string == EVENT_TYPE_CONTROL) {
            return MASK_CONTROL;
        }
        if (string == EVENT_TYPE_CORE) {
            return MASK_CORE;
        }
        if (string.equals("*")) {
            return MASK_ALL;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(EVENT_TYPE_SERVICE)) {
                n |= MASK_SERVICE;
                continue;
            }
            if (string2.equals(EVENT_TYPE_CONTROL)) {
                n |= MASK_CONTROL;
                continue;
            }
            if (string2.equals(EVENT_TYPE_CORE)) {
                n |= MASK_CORE;
                continue;
            }
            throw new IllegalArgumentException("Invalid permission eventType: \"" + string2 + "\"");
        }
        return n;
    }
}

