/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

public class WrapperWin32Service {
    public static final int SERVICE_STATE_STOPPED = 1;
    public static final int SERVICE_STATE_START_PENDING = 2;
    public static final int SERVICE_STATE_STOP_PENDING = 3;
    public static final int SERVICE_STATE_RUNNING = 4;
    public static final int SERVICE_STATE_CONTINUE_PENDING = 5;
    public static final int SERVICE_STATE_PAUSE_PENDING = 6;
    public static final int SERVICE_STATE_PAUSED = 7;
    private String m_name;
    private String m_displayName;
    private int m_serviceState;
    private int m_exitCode;

    WrapperWin32Service(byte[] byArray, byte[] byArray2, int n, int n2) {
        this.m_name = new String(byArray);
        this.m_displayName = new String(byArray2);
        this.m_serviceState = n;
        this.m_exitCode = n2;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDisplayName() {
        return this.m_displayName;
    }

    public String getServiceStateName() {
        int n = this.getServiceState();
        switch (n) {
            case 1: {
                return "STOPPED";
            }
            case 2: {
                return "START_PENDING";
            }
            case 3: {
                return "STOP_PENDING";
            }
            case 4: {
                return "RUNNING";
            }
            case 5: {
                return "CONTINUE_PENDING";
            }
            case 6: {
                return "PAUSE_PENDING";
            }
            case 7: {
                return "PAUSED";
            }
        }
        return "UNKNOWN(" + n + ")";
    }

    public int getServiceState() {
        return this.m_serviceState;
    }

    public int getExitCode() {
        return this.m_exitCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WrapperWin32Service[name=\"");
        stringBuffer.append(this.getName());
        stringBuffer.append("\", displayName=\"");
        stringBuffer.append(this.getDisplayName());
        stringBuffer.append("\", state=");
        stringBuffer.append(this.getServiceStateName());
        stringBuffer.append(", exitCode=");
        stringBuffer.append(this.getExitCode());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

